﻿using System.Windows.Forms;

namespace com.andoutomo.kybernetes.view
{
    public class YesNoDialog
    {
        public static bool show(string prompt,ActionForMessage actionForYes,ActionForMessage actionForNo )
        {
            bool retval = false;
            DialogResult res = MessageBox.Show(prompt, "Kybernetes Input System", MessageBoxButtons.YesNo, MessageBoxIcon.Question);

            switch (res)
            {
                case DialogResult.Yes:
                    actionForYes();
                    retval = true;
                    break;
                case DialogResult.No:
                    actionForNo();
                    break;
            }

            return retval;
        }
        public static bool show(string prompt)
        {
            DialogResult res = MessageBox.Show(prompt, "Kybernetes Input System", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            return res == DialogResult.Yes;
        }
    }
    public delegate void ActionForMessage();
}
