<?php
/*!
  \file
  \brief LangUpload 饹

  \author Satofumi KAMIMURA

  $Id$

  \todo ̤顢doxygen оݤ includes/*.php ˤ
*/


/*!
  \brief 桼饹
*/
class UserAuthorize {
  var $reload_action;		//!< ڡɤɬפп
  var $login_fail;		//!< ǧڤ˼Ԥ˿

  /*!
    \brief 󥹥ȥ饯
  */
  function UserAuthorize() {
    $this->reload_action = false;
    $this->login_fail = false;

    // å򳫻Ϥμ
    session_name('LANGUPLOADSID');
    session_start();

    // Ƚ
    if (isset($_GET['logout_submit'])) {
      $this->logout();
      return;
    }

    // 
    if (isset($_POST['login_submit']) &&
	isset($_POST['login_name']) && isset($_POST['login_password'])) {
      $login_name = $_POST['login_name'];
      if (! $this->login($login_name, $_POST['login_password'])) {
	return;
      }
      // 
      $_SESSION['brows_name'] = $_SESSION['login_name'];
    }

    // 桼ѹ
    if (isset($_GET['brows_name'])) {
      // !!! ¸ߤ桼ǧ٤
      $_SESSION['brows_name'] = $_GET['brows_name'];
    }
  }


  /*!
    \brief 

    \todo ǧڽ
  */
  function login($name, $password) {

    if (preg_match('/[^A-Za-z0-9_]/', $name)) {
      $this->login_fail = true;
      return false;
    }

    // ե뤫ѥʸ
    $this->login_fail = true;
    $fp = @fopen($_SESSION['users_file'], 'r');
    if ($fp != false) {
      while (! feof($fp)) {
	$line = fgets($fp);
	$user = strtok($line, "\n\t ");
	$recorded_password = strtok("\n\t ");
	if ($user == $name) {
	  if (crypt($password, $recorded_password) == $recorded_password) {
	    $_SESSION['login_name'] = $name;
	    $this->reload_action = true;
	    $this->login_fail = false;
	    break;
	  }
	}
      }
      fclose($fp);
    } else {
      // 桼ե뤬¸ߤʤ硢admin ѥɤɲä
      $fp = fopen($_SESSION['users_file'], 'w');
      if ($fp != false) {
	$line = "admin\t". crypt('admin'). "\n";
	fwrite($fp, $line);
	fclose($fp);
	$_SESSION['login_name'] = 'admin';
	$this->reload_acton = true;
	$this->login_fail = false;
      }
    }
    return ! $this->login_fail;
  }


  /*!
    \brief Ƚ
  */
  function logout() {

    // å˴
    $_SESSION = array();
    if (isset($_COOKIE[session_name()])) {
      setcookie(session_name(), '', time()-42000, '/');
    }
    session_destroy();
    $this->reload_action = true;
  }


  /*!
    \brief 󤷤Ƥп֤
  */
  function isLogin() {
    return (array_key_exists('login_name', $_SESSION)) ? true : false;
  }


  /*!
    \brief ľΥ˼ԤƤп֤
  */
  function loginFail() {
    return $this->login_fail;
  }


  /*!
    \brief ׵᤬п֤
  */
  function requireReload() {
    return $this->reload_action;
  }


  /*!
    \brief ̾μ
  */
  function getLoginName() {
    return ($this->isLogin() ? $_SESSION['login_name'] : "");
  }


  /*!
    \brief 桼̾μ
  */
  function getBrowsName() {
    return $_SESSION['brows_name'];
  }


  /*!
    \brief ¸ߤ桼̾μ
  */
  function getUserNames() {

    $users = array();
    $fp = @fopen($_SESSION['users_file'], 'r');
    if ($fp != false) {
      while (! feof($fp)) {
	$line = fgets($fp);
	$user = strtok($line, "\n\t ");
	if (strlen($user) && ($user != 'admin')) {
	  array_push($users, $user);
	}
      }
      fclose($fp);
    }
    return $users;
  }
};


/*!
  \brief ڡδ饹

  \todo ;ϤСˤĤƤ doxygen Ԥ
*/
class LangUpload {
  var $programs_exist;		//!< ¸ߤ
  var $programs_mtime;
  var $comments_exist;		//!< Ȥ¸ߤ
  var $comments_mtime;
  var $send_comment;
  var $program_updated;


  /*!
    \brief 󥹥ȥ饯

    \attention UserAuthorize ѤߤȤ
    \todo PHP Сƥεˡɤľ
  */
  function LangUpload() {

    // ե뤫νͤɤ߽Ф
    if (! array_key_exists('admin_mail_address', $_SESSION)) {
      require_once('config.php');

      $_SESSION['admin_mail_address'] =
	isset($admin_mail_address) ? $admin_mail_address : "no mail address";
      $_SESSION['users_file'] =
	isset($users_file) ? $users_file : 'data/users.txt';
      $_SESSION['project_title'] =
	isset($project_title) ? $project_title : 'Lang Upload';
      $_SESSION['problems_num'] =
	isset($problems_num) ? $problems_num : array();
      $_SESSION['enscript_bin'] =
	isset($enscript_bin) ? $enscript_bin : '';
      $_SESSION['admins'] = isset($admins) ? $admins : array();
    }
    $this->programs_exist = array();
    $this->programs_mtime = array();
    $this->comments_exist = array();
    $this->comments_mtime = array();
    $this->send_comment = false;
    $this->program_updated = false;

    // åץɥեν
    if (isset($_FILES) && isset($_FILES['userfile']['tmp_name'])) {
      $this->uploadProgram($_FILES['userfile']['tmp_name'],
			   $_FILES['userfile']['name']);
    }

    // ڡѹ
    if (isset($_GET['chapter'])) {
      // !!! ¸ߤϤǧ٤
      $_SESSION['chapter'] = intval($_GET['chapter']);
    }
    if (isset($_GET['no'])) {
      // !!! ¸ߤֹ椫ǧ٤
      $_SESSION['no'] = intval($_GET['no']);
    }
  }


  function programUpdated() {
    return $this->program_updated;
  }


  function sendComment() {
    return $this->send_comment;
  }


  /*!
    \brief Сɽ
  */
  function printVersionInfo() {
    $out = '';
    $out .= '<table class=main border=0 cellspacing=3 width=500 cellpadding=3>'
      .'<tr><td><h2>LangUpload ChangeLog</h2><div class="frame">';

    $fp = fopen('version.txt', 'r');
    if ($fp == false) {
      $out .= 'no file: version.txt';
    } else {
      while (! feof($fp)) {
	$line = fgets($fp);
	if (preg_match('/(\d\d\d\d\/\d\d\/\d\d)/', $line, $matches)) {
	  $out .= '<h3>'. $line. '</h3>';
	} else if (preg_match('/---/', $line)) {
	  continue;
	} else {
	  $replaced = htmlspecialchars($line);
	  $out .= preg_replace('/\n/', '<br>', $replaced);
	}
      }
      fclose($fp);
    }

    $out .= '</td></tr></table>';
    return $out;
  }


  /*!
    \brief ԤǤп֤
  */
  function isManager() {
    if (in_array($_SESSION['login_name'], $_SESSION['admins']) ||
	($_SESSION['login_name'] == 'admin')) {
      return true;
    } else {
      return false;
    }
  }


  /*!
    \brief եΥåץɽ
  */
  function uploadProgram($uploaded_file, $file_name) {
    $login_name = $_SESSION['login_name'];
    $this->createFilesHash($login_name);

    $uploaddir = 'data/'. $login_name. '/';
    $key = $this->getChapter(). '-'. $this->getNo();
    $rev = array_key_exists($key, $this->programs_exist) ?
      $this->programs_exist[$key] : 0;
    $next_rev = $rev + 1;

    $file = 'p'. $key. '-'. $next_rev. '.txt';
    $to_file = $uploaddir. $file;
    if (! move_uploaded_file($uploaded_file, $to_file)) {
      // print "Possible file upload attack!\n";
      // !!! ȤΤ˻Ĥ
    } else {
      // !!! file_name 򸵤ˡprograms.txt 
      $fp = fopen($uploaddir. 'programs.txt', 'a');
      if ($fp != false) {
	$line = $file. "\t". $file_name. "\n";
	fwrite($fp, $line);
	fclose($fp);
      }
      $this->program_updated = true;
    }
  }


  /*!
    \brief ץȥȥμ
  */
  function getTitle() {
    return $_SESSION['project_title'];
  }


  /*!
    \brief ԤΥ᡼륢ɥ쥹
  */
  function getAdminMailAddress() {
    return $_SESSION['admin_mail_address'];
  }


  /*!
    \brief ֹμ
  */
  function getChapter() {
    return $_SESSION['chapter'];
  }


  /*!
    \brief ֹμ
  */
  function getNo() {
    return $_SESSION['no'];
  }


  /*!
    \brief ϥ󥯤κ

    \todo ̤ɥȤΤֹϡ
  */
  function createChapterLink($chapter_label = 'Chap.') {
    $out = '';
    $out .= '<table><tr><th>'. $chapter_label. '</th>';

    $index = 1;
    foreach ($_SESSION['problems_num'] as $chapter) {
      $out .= '<td><a href=?chapter='.
	$index. '>&nbsp;'. $index. '&nbsp;</a></td>';
      ++$index;
    }
    $out .= '</tr></table>';
    return $out;
  }


  /*!
    \brief ֹ󥯤κ

    \todo ̤ɥȤΤֹϡ
    \todo ץब¸ߤСʬ褦ˤ
  */
  function createNoLink($chapter, $no_label = 'No.') {
    $out = '';
    $out .= '<table><tr><th>'. $no_label. '</th>';

    $n = $_SESSION['problems_num'][$chapter -1];
    for ($i = 0; $i < $n; ++$i) {
      $index = $i + 1;
      $out .= '<td><a href=?no='. $index. '>&nbsp;'. $index. '</a></td>';
    }
    $out .= '</tr></table>';
    return $out;
  }


  /*!
    \brief ̤ɥ󥯤ɤ
  */
  function createUnreadLink() {
    $out = '';
    $out .= '!!! ̤ɥȤɤ';

    return $out;
  }


  /*!
    \brief ᥤڡѤΥơ֥

    \todo Smarty ΰ̣礤̵...Ĥ
    \todo ̤ɥ󥯤ξϤʬ褦ɽ롣Ĥơ֥Ǥ狼뤫...
  */
  function createChapterTable($brows_name,
			      $chapter_view = 'Chapter. %d',
			      $total_tag = 'Total') {
    $ret = '';

    // Ľμ
    $exists = $this->getProgramExists($brows_name);

    $ret .= '<table border=1><tr><th></th><th>Ľ</th></tr>';

    $total_exists = 0;
    $total_problems = 0;
    $chapter_no = 1;
    foreach ($_SESSION['problems_num'] as $chapter_array) {
      // 󥯺
      $ret .= '<tr height=28><td>&nbsp;';
      $ret .= '<a href=chapterView.php?chapter='. $chapter_no. '>'.
	sprintf($chapter_view, $chapter_no). '</a>';

      // Ľκ
      $exists_num = $exists[0][$chapter_no -1];
      $total_num = $exists[1][$chapter_no -1];
      $progress = (int)(100.0 * $exists_num / $total_num);
      $images = '&nbsp;';
      $line = sprintf(" (%d/%d)</td><td width=255>%3d%% ",
		      $exists_num, $total_num, $progress);
      $ret .= preg_replace('/ /', '&nbsp;', $line);
      $ret .=
	sprintf('<img src=bar.png height=14 width=%d>',
		2 * $progress);
      $total_exists += $exists_num;
      $total_problems += $total_num;

      // Ȥ̵ͭΥղ
      // !!! ̤

      $ret .= '</td></tr>';
      ++$chapter_no;
    }

    // ΤοĽɽ
    $progress = (int)(100.0 * $total_exists / $total_problems);
    $ret .= '<tr height=28><td>&nbsp;'. $total_tag;
    $ret .= sprintf(' (%d/%d)</td><td width=255>&nbsp;%3d%% ',
		    $total_exists, $total_problems, $progress);
    $ret .= sprintf('<img src=bar.png height=16 width=%d>',
		    2 * $progress);
    $ret .= '</td></tr>';

    $ret .= '</table>';

    return $ret;
  }


  /*!
    \brief ץΥ˥塼ɽ

    \todo Τ⡢Smarty 褦˽
    \todo ̤ɤꡢɽʸǶĴɽ
  */
  function createProgramsTable($brows_name) {

    $chapter = $this->getChapter();
    if (! array_key_exists($chapter - 1, $_SESSION['problems_num'])) {
      // !!! åϤ٤
      return;
    }
    $this->createFilesHash($brows_name);

    $out = '';
    $out .= '<table border=1>';
    $out .= '<tr><th>No.</th><th>Program</th><th>Comment</th></tr>';

    for ($i = 0; $i < $_SESSION['problems_num'][$chapter - 1]; ++$i) {
      $no = $i + 1;
      $out .= '<tr><td><a href=programView.php?chapter='. $chapter.
	'&no='. $no. '>'. $chapter. '-'. $no. '</a></td>';
      $key = $chapter. '-'. ($i + 1);

      // ץ¸ɽ
      $out .= '<td>&nbsp;';
      if (array_key_exists($key, $this->programs_exist)) {
	$rev = $this->programs_exist[$key];
	$mtime = $this->programs_mtime[$key. '-'. $rev];
	$out .= date('Y-m-d', $mtime);
      }
      $out .= '&nbsp;</td>';

      // Ȥ¸ɽ
      $out .= '<td>&nbsp;';
      if (array_key_exists($key, $this->comments_exist)) {
	$rev = $this->comments_exist[$key];
	$mtime = $this->comments_mtime[$key. '-'. $rev];
	$out .= date('Y-m-d', $mtime);
      }
      $out .= '&nbsp;</td>';
      $out .= '</tr>';
    }
    $out .= '</table>';
    return $out;
  }


  /*!
    \brief Ĥ줿ץɽμ

    \todo ؿ̾ѹꡢȤ
    \todo enscript ʤȤνɲ
    \todo ե뤬ʤȤνˤĤˤ
  */
  function createProgramView($brows_name,
			     $no_program_message = 'No Program.') {

    $chapter = $this->getChapter();
    $no = $this->getNo();
    $this->createFilesHash($brows_name);

    $out = '';

    $key = $chapter. '-'. $no;
    if (! array_key_exists($key, $this->programs_exist)) {
      // !!! ե뤬ʤν
      // !!! ɽʤ餤ʡ
      $out .= $no_program_message;
      return $out;
    }
    $rev = $this->programs_exist[$key];
    $path = 'data/'. $brows_name. '/p'. $key. '-'. $rev. '.txt';

    $cmd = $_SESSION['enscript_bin'].
      ' --highlight=cpp --color --language html --toc --output - '. $path;
    ereg('(<PRE>.+</PRE>)', shell_exec($cmd), $prog);

    $out .= $prog[1];
    // !!! ʤˤʤСλݤ֤
    return $out;
  }


  /*!
    \brief ץΥåץɥե

    \todo Ͽνڡ򵭽Ҥ
  */
  function createUploadForm($message = 'Upload Program: ', $page) {

    return '<form enctype="multipart/form-data" action="'. $page. '" method="POST"><input type="hidden" name="MAX_FILE_SIZE" value="10000" />'. $message. '<input name="userfile" type="file" /><input type="submit" value="Send File" /></form>';
  }


  /*!
    \brief եδ򹹿

    \todo private ؿʤΤǡ̾ϽƤɽƤƤ褤Ȥˤ
    \todo 졢updateProgramsHash() ˤǤ̾
    \todo ȴ⤷Ƥ뤳ȤθƲ̾
  */
  function createFilesHash($brows_name) {

    $dir_name = 'data/'. $brows_name;
    @$dp = opendir($dir_name);
    if ($dp == false) {
      // !!! ǥ쥯ȥ꤬¸ߤʤ硣
      // !!! ȤΥåϤ٤
      // !!! षؿƤ֤٤
      return;
    }

    clearstatcache();		// !!! ɬפ
    while (($file = readdir($dp)) !== false) {
      if (preg_match('/p([\d]+-[\d])+-([\d])+\.txt/', $file, $matches)) {
	// pX-X-X.txt Ȥե뤬п
	$key = $matches[1];
	$rev = $matches[2];
	$this->programs_mtime[$key. '-'. $rev] =
	  filemtime($dir_name. '/'. $file);

	// ץ
	if (array_key_exists($key, $this->programs_exist)) {
	  $current_rev = $this->programs_exist[$key];
	  if ($rev > $current_rev) {
	    $this->programs_exist[$key] = $rev;
	  }
	} else {
	  $this->programs_exist[$key] = $rev;
	}
      }

      if (preg_match('/c([\d]+-[\d])+-([\d])+\.txt/', $file, $matches)) {
	// cX-X-X.txt Ȥե뤬п
	$key = $matches[1];
	$rev = $matches[2];
	$this->comments_mtime[$key. '-'. $rev] =
	  filemtime($dir_name. '/'. $file);

	// ȴ
	if (array_key_exists($key, $this->comments_exist)) {
	  $current_rev = $this->comments_exist[$key];
	  if ($rev > $current_rev) {
	    $this->comments_exist[$key] = $rev;
	  }
	} else {
	  $this->comments_exist[$key] = $rev;
	}
      }
    }

    $ret = array();
    return $ret;
  }


  /*!
    \brief ץϿ

    \todo Ƥȴؿ̾פƤʤΤ
  */
  function getProgramExists($brows_name) {
    $this->createFilesHash($brows_name);

    $exists = array();
    $index = 1;
    foreach ($_SESSION['problems_num'] as $chapter_problems) {
      $chapter_programs = 0;
      for ($i = 1; $i <= $chapter_problems; ++$i) {
	$key = $index. '-'. $i;
	if (array_key_exists($key, $this->programs_exist)) {
	  ++$chapter_programs;
	}
      }
      array_push($exists, $chapter_programs);
      ++$index;
    }
    return array($exists, $_SESSION['problems_num']);
  }


  /*!
    \brief ưѤΥ󥯤
  */
  function createInternalLink($chapter, $no) {
    $out = '<a href=main.php>Main Page</a>';
    if (($chapter > 0) && ($no <= 0)) {
      $out .= ' &gt;&gt; <strong>Chapter Page</strong>';
    }
    if (($chapter > 0) && ($no > 0)) {
      $out .= ' &gt;&gt; <a href=chapterView.php?chapter='. $chapter.
	'>Chapter Page</a> &gt;&gt; <strong>Program Page</strong>';
    }
    return $out;
  }


  /*!
    \brief 桼󥯤κ

    \todo Ϥơtpl ǥ󥯺褦˽롣Ĥ
  */
  function createUsersLink($user) {

    $users = $user->getUserNames();

    $out = '';
    foreach ($users as $each_name) {
      if ($_SESSION['brows_name'] == $each_name) {
	// !!! Ĵɽ
	$out .= $each_name;
      } else {
	$out .= '<a href=?brows_name='. $each_name. '>'. $each_name. '</a>';
      }
      $out .= ' ';
    }
    return $out;
  }


  // 桼Υե
  function createUsersSelectForm($user, $add_users = array()) {

    $out = '';
    $users = array_merge($user->getUserNames(), $add_users);
    foreach ($users as $login_name) {
      $out .= '<option value="'. $login_name. '"';
      if ($login_name == $_SESSION['brows_name']) {
	$out .= ' selected';
      }
      $out .= '>'. $login_name. '</option>';
    }
    return $out;
  }


  //桼ɲåե
  function addUserForm() {
    $out = '<form method=POST><input type=text name=add_user size=13>'.
      '&nbsp;<input type=submit name=add_user_submit value=Add></formt>';
    return $out;
  }


  // ѥѹե
  function changePasswordForm($user) {
    $out = '';
    $out .= '<form method=POST><select name=change_user>';

    $out .= $this->createUsersSelectForm($user, array('admin'));

    $out .= '</select><br>'.
      '<input type=password name=change_password size=13>'.
      '&nbsp;<input type=submit name=change_password_submit value=Change>'.
      '</form>';
    return $out;
  }


  // 桼ե
  function delUserForm($user) {
    $out = '';
    $out .= '<form method=POST><select name=del_user>';

    $out .= $this->createUsersSelectForm($user);

    $out .= '</select>'.
      '&nbsp;<input type=submit name=del_user_submit value=Delete></formt>';
    return $out;


    $out .= '</form>';
    return $out;
  }


  // ꥯȤν
  function handleAdminRequest() {

    // 桼ɲ
    if (array_key_exists('add_user_submit', $_POST)) {
      $name = $_POST['add_user'];

      // ̾ιʸå
      if (preg_match('/[^A-Za-z0-9_]/', $name)) {
	// !!! [A-Za-z0-9_] ˤơȤɽԤ
	return;
      }
      // ǥ쥯ȥκ
      // !!! Apache 桼äʬʬäʤΤǡѡߥå
      if (! @mkdir('data/'. $name, 0777)) {
	return;
      }
      @chmod('data/'. $name, 0777);

      // users_file ˥桼ɲ
      // !!! åޤ
      $fp = fopen($_SESSION['users_file'], 'a');
      if ($fp != false) {
	$line = $name. "\tdummy_password\n";
	fwrite($fp, $line);
	fclose($fp);
      }
    }

    // ѥѹ
    if (array_key_exists('change_password_submit', $_POST)) {
      // !!! ɤǡ桼ʬΥѥɤΤѹơ񤭹
      if (! isset($_POST['change_user'])) {
	print 'no change_user<br>';
	return;
      }
      $change_user = $_POST['change_user'];

      $replace_file = '';
      $fp = fopen($_SESSION['users_file'], 'r');
      if ($fp != false) {
	while (! feof($fp)) {
	  $line = fgets($fp);
	  $name = strtok($line, "\n\t ");
	  if ($name == $change_user) {
	    $line = $name. "\t". crypt($_POST['change_password']). "\n";
	  }
	  $replace_file .= $line;
	}
	fclose($fp);
      }
      $fp = fopen($_SESSION['users_file'], 'w');
      if ($fp != false) {
	fwrite($fp, $replace_file);
	fclose($fp);
      }
    }

    // 桼
    if (array_key_exists('del_user_submit', $_POST)) {
    }
  }


  // ɽ
  function createCommentView() {
    $out = '';
    $out .= '<table border=1 width=500>';

    // !!! Ͽץ¸νȽʣʤΤޤȤ
    $key = $this->getChapter(). '-'. $this->getNo();
    $rev = array_key_exists($key, $this->comments_exist) ?
      $this->comments_exist[$key] : 0;
    $file = 'data/'. $_SESSION['brows_name']. '/c'. $key. '-'. $rev. '.txt';

    $fp = @fopen($file, 'r');
    if ($fp == false) {
      $out .= '<tr><td>No Comments.</td></tr>';
    } else {
      $header = true;
      while (! feof($fp)) {
	$line = fgets($fp);
	if ($line == '') {
	  // EOF
	  break;
	}
	if ($line == "\n") {
	  // Ȥζڤ
	  $header = true;
	  $out .= '</td></tr>';

	} else if ($header == true) {
	  // ȥåΥإå
	  $out .= '<tr><td>';

	  $header = false;
	  $name = strtok($line, "\t ");
	  $mtime = intval(strtok("\t "));
	  $out .= date('Y-m-d', $mtime).
	    '&nbsp; <strong>'. $name. '</strong><hr>';

	} else {
	  // Ȥɽ
	  $out .= htmlspecialchars($line). '<br>';
	}
      }
      fclose($fp);
    }
    $out .= '</table>';
    return $out;
  }


  // ȥեκ
  function createCommentForm() {
    $out = '';

    // !!! ӥ󤬺ǿǤʤС

    $out .= '<form method=POST>';

    $out .= '<textarea name=comment_msg cols=40 rows=4 wrap=soft></textarea>';
    $out .= '<input type=submit value=Send>';

    $out .= '</form>';
    return $out;
  }


  // ȤϿ
  function handleCommentRequest($user) {

    // 桼ɲ
    if (array_key_exists('comment_msg', $_POST)) {
      // ץΥӥƱˤ
      $this->createFilesHash($_SESSION['brows_name']);
      $key = $this->getChapter(). '-'. $this->getNo();
      $rev = array_key_exists($key, $this->programs_exist) ?
	$this->programs_exist[$key] : 0;
      $file = 'data/'. $_SESSION['brows_name']. '/c'. $key. '-'. $rev. '.txt';
      $fp = fopen($file, 'a');
      if ($fp != false) {
	$comment_data = $_SESSION['brows_name']. "\t". time(). "\n";

	// !!! \n  \n&nbsp; ִ
	$comment_data .= $_POST['comment_msg']. "\n\n";
	fwrite($fp, $comment_data);
	fclose($fp);
	$this->send_comment = true;
      }
    }
  }


  // ξϤؤΥ󥯤
  function createPrevChapterLink() {
    $out = '';
    $prev_chapter = $this->getChapter() - 1;
    if ($prev_chapter <= 0) {
      $out .= '<s>&lt;&lt;</s>';
    } else {
      $out .= '<a href=?chapter='. $prev_chapter. '>&lt;&lt</a>';
    }
    return $out;
  }


  // ξϤؤΥ󥯤
  function createNextChapterLink() {
    $out = '';
    $next_chapter = $this->getChapter() + 1;
    if ($next_chapter > count($_SESSION['problems_num'])) {
      $out .= '<s>&gt;&gt;</s>';
    } else {
      $out .= '<a href=?chapter='. $next_chapter. '>&gt;&gt</a>';
    }
    return $out;
  }
};
?>
