package jp.sourceforge.larch.fms
{
    import flash.events.NetStatusEvent;
    import flash.events.SyncEvent;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.net.SharedObject;
    import flash.utils.Dictionary;

    import jp.sourceforge.larch.core.util.LarchObjectUtil;
    import jp.sourceforge.larch.fms.so.AbstractSharedObject;

    import mx.collections.ArrayCollection;

    /**
     * シングルトン接続クラス
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class SingletonNetConnection
    {
        /**
         * コンストラクタ
         * @param aNc 接続オブジェクト
         * @param aCallback 接続終了後のコールバック関数(引数無しの関数)
         */
        public function SingletonNetConnection(aUrl:String, aCallback:Function = null)
        {
            super();
            callback = aCallback;
            // NetConnectionを初期化
            nc = new NetConnection();
            nc.addEventListener(NetStatusEvent.NET_STATUS, onNetConnectionStatus);
            nc.connect(aUrl);
        }

        /** 接続終了後のコールバック関数 */
        private var callback:Function;

        /** 接続オブジェクト */
        private var nc:NetConnection;

        /** ルートのSharedObject */
        private var rootSo:SharedObject;

        /** ストリームのキャッシュ */
        private var streamCache:ArrayCollection = new ArrayCollection();

        /** AbstractSharedObjectのキャッシュ */
        private var soCache:Dictionary = new Dictionary();

        /**
         * NetConnectionのステータスリスナー
         */
        private function onNetConnectionStatus(event:NetStatusEvent):void
        {
            var nc:NetConnection = event.target as NetConnection;
            nc.removeEventListener(NetStatusEvent.NET_STATUS, onNetConnectionStatus);
            if(event.info["code"] == "NetConnection.Connect.Success")
            {
                // ルートのSharedObjectに接続
                var remoteName:String = LarchObjectUtil.getObjectKey(this);
                rootSo = SharedObject.getRemote(remoteName, nc.uri);
                rootSo.addEventListener(SyncEvent.SYNC, onSoSync);
                rootSo.connect(nc);
            }
            else
                throw new Error(event.info["code"]);
        }

        /** SharedObject初期化時の同期イベントリスナー */
        private function onSoSync(event:SyncEvent):void
        {
            rootSo.removeEventListener(SyncEvent.SYNC, onSoSync);
            rootSo.client = this;
            if(callback != null)
                callback();
        }

        /**
         * 接続を閉じます(リソース開放)。
         */
        public function close():void
        {
            var stream:NetStream;
            for each(stream in streamCache)
            {
                stream.close();
            }
            nc.close();
        }

        /**
         * 共有オブジェクトを取得します。
         * 共有オブジェクトはクラスごとに1インスタンス生成されます。
         * @param soClass 共有オブジェクトのクラス
         * @return 共有オブジェクト
         */
        public function getSharedObject(soClass:Class):AbstractSharedObject
        {
            var so:AbstractSharedObject;
            var soClasskey:String = LarchObjectUtil.getObjectKey(soClass);
            if(soCache[soClasskey] == null)
            {
                so = new soClass();
                so.rootSo = rootSo;
                soCache[soClasskey] = so;
            }
            return soCache[soClasskey];
        }

        /**
         * 共有オブジェクトへのメッセージ通知のハンドラです。
         * @param objectKey 呼び出す共有オブジェクトのキー
         * @param functionName 呼び出す関数名
         * @param args 引数
         */
        public function sendHandler(objectKey:String, functionName:String, args:Array):void
        {
            var target:Object = soCache[objectKey];
            (target[functionName] as Function).apply(target, args);
        }

        /**
         * ストリームを生成します。
         * @return ストリーム
         */
        public function createNetStream():NetStream
        {
            var stream:NetStream = new NetStream(nc);
            streamCache.addItem(stream);
            return stream;
        }
    }
}