package jp.sourceforge.larch.fms
{
    import mx.core.Application;
    import mx.utils.URLUtil;

    /**
     * SingletonNetConnectionのファクトリークラス
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class SingletonNetConnectionFactory
    {
        /**
         * インスタンスを初期化します。
         * aServerを省略した場合、現在の接続先サーバーを使用します。
         * @param aAppName FMSアプリケーション名
         * @param aRoom ルーム名称
         * @param aHost 接続先サーバー
         * @param aCallback コールバック（引数無しの関数）
         */
        public static function initConnection(aAppName:String, aCallback:Function = null, aRoom:String = null, aHost:String = null):void
        {
            // 以前の接続を破棄
            if(_instance)
                _instance.close();
            // 接続URLを構築
            if(aHost == null)
                aHost = URLUtil.getServerName(Application.application.url);
            if(aHost.length == 0) // ローカル環境での実行を考慮
                aHost = "localhost";
            var url:String = "rtmp://" + aHost + "/" + aAppName;
            if(aRoom != null && aRoom.length != 0)
                url = url + "/" + aRoom;
            // インスタンス生成
            _instance = new SingletonNetConnection(url, aCallback);
        }

        /** @private */
        private static var _instance:SingletonNetConnection;
        /** 接続のシングルトンインスタンス */
        public static function get connection():SingletonNetConnection
        {
            return _instance;
        }
    }
}