package jp.sourceforge.larch.fms.so
{
    import flash.events.EventDispatcher;
    import flash.events.SyncEvent;
    import flash.net.SharedObject;

    import jp.sourceforge.larch.core.util.LarchCollectionUtil;
    import jp.sourceforge.larch.core.util.LarchObjectUtil;

    import mx.collections.ArrayCollection;
    import mx.events.CollectionEvent;

    /**
     * 共有オブジェクトの基底クラス
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class AbstractSharedObject extends EventDispatcher
    {
        /** このクラスのキー */
        private const key:String = LarchObjectUtil.getObjectKey(this);

        /** 同期処理中フラグ */
        private var syncProcessing:Boolean;

        /** @private */
        private var _rootSo:SharedObject;
        /** 共有オブジェクト */
        public function set rootSo(value:SharedObject):void
        {
            _rootSo = value;
            var name:String = LarchObjectUtil.getObjectKey(this);
            if(!_rootSo.data[name])
            {
                _rootSo.data[name] = new Object();
                initProperties();
            }
            doOnSync();
            _rootSo.addEventListener(SyncEvent.SYNC, onSync);
        }

        /**
         * 共有オブジェクトのプロパティを初期化します。
         * サブクラスにて実装してください。
         */
        protected function initProperties():void
        {
            throw new Error("サブクラスで実装してください。");
        }

        /**
         * プロパティを共有オブジェクトに対して同期します。
         */
        protected function sync():void
        {
            if(syncProcessing)
                return;
            var propertyName:String;
            for each(propertyName in LarchObjectUtil.getPropertyNames(this))
            {
                if(propertyName != "rootSo")
                {
                    if(this[propertyName] is ArrayCollection)
                        _rootSo.data[key][propertyName] = (this[propertyName] as ArrayCollection).source;
                    else
                        _rootSo.data[key][propertyName] = this[propertyName];
                }
            }
            _rootSo.setDirty(key);
        }

        /**
         * 共有オブジェクトにメッセージを通知します。
         * @param 呼び出す関数名
         * @param args 引数
         */
        protected function call(functionName:String, ... args):void
        {
            _rootSo.send("sendHandler", LarchObjectUtil.getObjectKey(this), functionName, args);
        }

        /** 同期リスナー */
        private function onSync(event:SyncEvent):void
        {
            var item:Object;
            for each(item in event.changeList)
            {
                if(item.name == key)
                    doOnSync();
            }
        }

        /**
         * 共有オブジェクトの同期時に呼び出します。
         */
        private function doOnSync():void
        {
            syncProcessing = true;
            var propertyName:String;
            for each(propertyName in LarchObjectUtil.getPropertyNames(this))
            {
                if(propertyName != "rootSo" && this[propertyName] != getProperty(propertyName))
                {
                    if(getProperty(propertyName) is Array)
                    {
                        if(this[propertyName] == null)
                            this[propertyName] = new ArrayCollection();
                        var value:ArrayCollection = this[propertyName] as ArrayCollection;
                        var soValue:ArrayCollection = new ArrayCollection(getProperty(propertyName) as Array);
                        value.removeEventListener(CollectionEvent.COLLECTION_CHANGE, onCollectionChange);
                        if(!LarchCollectionUtil.equals(value, soValue))
                        {
                            value.disableAutoUpdate();
                            value.removeAll();
                            LarchCollectionUtil.addAll(value, soValue);
                            value.enableAutoUpdate();
                        }
                        value.addEventListener(CollectionEvent.COLLECTION_CHANGE, onCollectionChange);
                    }
                    else
                        this[propertyName] = getProperty(propertyName);
                }
            }
            syncProcessing = false;
        }

        /**
         * 共有オブジェクトのプロパティを取得します。
         * @param propertyName プロパティ名
         * @return プロパティ値
         */
        private function getProperty(propetyName:String):Object
        {
            return _rootSo.data[key][propetyName];
        }

        /** コレクションの変更イベントハンドラ */
        private function onCollectionChange(event:CollectionEvent):void
        {
            sync();
        }
    }
}
