/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte;

import latte.action.AllAction;
import latte.di.CoreSemanticModelBridge;
import latte.di.DIFactory;
import latte.di.Diagram;
import latte.di.GraphNode;
import latte.di.SimpleSemanticModelElement;
import latte.di.impl.DIPackageImpl;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.view.MainForm;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.MultiplicityElement;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.UML2Factory;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.impl.UML2PackageImpl;
import org.eclipse.uml2.internal.util.UML2ResourceFactoryImpl;
    
/**
 * LatteC
 * 
 * @version $Id: Latte.java,v 1.10 2004/10/02 07:41:08 ohnuki Exp $
 * @author $Author: ohnuki $
 * 
 * @invariant latteData_ != null
 * @invariant mainForm_ != null
 */
public class Latte {
    /** r[iCtH[j */
	private static MainForm mainForm_ = null;
    /** LatteData */
    private static LatteData latteData_ = null;
    /** TRACE_EVENTtO */
    public static boolean TRACE_EVENT = false;
    /** LOG_FLUSH */
    public static boolean LOG_FLUSH = true;
    /** LOG_STDOUT */
    public static boolean LOG_STDOUT = false;
    
  	public static void main (String [] args) {
  		// JnO
		writeStartLog();
		
  		new Latte();
  	}

  	/**
  	 * JnO
  	 *
  	 */
  	private static void writeStartLog() {
		LogUtil.writeln("Latte start!");
		LogUtil.writeln("java.home="+System.getProperty("java.home"));
		LogUtil.writeln("java.vendor="+System.getProperty("java.vendor"));
		LogUtil.writeln("java.version="+System.getProperty("java.version"));
        LogUtil.writeln("java.class.version="+System.getProperty("java.class.version"));
        LogUtil.writeln("java.class.path="+System.getProperty("java.class.path"));
        LogUtil.writeln("java.library.path="+System.getProperty("java.library.path"));
  	}
  	
  	
  	Latte() {
        // Cu
        initLib();

        // CtH[쐬()
        mainForm_ = new MainForm();

        // 쐬
        AllAction.FILE_NEW.execute(null);

 		// s
 		mainForm_.run();
  	}
  	
   
	/**
	 * Returns the mainForm.
	 * @return MainForm
	 */
	public static MainForm getMainForm() {
		return mainForm_;
	}

	/**
	 * Returns the latteData.
	 * @return LatteData
	 */
	public static LatteData getLatteData() {
		return latteData_;
	}

	/**
     * VLatteDatagp
     * 
	 * @param latteData VLatteData
	 */
	public static void setLatteData(LatteData latteData) {
		latteData_ = latteData;
	}
    
    class TestAdapter extends AdapterImpl {
        public void notifyChanged(Notification msg) {
            System.out.println("notifyChanged:"+msg);
        }
    }
    
    /**
     * Cu
     *
     */
    private void initLib() {
        // pbP[W
        UML2PackageImpl.init();// UML2
        DIPackageImpl.init();// DIM

        EPackage.Registry.INSTANCE.put("http://www.eclipse.org/uml2/1.0.0/UML", UML2Package.eINSTANCE); 
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("lat", new UML2ResourceFactoryImpl()); 
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl()); 
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl()); 
        
//        new TestModel();
    }
        
    class TestModel {
        UML2Factory uml2Factory_ = UML2Factory.eINSTANCE;
        DIFactory diFactory_ = DIFactory.eINSTANCE;
        
        Model rootModel_ = null;
        Diagram rootDiagram_ = null;
        
        GraphNode gn;
        
        TestModel() {
//            makeTestModel();
//            saveTestModel();
        	testNavigable();
        }
        private void testNavigable() {
        	Model model = UML2Factory.eINSTANCE.createModel();
        	Package pkg = (Package)model.createOwnedMember(UML2Package.eINSTANCE.getPackage());
        	Class cls1 = (Class)pkg.createOwnedMember(UML2Package.eINSTANCE.getClass_());
        	Class cls2 = (Class)pkg.createOwnedMember(UML2Package.eINSTANCE.getClass_());
			
        	cls2.createAssociation(true, AggregationKind.COMPOSITE_LITERAL, "theClass1", 0, MultiplicityElement.UNLIMITED_UPPER_BOUND, 
        			            cls1, false, AggregationKind.NONE_LITERAL, "", 1, 1);
        	// get property(type=cls1)
        	Property prop = (Property)cls2.getOwnedAttributes().get(0);
        	System.out.println(prop);
        	System.out.println();
        	

        	System.out.println("-------1-------");
        	print(cls1, cls2);

        	prop.setNavigable(false);
        	System.out.println("-------2-------");
        	print(cls1, cls2);

        	prop.setNavigable(true);
        	System.out.println("-------3-------");
        	print(cls1, cls2);
        	
        	return;
        }
        
        private void print(Class cls1, Class cls2) {
        	for (int i=0; i<cls1.getOwnedAttributes().size(); i++) {
        	    System.out.println("cls1 " + i + ":" + cls1.getOwnedAttributes().get(i));
        	}
        	for (int i=0; i<cls2.getOwnedAttributes().size(); i++) {
        	    System.out.println("cls2 " + i + ":" + cls2.getOwnedAttributes().get(i));
        	}            
        }

        private void makeTestModel() {
            rootModel_ = uml2Factory_.createModel();
            rootModel_.eAdapters().add(new TestAdapter()); // Xi
            rootModel_.setName("Libraryf");
            Package myPackage = uml2Factory_.createPackage();
            myPackage.setName("pbP[W");
            rootModel_.getOwnedMembers().add(myPackage);
            // class
            Class myClass = uml2Factory_.createClass();
            myClass.setName("NX");
            myPackage.getOwnedMembers().add(myClass);
            // class2
            Class myClass2 = uml2Factory_.createClass();
            myClass2.setName("NX2");
            myPackage.getOwnedMembers().add(myClass2);
            myClass2.createGeneralization(myClass);
            myClass2.createAssociation(true,AggregationKind.COMPOSITE_LITERAL, "c1",0,MultiplicityElement.UNLIMITED_UPPER_BOUND,myClass,false, AggregationKind.NONE_LITERAL, null, 0, 1);

            rootDiagram_ = diFactory_.createDiagram();
            rootDiagram_.setVisible(true);
            rootDiagram_.eAdapters().add(new TestAdapter()); // Xi
            
            SimpleSemanticModelElement e1 = diFactory_.createSimpleSemanticModelElement();
            rootDiagram_.setSemanticModel(e1);
    
            CoreSemanticModelBridge c1 = diFactory_.createCoreSemanticModelBridge();
            c1.setElement(myPackage);
            gn = diFactory_.createGraphNode();
            gn.setSemanticModel(c1);
            rootDiagram_.getContained().add(gn);

            Object o = uml2Factory_.createClass();
            long l3 = System.currentTimeMillis();            
            for (int i=0; i<1000; i++) {
                if (o instanceof Class) {
                    System.out.print("");
                }
            }
            long l4 = System.currentTimeMillis();
            System.out.println("instanceof=" + (l4-l3));
            long l1 = System.currentTimeMillis();            
            for (int i=0; i<1000; i++) {
                ModelUtil.getClassifierID((EObject)o);
            }
            long l2 = System.currentTimeMillis();
            System.out.println("ModelUtil.getClassifierID()=" + (l2-l1));

        }
    
        void saveTestModel() {    
            ResourceSet resSet = new ResourceSetImpl();
            XMIResource res = (XMIResource)resSet.createResource(URI.createURI("samples/test.lat"));
            res.getContents().add(rootModel_);
            res.getContents().add(rootDiagram_);
            
            try {
                res.setEncoding("Shift_JIS");
                // IvVݒ

//                Map option = new HashMap();
//                option.put(XMLResource.OPTION_PROCESS_DANGLING_HREF, XMLResource.OPTION_PROCESS_DANGLING_HREF_DISCARD);
//                res.save(option);

                res.save(null);
                System.out.println("Model saved successfully!");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Model save FAILED");
            }
        }
    }
}