/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import latte.action.ActionCancelException;
import latte.action.AllAction;
import latte.di.Diagram;
import latte.di.impl.DIFactoryImpl;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.swt.SWT;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Enumeration;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.PrimitiveType;
import org.eclipse.uml2.UML2Package;


/**
 * LatteData
 * 
 * @author user
 * 
 * |Cxg@@@@@@A@B@C
 * -----------         (*1)(*2)(*1)
 * ʒm@  | ʒm  ADD SET REMOVE  ADD&REMOVEΏ
 * ----------------------------------------------------------
 * Model(*3)      T@  01  - @ 02     Package,Class,Interface
 *                D@  -   -  @03(*4) Class,Interface
 * Package(*3)@@T@  04  05@ 06     Package,Class,Interface
 *                D    -   -    07(*4) Class,Interface
 * Class@@@@@T@  08  09@ 10     Class,Interface,Attribute,Method
 *                D    -   -    11(*4) Class,Interface
 *                G    12  13   14     Attribute,Method
 * Interface    @T@  15  16@ 17     Class,Interface,Attribute,Method
 *                D    -   -    18(*4) Class,Interface
 *                G    19  20   21     Attribute,Method
 * Property @@@TG@ -@ 22@ -      
 * Operation  @@TG   -@ 23@ -
 * Comment(*5)    G    -   24   -
 * 
 * Diagram(*6)@  T@  51  52@ 53     Diagram(*7)
 *                F    -   54   55     Diagram(*7)
 *            (*8)F->D 56  -    57     GraphNode,GraphEdge
 * GraphNode(*6)@G@  -   58 @-
 * GraphEdge@@@G@  -   59 @-
 * 
 * yʒmzLIuWFNgɒڒʒm
 * T:c[@F:}tH_@G:tBMA@D:_CAO
 * 
 * (*1)qƂ̃Cxg
 * (*2)ωƂ̃Cxg
 * (*3)ĉ֌W Package<|--Model
 * (*4)CxgA (Model,Package,Class,Interface):REMOVE -> Diagram:REMOVE
 * (*5)Comment̑GraphNodẽCxgŏ
 * (*6)ĉ֌W GraphNode<|--Diagram
 * (*7)DiagramőSDiagramXgŕێ
 * (*8)Cxg`d Folder -> \Diagram
 * 
 * @notifier
 * AnewValue
 * Bfeature
 * ColdValue
 * 
 * 
 * 58 featureEReference,oldValue͌ÂPoint,newValue͐VPoint
 * 99 eventType == Notification.REMOVING_ADAPTER
 * 
 * @version $Id: LatteData.java,v 1.6 2004/10/02 04:28:08 ohnuki Exp $
 * @author $Author: ohnuki $
 * @invariant model_ != null
 * 
 */
public class LatteData {
    /** ۑvtO(LatteDataƃt@C) */
    private boolean isNeedSaving_ = false;
    /** t@C */
    private File file_ = null;
    /** UML2f */
    private Model model_ = null;
    /** S}Xg */
    private Diagram diagrams_ = null;
    /** v~eBu^ */
    private Package primitiveTypes_ = null;
    /** 񋓌^ */
    private Package enumerationTypes_ = null;
    /** 폜ꂽ^ NX^C^[tFCX */
    private Package trashType_ = null;
    
    /**
     *  O
     */
    private String NAME_MODEL = "f";
    private String NAME_DIAGRAM = "_CAO";
    private String NAME_PRIMITIVE = "v~eBu^";
    private String NAME_ENUMERATION = "񋓌^";
    private String NAME_TRASH = "폜ꂽ^";
    

    /**
     * ^ -> ^   ex. "latte.Latte" -> UML2Factory.createClass()ō쐬ꂽObj
     * 
     * ȉ3܂܂
     * 1.Model
     * 2.EnumerationType
     * 3.PrimitiveType
     * 
     */
    private HashMap qualifiedName2ElementMapping_ = new HashMap();

    
    /** GR[fBO */
    private static final String ENCODING = "Shift_JIS";
    
    
    /**
     * RXgN^
     */
    public LatteData() {
        LogUtil.writeln("LatteData.LatteData() start");
        
        // f쐬
        model_ = ModelUtil.Uml2Factory.createModel();
        model_.setName(NAME_MODEL); // f
        
        // S}Xg쐬
        diagrams_ = DIFactoryImpl.eINSTANCE.createDiagram();
        diagrams_.setName(NAME_DIAGRAM); // S}Xg
        
        // v~eBu^
        primitiveTypes_ = ModelUtil.Uml2Factory.createPackage();
        primitiveTypes_.setName(NAME_PRIMITIVE); // v~eBu^
        createAndAddPrimitiveTypes();
        
        // 񋓌^
        enumerationTypes_ = ModelUtil.Uml2Factory.createPackage();
        enumerationTypes_.setName(NAME_ENUMERATION); // 񋓌^
        
        // 폜ꂽ^
        trashType_ = ModelUtil.Uml2Factory.createPackage();
        trashType_.setName(NAME_TRASH);
        
        LogUtil.writeln("LatteData.LatteData() end");
    }
    
    /**
     * ۑmFƕۑ
     */
    public void checkSaving() throws ActionCancelException, IOException {
    	// ۑKvȂΖ߂
        if (!isNeedSaving_) {
            return;
        }
        // ۑ邩mF
        int ret = MsgUtil.showYesNoCancelMsg("f[^͕ύXĂ܂Bۑ܂H");
        switch (ret) {
        case SWT.YES:
            break;
        case SWT.NO:
            // ۑȂȂ߂
            return;
        case SWT.CANCEL:
            // LZȂLZOs
            throw new ActionCancelException();
        }
        
        // ȉ͕ۑꍇ
        AllAction.FILE_SAVE.execute(null);
    }
    
    /**
     * j
     * 
     * @throws Exception
     */
    public void destroy() throws ActionCancelException, IOException {
    }
    
    /**
     * t@Cǂݍ
     * 
     * @pre file_ != null
     */
    public void load() throws Exception {
        // `FbN
    	if (file_ == null) {
			throw new IllegalStateException("t@Cݒ肳Ă܂");
    	}
        
        
    	// t@Cǂݍ
        ResourceSet resSet = new ResourceSetImpl();
        Resource res = resSet.getResource(URI.createURI("file:///" + file_.getAbsolutePath()), true);
        EList eList = res.getContents();
        Iterator ite = eList.iterator();
        while (ite.hasNext()) {
            Object o = ite.next();
            if (o instanceof Model) {
                model_ = (Model)o;
            } else if (o instanceof Diagram) {
                diagrams_ = (Diagram)o;
            } else if (o instanceof Package) {
                Package p = (Package)o;
                if (p.getName().equals(NAME_PRIMITIVE)) {
                    primitiveTypes_ = p;
                } else if (p.getName().equals(NAME_ENUMERATION)) {
                    enumerationTypes_ = p;
                } else if (p.getName().equals(NAME_TRASH)) {
                    trashType_ = p;
                }
            }
        }
        
        
        // ^o^
        qualifiedName2ElementMapping_.clear();
        // model_
        for (Iterator i=model_.getOwnedMembers().iterator(); i.hasNext(); ) {
            addAllElementByQualifiedName((Element)i.next());
        }
        // primitiveTypes_
        for (Iterator i=primitiveTypes_.getOwnedMembers().iterator(); i.hasNext(); ) {
            PrimitiveType pt = (PrimitiveType)i.next();
            addElementByQualifiedName(pt.getName(), pt);
        }
        // enumerationTypes_
        for (Iterator i=enumerationTypes_.getOwnedMembers().iterator(); i.hasNext(); ) {
            addElementByQualifiedName((Enumeration)i.next());
        }
        // trashTypes_
        for (Iterator i=trashType_.getOwnedMembers().iterator(); i.hasNext(); ) {
            addElementByQualifiedName((NamedElement)i.next());
        }
        
        
        // ۑsv
        isNeedSaving_ = false;
    }

    /**
     * ^o^
     * 
     * @param element
     */
    private void addAllElementByQualifiedName(Element element){
        
        List list = new ArrayList();
        List interfaceList = new ArrayList(); // C^[tFCX
        List classList = new ArrayList(); // NX
        
        // elementŕ
        switch (ModelUtil.getClassifierID(element)) {
        case UML2Package.PACKAGE:
            Package p = (Package)element;
            list = p.getOwnedMembers();
            break;
        
        case UML2Package.CLASS:
            // NX
            Class c = (Class)element;

            // o^
            addElementByQualifiedName(c);

            // NVt@Ct@[擾
            for (Iterator i = c.getNestedClassifiers().iterator(); i.hasNext(); ) {
                Classifier nestedClassifier = (Classifier)i.next();
                if (nestedClassifier instanceof Interface) {
                    interfaceList.add(nestedClassifier);
                } else {
                    classList.add(nestedClassifier);
                }
            }
            // C^[tFCX
            list.addAll(interfaceList);
            // NX
            list.addAll(classList);
            // 
            list.addAll(c.getOwnedAttributes());
            // \bh
            list.addAll(c.getOwnedOperations());
            break;
        
        case UML2Package.INTERFACE:
            // C^[tFCX
            Interface intf = (Interface)element;

            // o^
            addElementByQualifiedName(intf);

            // NVt@Ct@[擾
            for (Iterator i = intf.getNestedClassifiers().iterator(); i.hasNext(); ) {
                Classifier nestedClassifier = (Classifier)i.next();
                if (nestedClassifier instanceof Interface) {
                    interfaceList.add(nestedClassifier);
                } else {
                    classList.add(nestedClassifier);
                }
            }
            // C^[tFCX
            list.addAll(interfaceList);
            // NX
            list.addAll(classList);
            // 
            list.addAll(intf.getOwnedAttributes());
            // \bh
            list.addAll(intf.getOwnedOperations());
            break;
            
        case UML2Package.PROPERTY:
        case UML2Package.OPERATION:
        case UML2Package.ASSOCIATION:
        case UML2Package.DEPENDENCY:
        case UML2Package.GENERALIZATION:
        case UML2Package.IMPLEMENTATION:
            break;
        
        default:
            throw new InternalLogicException("TreeItem쐬s : "+element);
            
        }
        
        // ċAITree쐬
        for (Iterator i = list.iterator(); i.hasNext(); ) {
            addAllElementByQualifiedName((Element)i.next());
        }
    }
    
    
    /**
     * t@CۑKv
     */
    public void setNeedSaving() {
        isNeedSaving_ = true;
    }
    
  
    /**
     * Z[u
     * 
     * @pre file_ != null
     */
    public void save() throws IllegalStateException, IOException {
        // file_`FbN
        if (file_ == null) {
            throw new IllegalStateException("t@Cݒ肳Ă܂");
        }
        
        // ۑ
        ResourceSet resSet = new ResourceSetImpl();
        XMIResource res = (XMIResource)resSet.createResource(URI.createURI("file:///"+file_.getAbsolutePath()));
        res.getContents().add(model_);           // f
        res.getContents().add(diagrams_);        // }
        res.getContents().add(primitiveTypes_);  // v~eBu^
        res.getContents().add(enumerationTypes_);    // 񋓌^
        res.getContents().add(trashType_);    // 폜ꂽ^
        
        res.setEncoding(ENCODING);
        res.save(null);
        
        // t@CۑKvtONA
        isNeedSaving_ = false;
    }
    
    /**
     * ^QualifiedNameŒǉ
     * @param qualifiedName key
     * @param element value
     */
    public void addElementByQualifiedName(NamedElement ne) {
        // f:: -> ()
        // ::       ->   .
        String qname = ne.qualifiedName().replaceFirst("^f::", "").replaceAll("::", ".");
        addElementByQualifiedName(qname, ne);
    }
    
    public void moveToTrash(NamedElement ne) {
        Element owner = ne.getOwner();
        
        switch (ModelUtil.getClassifierID(owner)) {
        case UML2Package.MODEL:
            Model m = (Model)owner;
            m.getOwnedMembers().remove(ne);
            break;
        
        case UML2Package.PACKAGE:
            break;
        }
        
        trashType_.getOwnedMembers().add(ne);
    }
    
    /**
     * ^QualifiedNameŒǉ
     * @param qualifiedName key
     * @param element value
     */
    public void addElementByQualifiedName(String qualifiedName, Element element) {
        LogUtil.writeln("LatteData.addElementByQualifiedName("+qualifiedName+")");
        
        qualifiedName2ElementMapping_.put(qualifiedName, element);
    }
    
    /**
     * qualifiedNameElementT
     * @param qualifiedName
     * @return
     */
    public Element lookupElementByQualifiedName(String qualifiedName) {
        return (Element)qualifiedName2ElementMapping_.get(qualifiedName);
    }
    
	/**
	 * Returns the file.
	 * @return File
	 */
	public File getFile() {
		return file_;
	}

	/**
	 * Sets the file.
	 * @param file The file to set
	 */
	public void setFile(File file) {
		file_ = file;
	}
	
    /**
     * @return
     */
    public Diagram getDiagrams() {
        return diagrams_;
    }

    /**
     * @return
     */
    public Model getModel() {
        return model_;
    }
    
    public Package getPrimitiveTypes() {
        return primitiveTypes_;
    }
    
    /**
     * v~eBu^̌
     * 
     * @param name
     * @return
     */
    public PrimitiveType lookupPrimitiveTypes(String name) {
        Iterator i = primitiveTypes_.getOwnedMembers().iterator();
        while (i.hasNext()) {
            PrimitiveType pt = (PrimitiveType)i.next();
            if (pt.getName().equals(name)) {
                return pt;
            }
        }
        return null;
    }
    
    private void createAndAddPrimitiveTypes() {
        createAndAddPrimitiveType("void");
        createAndAddPrimitiveType("boolean");
        createAndAddPrimitiveType("char");
        createAndAddPrimitiveType("byte");
        createAndAddPrimitiveType("short");
        createAndAddPrimitiveType("int");
        createAndAddPrimitiveType("long");
        createAndAddPrimitiveType("float");
        createAndAddPrimitiveType("double");
    }
    
    private void createAndAddPrimitiveType(String name) {
        LogUtil.writeln("LatteData.createAndAddPrimitiveType("+name+")");
        
        PrimitiveType pt = ModelUtil.Uml2Factory.createPrimitiveType();
        pt.setName(name);
        LogUtil.writeln("  ->"+pt);

        primitiveTypes_.getOwnedMembers().add(pt);
        // o^
        addElementByQualifiedName(pt.getName(), pt);
    }
    
    
    /**
     * 񋓌^쐬ǉ
     * 
     * @param name
     * @return
     */
    public Enumeration createAndAddEnumerationType(String name) {
        LogUtil.writeln("LatteData.createAndAddEnumerationType("+name+")");
        
        Enumeration e = ModelUtil.Uml2Factory.createEnumeration();
        e.setName(name);
        enumerationTypes_.getOwnedMembers().add(e);
        // o^
        addElementByQualifiedName(e);
        
        return e;
    }
    
    
    /**
     * 񋓌^̌
     * @param name
     * @return
     */
    public Enumeration lookupEnumeraion(String name) {
        Iterator i = enumerationTypes_.getOwnedMembers().iterator();
        while (i.hasNext()) {
            Enumeration e = (Enumeration)i.next();
            if (e.getName().equals(name)) {
                return e;
            }
        }
        return null;
    }
    
    /**
     * 񋓌^̍폜
     * @param name
     * @return
     */
    public void removeEnumeraion(String name) {
        Enumeration e = lookupEnumeraion(name);
        if (e != null) {
            enumerationTypes_.getOwnedMembers().remove(e);
        }
    }
}
