/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;


import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.UML2Package;

import latte.Latte;
import latte.di.CoreSemanticModelBridge;
import latte.di.Diagram;
import latte.di.GraphNode;
import latte.util.GuiUtil;
import latte.util.ModelUtil;


/**
 * }ɒ`ǉ
 * 
 * @version $Id: AddFigureAction.java,v 1.4 2004/09/08 13:17:12 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class AddFigureAction extends AbstractLatteAction {

    public AddFigureAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    /**
     * IꂽƂ
     * 
     * e.xe.y͈ʒuĂ
     */
    public void execMain(Object param) {
        // _擾
        Point droppedPoint = (Point)param;
        // Jg`擾
        EObject droppedDef = Latte.getMainForm().getSelectedModels();
        // Jg}擾
        Diagram diagram = GuiUtil.getSelectedLVDiag().getDiagram();
        

        // Otm[h쐬
        GraphNode graphNode = ModelUtil.DiFactory.createGraphNode();
        switch (ModelUtil.getClassifierID(droppedDef)) {
        case UML2Package.CLASS:
        case UML2Package.INTERFACE:
            // NXC^[tFCXȂ瑮̈ƃ\bḧɑΉGraphNode쐬
            GraphNode attributeGraphNode = ModelUtil.DiFactory.createGraphNode();
            GraphNode methodGraphNode = ModelUtil.DiFactory.createGraphNode();
            attributeGraphNode.setVisible(true);
            methodGraphNode.setVisible(true);
            graphNode.getContained().add(attributeGraphNode);
            graphNode.getContained().add(methodGraphNode);
            break;

        default:
            break;
        }
        // fubW쐬ݒ
        CoreSemanticModelBridge uml2ModelBridge = ModelUtil.DiFactory.createCoreSemanticModelBridge();
        uml2ModelBridge.setElement((Element)droppedDef);
        graphNode.setSemanticModel(uml2ModelBridge);
        // _쐬ݒ
        latte.di.Point pos = ModelUtil.DiFactory.createPoint();
        pos.setX(droppedPoint.x);
        pos.setY(droppedPoint.y);
        graphNode.setPosition(pos);


        // }ɒǉ
        diagram.getContained().add(graphNode);

        // t@CۑKv
        ModelUtil.setNeedSaving();
    }
}
