/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import org.eclipse.uml2.Comment;
import org.eclipse.uml2.Model;

import latte.Latte;
import latte.di.CoreSemanticModelBridge;
import latte.di.Diagram;
import latte.di.GraphNode;
import latte.util.GuiUtil;
import latte.util.ModelUtil;


/**
 * 
 * @version $Id: AddNoteAction.java,v 1.3 2004/10/02 04:27:55 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class AddNoteAction extends AbstractLatteAction {

    public AddNoteAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    public void execMain(Object param) {
        String note = GuiUtil.showNoteDialog("");
        // ͖Ȃ߂
        if (note == null) {
            return;
        }
        // m[g쐬
        // e(Model)擾
        Model parent = Latte.getLatteData().getModel();

        // Comment쐬
        Comment comment = ModelUtil.Uml2Factory.createComment();
        comment.setBody(note);
            
        // e(Model)ɒǉ
        parent.getOwnedComments().add(comment);

        // IuU[oǉ
//        comment.eAdapters().add(Latte.getMainForm().getDiagFolder());
            
        // }ɒǉ
        Diagram diagram = GuiUtil.getSelectedLVDiag().getDiagram();        
        // fubW쐬
        CoreSemanticModelBridge uml2ModelBridge = ModelUtil.DiFactory.createCoreSemanticModelBridge();
        uml2ModelBridge.setElement(comment);
        // Otm[h쐬
        latte.di.Point pos = ModelUtil.DiFactory.createPoint();
        pos.setX(100);
        pos.setY(100);
        GraphNode gnode = ModelUtil.DiFactory.createGraphNode();
        gnode.setPosition(pos);
        gnode.setSemanticModel(uml2ModelBridge);
            
        // }ɒǉ
        diagram.getContained().add(gnode);
            
        // t@CۑKv
        ModelUtil.setNeedSaving();
    }
}
