/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Artifact;
import org.eclipse.uml2.Association;
import org.eclipse.uml2.BehavioredClassifier;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Comment;
import org.eclipse.uml2.DataType;
import org.eclipse.uml2.Dependency;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Generalization;
import org.eclipse.uml2.Implementation;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.MultiplicityElement;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Signal;
import org.eclipse.uml2.StructuredClassifier;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.internal.operation.ClassifierOperations;
import org.eclipse.uml2.util.UML2Switch;

import latte.InternalLogicException;
import latte.Latte;

import latte.action.mm.AllManip;
import latte.di.CoreSemanticModelBridge;
import latte.di.Diagram;
import latte.di.GraphConnector;
import latte.di.GraphEdge;
import latte.di.GraphNode;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;
import latte.view.LVDiag;


/**
 * ֌W̒ǉ
 * 
 * @version $Id: AddRelationAction.java,v 1.5 2004/10/02 07:37:26 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class AddRelationAction extends AbstractLatteAction {

    public AddRelationAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    /**
     * IꂽƂ
     */
    public void execMain(Object param) {
        try {
            // from  to擾
            int mode = Integer.parseInt((String)((Object[])param)[0]);
            GraphNode fromGraphNode = (GraphNode)((Object[])param)[1];
            GraphNode toGraphNode = (GraphNode)((Object[])param)[2];
            
            // fromtoƃ[h̃`FbN
            check(mode, fromGraphNode, toGraphNode);
                    
            // [hɂċۉ֌W
            switch (mode) {
            case LVDiag.MODE_ASSOCIATION:// ֘A֌W
                createAssociation(fromGraphNode, toGraphNode);
                break;
                
            case LVDiag.MODE_DEPENDENCY: // ˑ֌W
                createDependency(fromGraphNode, toGraphNode);
                break;
                
            case LVDiag.MODE_GENELIZATION:// ĉ֌W
                createGenelization(fromGraphNode, toGraphNode);
                break;
                
            case LVDiag.MODE_IMPLEMENTATION:// ֌W
                createImplementation(fromGraphNode, toGraphNode);
                break;
                
            case LVDiag.MODE_NOTELINK:    // m[gN֌W
                createNotelink(fromGraphNode, toGraphNode);
                break;
                
            default:
                throw new InternalLogicException("sȃ[h");
            }
            
            // t@CۑKv
            ModelUtil.setNeedSaving();
        }
        catch(IllegalArgumentException e) {
            LogUtil.write("f쐬s", e);
            MsgUtil.showMsg(e.getMessage());            
        }
        catch(Exception e) {
            LogUtil.write("֌W쐬s", e);
            MsgUtil.showMsg("G[F" + e.getMessage());
        }
        
    }
    
    /**
     * `FbN
     *
     */
    private void check(int mode, GraphNode fromNode, GraphNode toNode) {
        // fromtoLMClass, LMInterface, LMNotêÂꂩ
        Object fromDef = ModelUtil.getElement(fromNode);
        Object toDef = ModelUtil.getElement(toNode);
        switch (mode) {
        case LVDiag.MODE_ASSOCIATION:// ֘A֌W
            // fromtôǂ炩m[ǵ~
            if (ModelUtil.getClassifierID(fromDef) == UML2Package.COMMENT || ModelUtil.getClassifierID(toDef) == UML2Package.COMMENT) {
                throw new IllegalArgumentException("Fm[gɊ֘At悤ƂĂ܂");
            }
            // frominterfacé~
            if (ModelUtil.getClassifierID(fromDef) == UML2Package.INTERFACE) {
                throw new IllegalArgumentException("FC^[tFCXɊ֘A悤ƂĂ܂");
            }
            break;
            
        case LVDiag.MODE_DEPENDENCY: // ˑ֌W
            // fromtôǂ炩m[ǵ~
            if (ModelUtil.getClassifierID(fromDef) == UML2Package.COMMENT || ModelUtil.getClassifierID(toDef) == UML2Package.COMMENT) {
                throw new IllegalArgumentException("Fm[gɈˑ悤ƂĂ܂");
            }
            break;
            
        case LVDiag.MODE_GENELIZATION:// ĉ֌W
            // fromtôǂ炩m[ǵ~
            if (ModelUtil.getClassifierID(fromDef) == UML2Package.COMMENT || ModelUtil.getClassifierID(toDef) == UML2Package.COMMENT) {
                throw new IllegalArgumentException("Fm[gɔĉ悤ƂĂ܂");
            }
            if ((ModelUtil.getClassifierID(fromDef) == UML2Package.INTERFACE && ModelUtil.getClassifierID(toDef) != UML2Package.INTERFACE) ||
                (ModelUtil.getClassifierID(toDef) == UML2Package.INTERFACE && ModelUtil.getClassifierID(fromDef) != UML2Package.INTERFACE)) {
                    throw new IllegalArgumentException("FC^[tFCXƕʂ̌^ĉ悤ƂĂ܂");
            }
            if ((ModelUtil.getClassifierID(fromDef) == UML2Package.CLASS && ModelUtil.getClassifierID(toDef) != UML2Package.CLASS) ||
                (ModelUtil.getClassifierID(toDef) == UML2Package.CLASS && ModelUtil.getClassifierID(fromDef) != UML2Package.CLASS)) {
                    throw new IllegalArgumentException("FNXƕʂ̌^ĉ悤ƂĂ܂");
            }            
            break;
            
        case LVDiag.MODE_IMPLEMENTATION:// ֌W
            if (ModelUtil.getClassifierID(fromDef) != UML2Package.CLASS || ModelUtil.getClassifierID(toDef) != UML2Package.INTERFACE) {
                throw new IllegalArgumentException("F֌Wsł");
            }
            break;
            
        case LVDiag.MODE_NOTELINK:    // m[gN֌W
            if (ModelUtil.getClassifierID(fromDef) != UML2Package.COMMENT && ModelUtil.getClassifierID(toDef) != UML2Package.COMMENT) {
                throw new IllegalArgumentException("Fm[gNsł");
            }
            if (ModelUtil.getClassifierID(fromDef) == UML2Package.COMMENT && ModelUtil.getClassifierID(toDef) == UML2Package.COMMENT) {
                throw new IllegalArgumentException("Fm[gNsł");
            }
            break;
            
        default:
            throw new InternalLogicException("sȃ[h");
        }
    }

    /**
     * ֘A쐬
     * 
     * fromElementLPackage֘AL
     * 
     * @param fromGraphNode
     * @param toGraphNode
     */
    private void createAssociation(GraphNode fromGraphNode, GraphNode toGraphNode) {
        // 
        Class fromElement = (Class)ModelUtil.getElement(fromGraphNode);
        String fromName = fromElement.getName();
        int fromLower = 0;
        int fromUpper = 1;
            
        Classifier toElement = (Classifier)ModelUtil.getElement(toGraphNode);
        String toName = toElement.getName();
        int toLower = 0;
        int toUpper = 1;
            
        AggregationKind AK = AggregationKind.NONE_LITERAL; // LatteŖΉ(2004/8/20_)
            

        // ֘A쐬
        Association ass = createAssociation(fromElement, true, AK, fromName, fromLower, fromUpper,
                                            toElement, false, AK, toName, toLower, toUpper);
        // 쐬
        Property fromProperty = createAssociationEnd(ass, fromElement, true, AK, fromName, fromLower, fromUpper, toElement);
        createAssociationEnd(ass, toElement, false, AK, toName, toLower, toUpper, fromElement);

        // GraphEdge쐬}ɒǉ
        createAndAddGraphEdge(fromGraphNode, toGraphNode, ass);
    }
    
    /**
     * ĉ쐬
     * 
     * specificClassifierĉL
     * 
     * @param fromGraphNode
     * @param toGraphNode
     */
    private void createGenelization(GraphNode fromGraphNode, GraphNode toGraphNode) {
        // 
        Classifier specificClassifier = (Classifier)ModelUtil.getElement(fromGraphNode);
        Classifier generalClassifier = (Classifier)ModelUtil.getElement(toGraphNode);
        
        // ĉ쐬
        Generalization gen = ClassifierOperations.createGeneralization(specificClassifier, generalClassifier); // specificClassifierL

        // GraphEdge쐬}ɒǉ
        createAndAddGraphEdge(fromGraphNode, toGraphNode, gen);
    }
    
    /**
     * ˑ쐬
     * 
     * @param fromGraphNode
     * @param toGraphNode
     */
    private void createDependency(GraphNode fromGraphNode, GraphNode toGraphNode) {
        // 
        NamedElement clientElement = (NamedElement)ModelUtil.getElement(fromGraphNode);
        NamedElement supplierElement = (NamedElement)ModelUtil.getElement(toGraphNode); // TvC
        
        // ˑ쐬
        Dependency dep = ModelUtil.Uml2Factory.createDependency();
        dep.getSuppliers().add(supplierElement);
        dep.getClients().add(clientElement);
        
        Classifier clientClassifier = (Classifier)clientElement;
        clientClassifier.getPackage().getOwnedMembers().add(dep);

        // GraphEdge쐬}ɒǉ
        createAndAddGraphEdge(fromGraphNode, toGraphNode, dep);
    }
    
    /**
     * 쐬
     * 
     * behavioredClassifierL
     * 
     * @param fromGraphNode
     * @param toGraphNode
     */
    private void createImplementation(GraphNode fromGraphNode, GraphNode toGraphNode) {
        BehavioredClassifier behavioredClassifier = (BehavioredClassifier)ModelUtil.getElement(fromGraphNode);
        Interface inter = (Interface)ModelUtil.getElement(toGraphNode);
        
        // 쐬
        Implementation imp = ModelUtil.Uml2Factory.createImplementation();
        imp.setContract(inter);
        imp.setImplementingClassifier(behavioredClassifier); // behavioredClassifierL
        
        // GraphEdge쐬}ɒǉ
        createAndAddGraphEdge(fromGraphNode, toGraphNode, imp);
    }
    
    /**
     * m[gN̍쐬
     * 
     * @param fromGraphNode
     * @param toGraphNode
     */
    private void createNotelink(GraphNode fromGraphNode, GraphNode toGraphNode) {
        Element element = null;
        Comment comment = null;
        Element fromElement = ModelUtil.getElement(fromGraphNode);
        Element toElement = ModelUtil.getElement(toGraphNode);
        switch (ModelUtil.getClassifierID(fromElement)) {
        case UML2Package.COMMENT:
            comment = (Comment)fromElement;
            element = toElement;
            break;
        default:
            comment = (Comment)toElement;
            element = fromElement;
            break;            
        }
        
        // RgƃGgN
        comment.getAnnotatedElements().add(element);
        
        // GraphEdge쐬}ɒǉ
        createAndAddGraphEdge(fromGraphNode, toGraphNode, comment);        
    }
    
    /**
     * GraphEdge쐬}ɒǉ
     * 
     * @param fromGraphNode
     * @param toGraphNode
     * @param element
     */
    private void createAndAddGraphEdge(GraphNode fromGraphNode, GraphNode toGraphNode, Element element) {
        // GraphEdge쐬
        GraphEdge graphEdge = ModelUtil.DiFactory.createGraphEdge();
        // fubW쐬ݒ
        CoreSemanticModelBridge uml2ModelBridge = ModelUtil.DiFactory.createCoreSemanticModelBridge();
        uml2ModelBridge.setElement(element);
        graphEdge.setSemanticModel(uml2ModelBridge);
            
        // Anchorݒ
        GraphConnector fromGraphConnector = ModelUtil.DiFactory.createGraphConnector();
        GraphConnector toGraphConnector = ModelUtil.DiFactory.createGraphConnector();
        fromGraphConnector.setGraphElement(fromGraphNode);
        toGraphConnector.setGraphElement(toGraphNode);
        graphEdge.getAnchor().add(fromGraphConnector);
        graphEdge.getAnchor().add(toGraphConnector);

        // }ɒǉ
        Diagram diagram = GuiUtil.getSelectedLVDiag().getDiagram(); // Jg}擾            
        diagram.getContained().add(graphEdge);
    }
    
    /**
     * ֘A쐬
     * TypeOperations.createAssociation()Q
     * 
     * @param type1
     * @param end1IsNavigable
     * @param end1Aggregation
     * @param end1Name
     * @param end1LowerBound
     * @param end1UpperBound
     * @param type2
     * @param end2IsNavigable
     * @param end2Aggregation
     * @param end2Name
     * @param end2LowerBound
     * @param end2UpperBound
     * @return
     */
    private Association createAssociation(Type type1,
            boolean end1IsNavigable, AggregationKind end1Aggregation,
            String end1Name, int end1LowerBound, int end1UpperBound,
            Type type2, boolean end2IsNavigable,
            AggregationKind end2Aggregation, String end2Name,
            int end2LowerBound, int end2UpperBound) {

        if (null == type1 || null == type1.getPackage()) {
            throw new IllegalArgumentException(String.valueOf(type1));
        }

        if (end1IsNavigable && null == getOwnedAttributes(type1)) {
            throw new IllegalArgumentException(String.valueOf(type1));
        }

        if (null == end1Aggregation) {
            throw new IllegalArgumentException(String.valueOf(end1Aggregation));
        }

        if (0 > end1LowerBound) {
            throw new IllegalArgumentException(String.valueOf(end1LowerBound));
        }

        if (MultiplicityElement.UNLIMITED_UPPER_BOUND != end1UpperBound
            && (0 == end1UpperBound || end1LowerBound > end1UpperBound)) {
            throw new IllegalArgumentException(String.valueOf(end1UpperBound));
        }

        if (null == type2) {
            throw new IllegalArgumentException(String.valueOf(type2));
        }

        if (end2IsNavigable && null == getOwnedAttributes(type2)) {
            throw new IllegalArgumentException(String.valueOf(type2));
        }

        if (null == end2Aggregation) {
            throw new IllegalArgumentException(String.valueOf(end2Aggregation));
        }

        if (0 > end2LowerBound) {
            throw new IllegalArgumentException(String.valueOf(end2LowerBound));
        }

        if (MultiplicityElement.UNLIMITED_UPPER_BOUND != end2UpperBound
            && (0 == end2UpperBound || end2LowerBound > end2UpperBound)) {

            throw new IllegalArgumentException(String.valueOf(end2UpperBound));
        }

        Association association = (Association) type1.getPackage()
            .createOwnedMember(UML2Package.eINSTANCE.getAssociation());

        return association;
    }
    
    /**
     * OwnedAttributes擾
     * @param type
     * @return
     */
    private EList getOwnedAttributes(Type type) {

        if (null == type) {
            return null;
        }

        return (EList) new UML2Switch() {

            public Object caseArtifact(Artifact object) {
                return object.getOwnedAttributes();
            }

            public Object caseDataType(DataType object) {
                return object.getOwnedAttributes();
            }

            public Object caseInterface(Interface object) {
                return object.getOwnedAttributes();
            }

            public Object caseSignal(Signal object) {
                return object.getOwnedAttributes();
            }

            public Object caseStructuredClassifier(StructuredClassifier object) {
                return object.getOwnedAttributes();
            }
        }.doSwitch(type);
    }
            
    /**
     * ֘A[(Property)쐬
     * TypeOperations.createAssociationEnd()Q
     * 
     * @param association
     * @param type
     * @param isNavigable
     * @param aggregation
     * @param name
     * @param lowerBound
     * @param upperBound
     * @param otherEndType
     * @return
     */
    private Property createAssociationEnd(Association association,
            Type type, boolean isNavigable, AggregationKind aggregation,
            String name, int lowerBound, int upperBound, Type otherEndType) {
                
        Property associationEnd = null;
        if (isNavigable) {
            associationEnd = ModelUtil.Uml2Factory.createProperty();
        } else {
            associationEnd = association.createOwnedEnd(UML2Package.eINSTANCE.getProperty());
        }
        
        associationEnd.setType(otherEndType);
        associationEnd.setAggregation(aggregation);
        associationEnd.setName(otherEndType.getName()+"[");
        associationEnd.setUpperBound(upperBound);
        associationEnd.setLowerBound(lowerBound);

        if (isNavigable) {
            // LVTreeXiɒǉ
            associationEnd.eAdapters().add(Latte.getMainForm().getTree());
            
            // ֘Aɒǉ
            association.getMemberEnds().add(associationEnd);

            // NXC^[tFCXɒǉ
            AllManip.ATTRIBUTE.addDef(type, associationEnd);            
        }

        return associationEnd;
    }
}
