/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import latte.Latte;
import latte.di.GraphEdge;
import latte.util.ModelUtil;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Property;


/**
 * 
 * @version $Id: AggregationShareAction.java,v 1.2 2004/09/11 12:43:39 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class AggregationShareAction extends AbstractLatteAction {

    public AggregationShareAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    /**
     * Wɂ
     * 
     */
    public void execMain(Object param) {
        // 
        SelectionEvent se = (SelectionEvent)param;
        MenuItem menuItem = (MenuItem)se.getSource();
        // 
        GraphEdge graphEdge = (GraphEdge)Latte.getMainForm().getSelectedModels();
        Property property = ModelUtil.getFromProperty(graphEdge);
        
        // ݒ
        property.setAggregation(AggregationKind.SHARED_LITERAL);
    }
}
