/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import org.eclipse.uml2.Comment;

import latte.Latte;
import latte.di.CoreSemanticModelBridge;
import latte.di.GraphElement;
import latte.util.GuiUtil;
import latte.util.ModelUtil;


/**
 * 
 * @version $Id: EditNoteAction.java,v 1.3 2004/10/02 04:27:57 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class EditNoteAction extends AbstractLatteAction {

    public EditNoteAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    public void execMain(Object param) {
        GraphElement graphElement = (GraphElement)Latte.getMainForm().getSelectedModels();
        CoreSemanticModelBridge bridge = (CoreSemanticModelBridge)graphElement.getSemanticModel();
        Comment comment = (Comment)bridge.getElement();
        
        String note = comment.getBody();
        
        String newNote = GuiUtil.showNoteDialog(note);
        // ͖Ȃ߂
        if (newNote == null) {
            return;
        }
        
        comment.setBody(newNote);
        
        // t@CۑKv
        ModelUtil.setNeedSaving();
    }
}
