/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Association;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Dependency;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Enumeration;
import org.eclipse.uml2.Generalization;
import org.eclipse.uml2.Implementation;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.UML2Package;

import latte.Latte;
import latte.action.mm.AllManip;
import latte.di.DIPackage;
import latte.di.Diagram;
import latte.di.GraphEdge;
import latte.di.GraphNode;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;
import latte.util.ModelUtil.ModelVisitor;

/**
 * 폜ANV
 * 
 * @version $Id: EditRemoveAction.java,v 1.7 2004/10/02 04:27:56 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class EditRemoveAction extends AbstractLatteAction {

    public EditRemoveAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    public void execMain(Object param) {
        try {
            // Jgi폜Ώہj擾
            EObject removeDef = Latte.getMainForm().getSelectedModels();
        
            // `FbN
            check(removeDef);
        
            Diagram diagram = null;
            Element element = null;
            ModelRemoveVisitor modelRemoveVisitor = null;
            // 폜}js[^Is
            switch (ModelUtil.getClassifierID(removeDef)) {
            case UML2Package.PROPERTY:
                // 
                AllManip.ATTRIBUTE.removeDef(removeDef);
                break;
                
            case UML2Package.OPERATION:
                // \bh
                AllManip.METHOD.removeDef(removeDef);
                break;
            
            case UML2Package.CLASS:
                Class cls = (Class)removeDef;
            
                // ܂}폜
                ModelUtil.removeGraphNode((Element)removeDef);
/*            
                // QƂ폜
                modelRemoveVisitor = new ModelRemoveVisitor((Class)removeDef);
                modelRemoveVisitor.visit(Latte.getLatteData().getModel());
*/                
                // fNX폜
//                AllManip.CLASS.removeDef(removeDef);
                // qS~
/*
                for (Iterator i=(new ArrayList(cls.getNestedClassifiers())).iterator(); i.hasNext(); ) {
                    Element e = (Element)i.next();
                    switch (ModelUtil.getClassifierID(e)) {
                    case UML2Package.CLASS:
                    case UML2Package.INTERFACE:
                        Latte.getLatteData().moveToTrash((NamedElement)e);
                        break;
                        
                    default:
                        break;
                    }
                }
*/            
                // S~
                Latte.getLatteData().moveToTrash((NamedElement)removeDef);
                break;
            
            case UML2Package.INTERFACE:
                Interface intf = (Interface)removeDef;
                // ܂}폜
                ModelUtil.removeGraphNode((Element)removeDef);
/*
                // QƂ폜
                modelRemoveVisitor = new ModelRemoveVisitor((Interface)removeDef);
                modelRemoveVisitor.visit(Latte.getLatteData().getModel());
*/            
                // C^[tFCX
//                AllManip.INTERFACE.removeDef(removeDef);
                // qS~
/*
                List l = new ArrayList();
                l.addAll(intf.getOwnedMembers());
                for (Iterator i=(new ArrayList(intf.getNestedClassifiers())).iterator(); i.hasNext(); ) {
                    Element e = (Element)i.next();
                    switch (ModelUtil.getClassifierID(e)) {
                    case UML2Package.CLASS:
                    case UML2Package.INTERFACE:
                        Latte.getLatteData().moveToTrash((NamedElement)e);
                        break;
                        
                    default:
                        break;
                    }
                }
*/
                // S~
                Latte.getLatteData().moveToTrash((NamedElement)removeDef);
                break;
            
            case UML2Package.PACKAGE:
                // pbP[W
                Package p = (Package)removeDef;
                // S~
                Latte.getLatteData().moveToTrash(p);
                
/*            
                for (Iterator i=(new ArrayList(p.getOwnedMembers())).iterator(); i.hasNext(); ) {
                    Element e = (Element)i.next();
                    switch (ModelUtil.getClassifierID(e)) {
                    case UML2Package.CLASS:
                    case UML2Package.INTERFACE:
                        Latte.getLatteData().moveToTrash((NamedElement)e);
                        break;
                        
                    default:
                        break;
                    }
                }
                AllManip.PACKAGE.removeDef(removeDef);
*/                
                break;
            
            case DIPackage.DIAGRAM:
                // }
                AllManip.DIAGRAM.removeDef(removeDef);
                break;
                
            case DIPackage.GRAPH_NODE:
                // }폜(f͍폜Ȃ)
                // ֌WEdge폜(֌Wf͍폜Ȃ)
                diagram = GuiUtil.getSelectedLVDiag().getDiagram();
                element = ModelUtil.getElement((GraphNode)removeDef);
                ModelUtil.removeGraphNodeFromDiagram(diagram, element);
                // Rgmodel폜
                if (ModelUtil.getClassifierID(element) == UML2Package.COMMENT) {
                    Latte.getLatteData().getModel().getOwnedComments().remove(element);
                }
                break;

            case DIPackage.GRAPH_EDGE:
                // }폜(f͍폜Ȃ)
                GraphEdge graphEdge = (GraphEdge)removeDef;
                ModelUtil.removeGraphEdgeFromDiagram(GuiUtil.getSelectedLVDiag().getDiagram(), graphEdge);
                break;
            }

            // Xi폜
            removeDef.eAdapters().clear();
            
            // t@CۑKv
            ModelUtil.setNeedSaving();
        }
        catch (Exception e) {
            LogUtil.write("", e);
            MsgUtil.showMsg(e.getMessage());
        }
    }
    
    /**
     * `FbN
     * @param deleteDef
     */
    private void check(Object deleteDef) {
        // _CAO[g`FbN
        if (deleteDef == null) {
            throw new IllegalArgumentException("͍폜ł܂");
        }
        
        // f`FbN
        if (deleteDef == Latte.getLatteData().getModel()) {
            throw new IllegalArgumentException("fi[gpbP[Wj͍폜ł܂");
        }
        
        // ֘A`FbN
        if (ModelUtil.getClassifierID(deleteDef) == UML2Package.PROPERTY) {
            Property p = (Property)deleteDef;
            if (p.getAssociation() != null) {
                throw new IllegalArgumentException("֘A͍폜ł܂");            
            }
        }
    }
    /**
     * Model^폜
     * 
     * @param removeClassifier 폜NX or C^[tFCX
     */    
    public static class ModelRemoveVisitor extends ModelVisitor {
        /** 폜NX or C^[tFCX */
        private Classifier removeClassifier_ = null;
        /** ւEnum^ */
        private Enumeration enumeration_ = null;
        
        /**
         * RXgN^
         * 
         * @param removeClassifier
         */
        public ModelRemoveVisitor(Classifier removeClassifier) {
            removeClassifier_ = removeClassifier;
        }
        
        private Enumeration getEnumeration() {
            LogUtil.writeln("model -> enumeration:"+removeClassifier_.qualifiedName());
            if (enumeration_ == null) {
                enumeration_ = Latte.getLatteData().createAndAddEnumerationType(removeClassifier_.qualifiedName());
            }
            return enumeration_;
        }

        /**
         * Iy[V
         * 
         * @see latte.util.ModelUtil.ModelVisitor#operation(org.eclipse.uml2.Element)
         */
        public void operation(Element element) {
            switch (ModelUtil.getClassifierID(element)) {
            case UML2Package.PROPERTY:
                Property p = (Property)element;
                if (p.getType() == removeClassifier_) {
                    p.setType(getEnumeration());
                }
                break;
            
            case UML2Package.OPERATION:
                Operation o = (Operation)element;
                if (o.getType() == removeClassifier_) {
                    o.setType(getEnumeration());
                }
                break;
                
            case UML2Package.ASSOCIATION:
                Association a = (Association)element;
                for (Iterator i=a.getMemberEnds().iterator(); i.hasNext(); ) {
                    Property p1 = (Property)i.next();
                    if (p1.getType() == removeClassifier_) {
                        p1.setType(getEnumeration());
                    }
                }
                break;
            
            case UML2Package.DEPENDENCY:
                Dependency d = (Dependency)element;
                for (Iterator i=d.getClients().iterator(); i.hasNext(); ) {
                    Classifier c = (Classifier)i.next();
                    if (c == removeClassifier_) {
                        d.getClients().remove(c);
                        d.getClients().add(getEnumeration());
                    }
                }
                for (Iterator i=d.getSuppliers().iterator(); i.hasNext(); ) {
                    Classifier c = (Classifier)i.next();
                    if (c == removeClassifier_) {
                        d.getClients().remove(c);
                        d.getClients().add(getEnumeration());
                    }
                }
                break;
            
            case UML2Package.GENERALIZATION:
                Generalization g = (Generalization)element;
                if (g.getGeneral() == removeClassifier_) {
                    g.setGeneral(getEnumeration());
                }
                if (g.getSpecific() == removeClassifier_) {
                    g.setSpecific(getEnumeration());
                }
                break;
            
            case UML2Package.IMPLEMENTATION:
                Implementation i = (Implementation)element;
                // ֌Ŵǂ瑤폜ꂽA֌W폜
                if (i.getContract() == removeClassifier_ ||
                    i.getImplementingClassifier() == removeClassifier_) {
                    i.getImplementingClassifier().getImplementations().remove(i);
                }
                break;
            
            default:
                break;
            }
        }
    }    
}
