/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

import latte.di.GraphNode;
import latte.util.ModelUtil;

/**
 * FigureړANV
 * @version $Id: FigureMoveAction.java,v 1.2 2004/09/04 16:05:39 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class FigureMoveAction extends AbstractLatteAction {

    public FigureMoveAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    /**
     * IꂽƂ
     */
    public void execMain(Object param) {
        Object[] objs = (Object[])param;
        
        // Otm[h擾
        GraphNode graphNode =(GraphNode)objs[0];
        // 擾
        Dimension delta = (Dimension)objs[1];
//System.out.println(graphNode+"->"+delta);     

        // Jg}Gg擾
        int x = graphNode.getPosition().getX();
        int y = graphNode.getPosition().getY();
        Point position = new Point(x, y);
        position.translate(delta);
        latte.di.Point newPosition = ModelUtil.DiFactory.createPoint();
        newPosition.setX(position.x);
        newPosition.setY(position.y);
        graphNode.setPosition(newPosition);
        
        // t@CۑKv
        ModelUtil.setNeedSaving();        
    }
}
