/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import latte.util.GuiUtil;
import latte.util.MsgUtil;
import latte.view.LVDiag;

import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrintFigureOperation;
import org.eclipse.draw2d.geometry.Insets;

/**
 * @version $Id: FilePrintAction.java,v 1.3 2004/09/08 13:17:12 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class FilePrintAction extends AbstractLatteAction {

    public FilePrintAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    public void execMain(Object param) {
        // JgDiag擾
        LVDiag curDiag = GuiUtil.getSelectedLVDiag();
        if (curDiag == null) {
            MsgUtil.showMsg("}\Ă܂B\n\n}\ĂĂB");
            return;
        }
        IFigure view = curDiag.getDraw2dView();
        String name = curDiag.getTabItem().getText();
        
        // v^쐬
        PrinterData pdata = GuiUtil.openPrintDialog();
        Printer printer = new Printer(pdata);
        
        PrintFigureOperation op = new PrintFigureOperation(printer, view);
        op.setPrintMargin(new Insets(0,0,0,0));
        op.run("Latte:"+name);  // v^JOBݒ
        
        // v^j
        printer.dispose();
    }
    

    /**
      * Druckt eine IFigure uber mehrere Seiten.
      * @author Sven Muller
      *
    class PrintBigFigureOperation extends PrintFigureOperation {

        private double scale;

        public PrintBigFigureOperation(Printer printer, IFigure figure) {
            super(printer, figure);
            scale = getPrinter().getDPI().x / Display.getDefault().getDPI().x;
        }

        /**
         * @see org.eclipse.draw2d.PrintOperation#printPages()
         *
        protected void printPages() {
            IFigure figure = getPrintSource();
            boolean nextPage = true;
            Point offset = figure.getBounds().getLocation();
            int x =
                (int) (getPrintSource().getBounds().getSize().width
                    / (getPrintRegion().width / scale));
            int y =
                (int) (getPrintSource().getBounds().getSize().height
                    / (getPrintRegion().height / scale));
            PrinterGraphics g = getFreshPrinterGraphics();
            g.setForegroundColor(figure.getForegroundColor());
            g.setBackgroundColor(figure.getBackgroundColor());
            g.setFont(figure.getFont());

            for (int i = 0; i < getNumofPages(); i++) {
                g.pushState();
                getPrinter().startPage();
                g.scale(scale);
                g.translate(-offset.x, -offset.y);
                g.clipRect(figure.getBounds());
                figure.paint(g);
                getPrinter().endPage();
                g.restoreState();
                if (x > 0) {
                    x--;
                    offset.x += (int) (getPrintRegion().width / scale);
                } else if (y > 0) {
                    y--;
                    offset.y += (int) (getPrintRegion().height / scale);
                    offset.x = figure.getBounds().getLocation().x;
                    x =
                        (int) (getPrintSource().getBounds().getSize().width
                            / (getPrintRegion().width / scale));
                }
            }
        }
        /**
         * @see org.eclipse.draw2d.PrintOperation#run(String)
         *
        public void run(String jobName) {
                super.run(jobName);
        }
        /**
         * Berechnet die Seiten die notig sind um die {@link IFigure IFigure} 
    auf dem gewahlten {@link Printer Printer} auszugeben
         * @return int
         *
        private int getNumofPages() {
            double x =
                getPrintSource().getBounds().getSize().width
                    / (getPrintRegion().width / scale);
            double y =
                getPrintSource().getBounds().getSize().height
                    / (getPrintRegion().height / scale);
            return ((x > (int) x) ? (int) x + 1 : (int) x)
                * ((y > (int) y) ? (int) y + 1 : (int) y);
        }
    }
*/    
}
