/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;


import java.io.File;

import latte.Latte;
import latte.LatteData;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.MsgUtil;

import org.eclipse.swt.SWT;


/**
 * @version $Id: FileSaveAsAction.java,v 1.3 2004/10/02 04:27:56 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class FileSaveAsAction extends AbstractLatteAction {

    public FileSaveAsAction(String title, String imageFile) {
        super(title, imageFile);
    }
  
    public void execMain(Object param) {
        try {
            //LatteData擾
            LatteData latteData = Latte.getLatteData();

            // ݗp_CAOJ
            String saveFile = GuiUtil.openFileDialog(SWT.SAVE);
            // LZȂ߂
            if (saveFile == null) {
                return;
            }
            // gqꍇ.latt
            if (saveFile.indexOf(".")==-1) {
                saveFile += ".lat";
            }
            
            // LatteDataZ[u
            latteData.setFile(new File(saveFile));
            latteData.save();
            
            // ^Cg
            Latte.getMainForm().setTitle(saveFile);
        }
        catch (Exception e) {
            LogUtil.write("t@CۑɎs܂", e);
            MsgUtil.showMsg("t@CۑɎs܂");
        }
    }
}
