/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.MenuItem;

import latte.Latte;
import latte.di.GraphNode;
import latte.util.ModelUtil;

/**
 * \
 * 
 * @version $Id: ShowAttributeAction.java,v 1.2 2004/09/08 13:17:13 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class ShowAttributeAction extends AbstractLatteAction {

    public ShowAttributeAction(String title, String imageFile) {
        super(title, imageFile);
    }
 
    /**
     * Is
     * 
     * @param param IꂽIuWFNg
     */   
    public void execMain(Object param) {
        // 
        SelectionEvent se = (SelectionEvent)param;
        MenuItem menuItem = (MenuItem)se.getSource();
        // I擾
        GraphNode selectedNode = (GraphNode)Latte.getMainForm().getSelectedModels();
        
        // ݒF\\A\\
        if (menuItem.getSelection()) {
            ModelUtil.setAttributeVisible(selectedNode, true);
        } else {
            ModelUtil.setAttributeVisible(selectedNode, false);
        }        
    }
}
