/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import latte.Latte;
import latte.util.GuiUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;

import com.sun.tools.javadoc.Main;


/**
 * 
 * Javao[X@\
 * 
 * @version $Id: ToolJavaReverseAction.java,v 1.2 2004/09/04 16:05:38 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class ToolJavaReverseAction extends AbstractLatteAction {
    private Shell dialog_ = null;
    private Text fileTxt_ = null;
    private Text packagesTxt_ = null;
	
    public ToolJavaReverseAction(String title, String imageFile) {
        super(title, imageFile);
    }
 
    /**
     * I
     */
    public void execMain(Object param) {
        try {
            // _CAO쐬\
            showDialog();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    void reverse(String dir, String packages) {
        String[] args = new String[9];
        args[0] = "-docletpath";
        args[1] = System.getProperty("java.class.path");
        args[2] = "-source";
        args[3] = "1.4";
        args[4] = "-sourcepath";
        args[5] = dir;
        args[6] = "-private";
        args[7] = "-subpackages";
        args[8] = packages;
        Main.execute("latte", "latte.util.ReverseDoclet", args);
    }

    /**
     * _CAO̍쐬\
     */
    private void showDialog() {
        dialog_ = GuiUtil.createDialog(600, 180, getTitle());
        GuiUtil.createLabelInForm(dialog_, "Java\[XfBNg", 10, 22, 100, 13);
        fileTxt_ = GuiUtil.createTextInForm(dialog_, 130, 20, 350, 13);
        GuiUtil.createButtonInForm(dialog_, "Q", 515, 20, 40, 20, new FileDiagSelection());
        GuiUtil.createLabelInForm(dialog_, "pbP[W", 10, 52, 100, 13);
        packagesTxt_ = GuiUtil.createTextInForm(dialog_, 130, 50, 350, 13);
        
        GuiUtil.createLabelInForm(dialog_, "pbP[Wȉo[XÃ݂fɒǉ܂", 130, 90, 400, 30);
            
        GuiUtil.createButtonInForm(dialog_, "s", 200, 140, 80, 25, new ReverseSelection());
        GuiUtil.createButtonInForm(dialog_, "LZ", 310, 140, 80, 25, new CancelSelection());
            
        dialog_.open();
    }
    
    
    
    /**
     * o[XJn
     */
    class ReverseSelection extends SelectionAdapter {
        public void widgetSelected(SelectionEvent event) {
            try {
                // t@CۑKv
                ModelUtil.setNeedSaving();
                
                // t@C擾
                final String dirName = fileTxt_.getText();
                final String packagesName = packagesTxt_.getText();
                if (dirName.length() == 0) {
                    MsgUtil.showMsg("java\[XfBNg͂Ă");
                    return;
                }
                if (packagesName.length() == 0) {
                    MsgUtil.showMsg("pbP[W͂Ă");
                    return;
                }
                
                // _CAO
                dialog_.close();            
                // ҂}EXJ[\
                GuiUtil.setWaitMouseCursor();
                // ʒmCxg
                Latte.getMainForm().getTree().enableModelNotification(false);

                // SWTG[ɂȂȂ悤ɂȂ񓯊Ŏs
                Display.getDefault().asyncExec(
                new Thread() {
                    public void run() {
                        try {
                            // o[Xs
                            reverse(dirName, packagesName);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MsgUtil.showMsgAsync("G[܂F"+e.getMessage());
                        }
                        finally {
                            // c[fƓ
                            Latte.getMainForm().getTree().syncTree();
                            // W}EXJ[\
                            GuiUtil.setNormalMouseCursor();
                            // ʒmCxgL
                            Latte.getMainForm().getTree().enableModelNotification(true);                                                                         
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    class CancelSelection extends SelectionAdapter {
        public void widgetSelected(SelectionEvent event) {
            dialog_.close();
        }
    }

    class FileDiagSelection extends SelectionAdapter {
        public void widgetSelected(SelectionEvent event) {
            // ǂݍݗp_CAOJ
            String openDir = GuiUtil.openDirectoryDialog("Java\[XfBNg̎w");
            // LZȂ߂
            if (openDir == null) {
                return;
            }
            // It@C𔽉f
            fileTxt_.setText(openDir);
        }
    }
}
