/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action.mm;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.VisibilityKind;

import com.sun.javadoc.ClassDoc;

import latte.InternalLogicException;
import latte.util.ModelUtil;


/**
 * 
 * NX̑i쐬AǉA폜j
 * 
 * @version $Id: ClassManip.java,v 1.4 2004/10/02 04:28:08 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class ClassManip implements IAddManip, IRemoveManip {

    /**
     * V`쐬
     */
    public EObject createDef(Object param){
        Class c = ModelUtil.Uml2Factory.createClass();
        if (param instanceof ClassDoc) {
            ClassDoc doc = (ClassDoc)param;
            // 
            if (doc.isPublic()) {
                c.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            } else if (doc.isPackagePrivate()) {
                c.setVisibility(VisibilityKind.PACKAGE_LITERAL);
            } else if (doc.isProtected()) {
                c.setVisibility(VisibilityKind.PROTECTED_LITERAL);
            } else if (doc.isPrivate()) {
                c.setVisibility(VisibilityKind.PRIVATE_LITERAL);
            }            
            // O
            String name = null;
            int index = doc.name().lastIndexOf(".");
            if (index == -1) {
                name = doc.name();
            } else {
                name = doc.name().substring(index+1);
            }
            c.setName(name);
            // ۉ
            c.setIsAbstract(doc.isAbstract());
        } else {
            // 
            c.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            // O
            c.setName("NX");
        }
        return c;
    }

    /**
     * V`eɒǉ
     */
    public void addDef(EObject parent, EObject newDef) {
        if (parent instanceof Package){
            // pbP[WAfɒǉ
            Package p = (Package)parent;
            int index = ModelUtil.getInsertIndex(p.getOwnedMembers().toArray(), newDef, false);
            p.getOwnedMembers().add(index, newDef);
        } else if (parent instanceof Class) {
            // NXɒǉ
            Class c = (Class)parent;
            int index = ModelUtil.getInsertIndex(c.getNestedClassifiers().toArray(), newDef, false);
            c.getNestedClassifiers().add(index, newDef);
        } else if (parent instanceof Interface) {
            // C^[tFCXɒǉ
            Interface i = (Interface)parent;
            int index = ModelUtil.getInsertIndex(i.getNestedClassifiers().toArray(), newDef, false);
            i.getNestedClassifiers().add(index, newDef);
        } else {
            throw new InternalLogicException("NX͒ǉł܂ in " + parent);
        }
    }

    /**
     * 폜
     */
    public void removeDef(EObject removeDef) {
        Class removeClass = (Class)removeDef;
        Element owner = removeClass.getOwner();
        
        // I[i[ŕ
        switch (ModelUtil.getClassifierID(owner)) {
        case UML2Package.PACKAGE:
            // f폜
            Model m = (Model)owner;
            m.getOwnedMembers().remove(removeDef);
            break;

        case UML2Package.MODEL:
            // pbP[W폜
            Package p = (Package)owner;
            p.getOwnedMembers().remove(removeDef);
            break;
        
        case UML2Package.CLASS:
            // NX폜
            Class oc = (Class)owner;
            oc.getNestedClassifiers().remove(removeDef);
            break;
        
        case UML2Package.INTERFACE:
            // C^[tFCX폜
            Interface i = (Interface)owner;
            i.getNestedClassifiers().remove(removeDef);
            break;
        
        default:
            throw new InternalLogicException("NX͍폜ł܂");
        }
    }
}
