/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action.mm;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

import latte.Latte;
import latte.di.Diagram;
import latte.di.SimpleSemanticModelElement;
import latte.util.ModelUtil;
import latte.view.LVDiag;


/**
 * 
 * NX}̑i쐬AǉA폜j
 * 
 * @version $Id: DiagramManip.java,v 1.4 2004/02/19 18:23:39 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class DiagramManip implements IAddManip, IRemoveManip {

    /**
     * }쐬
     */
    public EObject createDef(Object param){
        String type = (String)param;
        
        SimpleSemanticModelElement e = ModelUtil.DiFactory.createSimpleSemanticModelElement();
        Diagram d = ModelUtil.DiFactory.createDiagram();
        e.setTypeInfo(type);
        
        String name = null;
        if (type.equals(LVDiag.TYPE_CLASS_DIAG)) {
            name = "NX}";
        } else if (type.equals(LVDiag.TYPE_SEQ_DIAG)) {
            name = "V[PX}";
        }
        d.setName(name);
        d.setNamespace(e);

        return d;
    }

    /**
     * }ǉ
     * 
     * parent͖
     */
    public void addDef(EObject parent, EObject newDef) {
        EList eList = Latte.getLatteData().getDiagrams().getContained();
        int index = ModelUtil.getInsertIndex(eList.toArray(), newDef, false);
        eList.add(index, newDef);
        
    }

    /**
     * }폜
     */
    public void removeDef(EObject removeDef) {
        if (removeDef instanceof Diagram) {
            // }̍폜
            Latte.getLatteData().getDiagrams().getContained().remove(removeDef);
        }
    }
}
