/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.di;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * @model abstract="true"
 */
public interface DiagramElement extends EObject{
    /**
     * @model
     */
    boolean isVisible();

    /**
     * Sets the value of the '{@link latte.di.DiagramElement#isVisible <em>Visible</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Visible</em>' attribute.
     * @see #isVisible()
     * @generated
     */
	void setVisible(boolean value);

	/**
	 * @model opposite="contained" 
	 */
	GraphElement getContainer();
	
    /**
     * Sets the value of the '{@link latte.di.DiagramElement#getContainer <em>Container</em>}' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Container</em>' container reference.
     * @see #getContainer()
     * @generated
     */
	void setContainer(GraphElement value);

	/**
	 * @model type="Reference" opposite="referenced"
	 */
	EList getReference();
	
	/**
	 * @model type="Property" containment="true"
	 */
	EList getProperty();
}
