/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.di;

import org.eclipse.emf.ecore.EObject;

/**
 * @model
 */
public interface DiagramLink extends EObject{
    /**
     * @model
     */
    double getZoom();
    
    /**
     * Sets the value of the '{@link latte.di.DiagramLink#getZoom <em>Zoom</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Zoom</em>' attribute.
     * @see #getZoom()
     * @generated
     */
	void setZoom(double value);

    /**
     * @model containment="true"  required="true"
     */
    Point getViewport();
    
    /**
     * Sets the value of the '{@link latte.di.DiagramLink#getViewport <em>Viewport</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Viewport</em>' containment reference.
     * @see #getViewport()
     * @generated
     */
	void setViewport(Point value);

    /**
     * @model required="true" opposite="link"
     */
    GraphElement getGraphElement();

    /**
     * Sets the value of the '{@link latte.di.DiagramLink#getGraphElement <em>Graph Element</em>}' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Graph Element</em>' container reference.
     * @see #getGraphElement()
     * @generated
     */
	void setGraphElement(GraphElement value);

    /**
     * @model required="true"  opposite="diagramLink"
     */
    Diagram getDiagram();
    
    /**
     * Sets the value of the '{@link latte.di.DiagramLink#getDiagram <em>Diagram</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Diagram</em>' reference.
     * @see #getDiagram()
     * @generated
     */
	void setDiagram(Diagram value);

}
