/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.di;

import org.eclipse.emf.common.util.EList;

/**
 * @model
 */
public interface GraphEdge extends GraphElement{
    /**
     * @model type="Point" lowerBound="2" required="true" containment="true"
     */
    EList getWaypoints();

	/**
	 * @model type="GraphConnector" lowerBound="2" upperBound="2" required="true" opposite="graphEdge"
	 */
	EList getAnchor();
}
