/**
 * <copyright>
 * </copyright>
 *
 * $Id: ImageImpl.java,v 1.2 2004/02/19 18:23:32 ohnuki Exp $
 */
package latte.di.impl;

import java.util.Collection;

import latte.di.DIPackage;
import latte.di.GraphElement;
import latte.di.Image;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Image</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.ImageImpl#getUri <em>Uri</em>}</li>
 *   <li>{@link latte.di.impl.ImageImpl#getMimeType <em>Mime Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ImageImpl extends LeafElementImpl implements Image {
    /**
     * The default value of the '{@link #getUri() <em>Uri</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getUri()
     * @generated
     * @ordered
     */
    protected static final String URI_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getUri() <em>Uri</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getUri()
     * @generated
     * @ordered
     */
    protected String uri = URI_EDEFAULT;

    /**
     * The default value of the '{@link #getMimeType() <em>Mime Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMimeType()
     * @generated
     * @ordered
     */
    protected static final String MIME_TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMimeType() <em>Mime Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMimeType()
     * @generated
     * @ordered
     */
    protected String mimeType = MIME_TYPE_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ImageImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getImage();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getUri() {
        return uri;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setUri(String newUri) {
        String oldUri = uri;
        uri = newUri;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.IMAGE__URI, oldUri, uri));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getMimeType() {
        return mimeType;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setMimeType(String newMimeType) {
        String oldMimeType = mimeType;
        mimeType = newMimeType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.IMAGE__MIME_TYPE, oldMimeType, mimeType));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.IMAGE__CONTAINER:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.IMAGE__CONTAINER, msgs);
                case DIPackage.IMAGE__REFERENCE:
                    return ((InternalEList)getReference()).basicAdd(otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.IMAGE__CONTAINER:
                    return eBasicSetContainer(null, DIPackage.IMAGE__CONTAINER, msgs);
                case DIPackage.IMAGE__REFERENCE:
                    return ((InternalEList)getReference()).basicRemove(otherEnd, msgs);
                case DIPackage.IMAGE__PROPERTY:
                    return ((InternalEList)getProperty()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.IMAGE__CONTAINER:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__CONTAINED, GraphElement.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.IMAGE__VISIBLE:
                return isVisible() ? Boolean.TRUE : Boolean.FALSE;
            case DIPackage.IMAGE__CONTAINER:
                return getContainer();
            case DIPackage.IMAGE__REFERENCE:
                return getReference();
            case DIPackage.IMAGE__PROPERTY:
                return getProperty();
            case DIPackage.IMAGE__URI:
                return getUri();
            case DIPackage.IMAGE__MIME_TYPE:
                return getMimeType();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.IMAGE__VISIBLE:
                setVisible(((Boolean)newValue).booleanValue());
                return;
            case DIPackage.IMAGE__CONTAINER:
                setContainer((GraphElement)newValue);
                return;
            case DIPackage.IMAGE__REFERENCE:
                getReference().clear();
                getReference().addAll((Collection)newValue);
                return;
            case DIPackage.IMAGE__PROPERTY:
                getProperty().clear();
                getProperty().addAll((Collection)newValue);
                return;
            case DIPackage.IMAGE__URI:
                setUri((String)newValue);
                return;
            case DIPackage.IMAGE__MIME_TYPE:
                setMimeType((String)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.IMAGE__VISIBLE:
                setVisible(VISIBLE_EDEFAULT);
                return;
            case DIPackage.IMAGE__CONTAINER:
                setContainer((GraphElement)null);
                return;
            case DIPackage.IMAGE__REFERENCE:
                getReference().clear();
                return;
            case DIPackage.IMAGE__PROPERTY:
                getProperty().clear();
                return;
            case DIPackage.IMAGE__URI:
                setUri(URI_EDEFAULT);
                return;
            case DIPackage.IMAGE__MIME_TYPE:
                setMimeType(MIME_TYPE_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.IMAGE__VISIBLE:
                return visible != VISIBLE_EDEFAULT;
            case DIPackage.IMAGE__CONTAINER:
                return getContainer() != null;
            case DIPackage.IMAGE__REFERENCE:
                return reference != null && !reference.isEmpty();
            case DIPackage.IMAGE__PROPERTY:
                return property != null && !property.isEmpty();
            case DIPackage.IMAGE__URI:
                return URI_EDEFAULT == null ? uri != null : !URI_EDEFAULT.equals(uri);
            case DIPackage.IMAGE__MIME_TYPE:
                return MIME_TYPE_EDEFAULT == null ? mimeType != null : !MIME_TYPE_EDEFAULT.equals(mimeType);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (uri: ");
        result.append(uri);
        result.append(", mimeType: ");
        result.append(mimeType);
        result.append(')');
        return result.toString();
    }

} //ImageImpl
