/**
 * <copyright>
 * </copyright>
 *
 * $Id: ReferenceImpl.java,v 1.2 2004/02/19 18:23:33 ohnuki Exp $
 */
package latte.di.impl;

import java.util.Collection;

import latte.di.DIPackage;
import latte.di.DiagramElement;
import latte.di.GraphElement;
import latte.di.Reference;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Reference</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.ReferenceImpl#isIndividualRepresentaion <em>Individual Representaion</em>}</li>
 *   <li>{@link latte.di.impl.ReferenceImpl#getReferenced <em>Referenced</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ReferenceImpl extends DiagramElementImpl implements Reference {
    /**
     * The default value of the '{@link #isIndividualRepresentaion() <em>Individual Representaion</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isIndividualRepresentaion()
     * @generated
     * @ordered
     */
    protected static final boolean INDIVIDUAL_REPRESENTAION_EDEFAULT = false;

    /**
     * The cached value of the '{@link #isIndividualRepresentaion() <em>Individual Representaion</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isIndividualRepresentaion()
     * @generated
     * @ordered
     */
    protected boolean individualRepresentaion = INDIVIDUAL_REPRESENTAION_EDEFAULT;

    /**
     * The cached value of the '{@link #getReferenced() <em>Referenced</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getReferenced()
     * @generated
     * @ordered
     */
    protected DiagramElement referenced = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ReferenceImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getReference();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean isIndividualRepresentaion() {
        return individualRepresentaion;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setIndividualRepresentaion(boolean newIndividualRepresentaion) {
        boolean oldIndividualRepresentaion = individualRepresentaion;
        individualRepresentaion = newIndividualRepresentaion;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.REFERENCE__INDIVIDUAL_REPRESENTAION, oldIndividualRepresentaion, individualRepresentaion));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DiagramElement getReferenced() {
        if (referenced != null && referenced.eIsProxy()) {
            DiagramElement oldReferenced = referenced;
            referenced = (DiagramElement)eResolveProxy((InternalEObject)referenced);
            if (referenced != oldReferenced) {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, DIPackage.REFERENCE__REFERENCED, oldReferenced, referenced));
            }
        }
        return referenced;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DiagramElement basicGetReferenced() {
        return referenced;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetReferenced(DiagramElement newReferenced, NotificationChain msgs) {
        DiagramElement oldReferenced = referenced;
        referenced = newReferenced;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DIPackage.REFERENCE__REFERENCED, oldReferenced, newReferenced);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setReferenced(DiagramElement newReferenced) {
        if (newReferenced != referenced) {
            NotificationChain msgs = null;
            if (referenced != null)
                msgs = ((InternalEObject)referenced).eInverseRemove(this, DIPackage.DIAGRAM_ELEMENT__REFERENCE, DiagramElement.class, msgs);
            if (newReferenced != null)
                msgs = ((InternalEObject)newReferenced).eInverseAdd(this, DIPackage.DIAGRAM_ELEMENT__REFERENCE, DiagramElement.class, msgs);
            msgs = basicSetReferenced(newReferenced, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.REFERENCE__REFERENCED, newReferenced, newReferenced));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.REFERENCE__CONTAINER:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.REFERENCE__CONTAINER, msgs);
                case DIPackage.REFERENCE__REFERENCE:
                    return ((InternalEList)getReference()).basicAdd(otherEnd, msgs);
                case DIPackage.REFERENCE__REFERENCED:
                    if (referenced != null)
                        msgs = ((InternalEObject)referenced).eInverseRemove(this, DIPackage.DIAGRAM_ELEMENT__REFERENCE, DiagramElement.class, msgs);
                    return basicSetReferenced((DiagramElement)otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.REFERENCE__CONTAINER:
                    return eBasicSetContainer(null, DIPackage.REFERENCE__CONTAINER, msgs);
                case DIPackage.REFERENCE__REFERENCE:
                    return ((InternalEList)getReference()).basicRemove(otherEnd, msgs);
                case DIPackage.REFERENCE__PROPERTY:
                    return ((InternalEList)getProperty()).basicRemove(otherEnd, msgs);
                case DIPackage.REFERENCE__REFERENCED:
                    return basicSetReferenced(null, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.REFERENCE__CONTAINER:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__CONTAINED, GraphElement.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.REFERENCE__VISIBLE:
                return isVisible() ? Boolean.TRUE : Boolean.FALSE;
            case DIPackage.REFERENCE__CONTAINER:
                return getContainer();
            case DIPackage.REFERENCE__REFERENCE:
                return getReference();
            case DIPackage.REFERENCE__PROPERTY:
                return getProperty();
            case DIPackage.REFERENCE__INDIVIDUAL_REPRESENTAION:
                return isIndividualRepresentaion() ? Boolean.TRUE : Boolean.FALSE;
            case DIPackage.REFERENCE__REFERENCED:
                if (resolve) return getReferenced();
                return basicGetReferenced();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.REFERENCE__VISIBLE:
                setVisible(((Boolean)newValue).booleanValue());
                return;
            case DIPackage.REFERENCE__CONTAINER:
                setContainer((GraphElement)newValue);
                return;
            case DIPackage.REFERENCE__REFERENCE:
                getReference().clear();
                getReference().addAll((Collection)newValue);
                return;
            case DIPackage.REFERENCE__PROPERTY:
                getProperty().clear();
                getProperty().addAll((Collection)newValue);
                return;
            case DIPackage.REFERENCE__INDIVIDUAL_REPRESENTAION:
                setIndividualRepresentaion(((Boolean)newValue).booleanValue());
                return;
            case DIPackage.REFERENCE__REFERENCED:
                setReferenced((DiagramElement)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.REFERENCE__VISIBLE:
                setVisible(VISIBLE_EDEFAULT);
                return;
            case DIPackage.REFERENCE__CONTAINER:
                setContainer((GraphElement)null);
                return;
            case DIPackage.REFERENCE__REFERENCE:
                getReference().clear();
                return;
            case DIPackage.REFERENCE__PROPERTY:
                getProperty().clear();
                return;
            case DIPackage.REFERENCE__INDIVIDUAL_REPRESENTAION:
                setIndividualRepresentaion(INDIVIDUAL_REPRESENTAION_EDEFAULT);
                return;
            case DIPackage.REFERENCE__REFERENCED:
                setReferenced((DiagramElement)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.REFERENCE__VISIBLE:
                return visible != VISIBLE_EDEFAULT;
            case DIPackage.REFERENCE__CONTAINER:
                return getContainer() != null;
            case DIPackage.REFERENCE__REFERENCE:
                return reference != null && !reference.isEmpty();
            case DIPackage.REFERENCE__PROPERTY:
                return property != null && !property.isEmpty();
            case DIPackage.REFERENCE__INDIVIDUAL_REPRESENTAION:
                return individualRepresentaion != INDIVIDUAL_REPRESENTAION_EDEFAULT;
            case DIPackage.REFERENCE__REFERENCED:
                return referenced != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (individualRepresentaion: ");
        result.append(individualRepresentaion);
        result.append(')');
        return result.toString();
    }

} //ReferenceImpl
