/**
 * <copyright>
 * </copyright>
 *
 * $Id: SemanticModelBridgeImpl.java,v 1.2 2004/02/19 18:23:35 ohnuki Exp $
 */
package latte.di.impl;

import latte.di.DIPackage;
import latte.di.Diagram;
import latte.di.GraphElement;
import latte.di.SemanticModelBridge;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Semantic Model Bridge</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.SemanticModelBridgeImpl#getPresentation <em>Presentation</em>}</li>
 *   <li>{@link latte.di.impl.SemanticModelBridgeImpl#getGraphElement <em>Graph Element</em>}</li>
 *   <li>{@link latte.di.impl.SemanticModelBridgeImpl#getDiagram <em>Diagram</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class SemanticModelBridgeImpl extends EObjectImpl implements SemanticModelBridge {
    /**
     * The default value of the '{@link #getPresentation() <em>Presentation</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPresentation()
     * @generated
     * @ordered
     */
    protected static final String PRESENTATION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getPresentation() <em>Presentation</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPresentation()
     * @generated
     * @ordered
     */
    protected String presentation = PRESENTATION_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SemanticModelBridgeImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getSemanticModelBridge();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getPresentation() {
        return presentation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setPresentation(String newPresentation) {
        String oldPresentation = presentation;
        presentation = newPresentation;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.SEMANTIC_MODEL_BRIDGE__PRESENTATION, oldPresentation, presentation));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public GraphElement getGraphElement() {
        if (eContainerFeatureID != DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT) return null;
        return (GraphElement)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setGraphElement(GraphElement newGraphElement) {
        if (newGraphElement != eContainer || (eContainerFeatureID != DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT && newGraphElement != null)) {
            if (EcoreUtil.isAncestor(this, newGraphElement))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newGraphElement != null)
                msgs = ((InternalEObject)newGraphElement).eInverseAdd(this, DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL, GraphElement.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newGraphElement, DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT, newGraphElement, newGraphElement));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Diagram getDiagram() {
        if (eContainerFeatureID != DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM) return null;
        return (Diagram)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setDiagram(Diagram newDiagram) {
        if (newDiagram != eContainer || (eContainerFeatureID != DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM && newDiagram != null)) {
            if (EcoreUtil.isAncestor(this, newDiagram))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newDiagram != null)
                msgs = ((InternalEObject)newDiagram).eInverseAdd(this, DIPackage.DIAGRAM__NAMESPACE, Diagram.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newDiagram, DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM, newDiagram, newDiagram));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT, msgs);
                case DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                    return eBasicSetContainer(null, DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT, msgs);
                case DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                    return eBasicSetContainer(null, DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL, GraphElement.class, msgs);
                case DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.DIAGRAM__NAMESPACE, Diagram.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.SEMANTIC_MODEL_BRIDGE__PRESENTATION:
                return getPresentation();
            case DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                return getGraphElement();
            case DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                return getDiagram();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.SEMANTIC_MODEL_BRIDGE__PRESENTATION:
                setPresentation((String)newValue);
                return;
            case DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                setGraphElement((GraphElement)newValue);
                return;
            case DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                setDiagram((Diagram)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.SEMANTIC_MODEL_BRIDGE__PRESENTATION:
                setPresentation(PRESENTATION_EDEFAULT);
                return;
            case DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                setGraphElement((GraphElement)null);
                return;
            case DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                setDiagram((Diagram)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.SEMANTIC_MODEL_BRIDGE__PRESENTATION:
                return PRESENTATION_EDEFAULT == null ? presentation != null : !PRESENTATION_EDEFAULT.equals(presentation);
            case DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                return getGraphElement() != null;
            case DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                return getDiagram() != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (presentation: ");
        result.append(presentation);
        result.append(')');
        return result.toString();
    }

} //SemanticModelBridgeImpl
