/**
 * <copyright>
 * </copyright>
 *
 * $Id: DISwitch.java,v 1.2 2004/02/19 18:23:42 ohnuki Exp $
 */
package latte.di.util;

import java.util.List;

import latte.di.*;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see latte.di.DIPackage
 * @generated
 */
public class DISwitch {
    /**
     * The cached model package
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static DIPackage modelPackage;

    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DISwitch() {
        if (modelPackage == null) {
            modelPackage = DIPackage.eINSTANCE;
        }
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    public Object doSwitch(EObject theEObject) {
        return doSwitch(theEObject.eClass(), theEObject);
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    protected Object doSwitch(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackage) {
            return doSwitch(theEClass.getClassifierID(), theEObject);
        }
        else {
            List eSuperTypes = theEClass.getESuperTypes();
            return
                eSuperTypes.isEmpty() ?
                    defaultCase(theEObject) :
                    doSwitch((EClass)eSuperTypes.get(0), theEObject);
        }
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    protected Object doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE: {
                CoreSemanticModelBridge coreSemanticModelBridge = (CoreSemanticModelBridge)theEObject;
                Object result = caseCoreSemanticModelBridge(coreSemanticModelBridge);
                if (result == null) result = caseSemanticModelBridge(coreSemanticModelBridge);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.REFERENCE: {
                Reference reference = (Reference)theEObject;
                Object result = caseReference(reference);
                if (result == null) result = caseDiagramElement(reference);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.DIAGRAM: {
                Diagram diagram = (Diagram)theEObject;
                Object result = caseDiagram(diagram);
                if (result == null) result = caseGraphNode(diagram);
                if (result == null) result = caseGraphElement(diagram);
                if (result == null) result = caseDiagramElement(diagram);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.DIAGRAM_LINK: {
                DiagramLink diagramLink = (DiagramLink)theEObject;
                Object result = caseDiagramLink(diagramLink);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.GRAPH_CONNECTOR: {
                GraphConnector graphConnector = (GraphConnector)theEObject;
                Object result = caseGraphConnector(graphConnector);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.GRAPH_EDGE: {
                GraphEdge graphEdge = (GraphEdge)theEObject;
                Object result = caseGraphEdge(graphEdge);
                if (result == null) result = caseGraphElement(graphEdge);
                if (result == null) result = caseDiagramElement(graphEdge);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.GRAPH_NODE: {
                GraphNode graphNode = (GraphNode)theEObject;
                Object result = caseGraphNode(graphNode);
                if (result == null) result = caseGraphElement(graphNode);
                if (result == null) result = caseDiagramElement(graphNode);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.IMAGE: {
                Image image = (Image)theEObject;
                Object result = caseImage(image);
                if (result == null) result = caseLeafElement(image);
                if (result == null) result = caseDiagramElement(image);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.PROPERTY: {
                Property property = (Property)theEObject;
                Object result = caseProperty(property);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.SIMPLE_SEMANTIC_MODEL_ELEMENT: {
                SimpleSemanticModelElement simpleSemanticModelElement = (SimpleSemanticModelElement)theEObject;
                Object result = caseSimpleSemanticModelElement(simpleSemanticModelElement);
                if (result == null) result = caseSemanticModelBridge(simpleSemanticModelElement);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.TEXT_ELEMENT: {
                TextElement textElement = (TextElement)theEObject;
                Object result = caseTextElement(textElement);
                if (result == null) result = caseLeafElement(textElement);
                if (result == null) result = caseDiagramElement(textElement);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.POINT: {
                Point point = (Point)theEObject;
                Object result = casePoint(point);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DIPackage.DIMENSION: {
                Dimension dimension = (Dimension)theEObject;
                Object result = caseDimension(dimension);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Core Semantic Model Bridge</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Core Semantic Model Bridge</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseCoreSemanticModelBridge(CoreSemanticModelBridge object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Reference</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Reference</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseReference(Reference object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Diagram</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Diagram</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseDiagram(Diagram object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Diagram Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Diagram Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseDiagramElement(DiagramElement object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Diagram Link</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Diagram Link</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseDiagramLink(DiagramLink object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Graph Connector</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Graph Connector</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseGraphConnector(GraphConnector object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Graph Edge</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Graph Edge</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseGraphEdge(GraphEdge object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Graph Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Graph Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseGraphElement(GraphElement object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Graph Node</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Graph Node</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseGraphNode(GraphNode object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Graphic Primitive</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Graphic Primitive</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseGraphicPrimitive(GraphicPrimitive object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Image</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Image</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseImage(Image object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Leaf Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Leaf Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseLeafElement(LeafElement object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Property</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Property</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseProperty(Property object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Semantic Model Bridge</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Semantic Model Bridge</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseSemanticModelBridge(SemanticModelBridge object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Simple Semantic Model Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Simple Semantic Model Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseSimpleSemanticModelElement(SimpleSemanticModelElement object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Text Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Text Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseTextElement(TextElement object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Point</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Point</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object casePoint(Point object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Dimension</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Dimension</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseDimension(Dimension object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch, but this is the last case anyway.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    public Object defaultCase(EObject object) {
        return null;
    }

} //DISwitch
