/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.util;

import java.io.InputStream;

import latte.Latte;
import latte.action.AbstractLatteAction;
import latte.view.LVDiag;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/**
 * @version $Id: GuiUtil.java,v 1.4 2004/10/02 04:27:58 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class GuiUtil {
    /** gq */
    public static final String[] LATTE_EXTENTION = {"*.lat","*.*"};
    public static final String[] XMI_EXTENTION = {"*.xml","*.xmi", "*.*"};
	public static final String[] RXP_EXTENTION = {"*.rxp","*.*"};
    
    private static Display display_ = null;
    private static Shell shell_ = null;
    
    
    public static void syncExce(Runnable runnable) {
        display_.syncExec(runnable);
    }
    
    /**
     * m[g̓_CAO̕\
     * 
     * Iɕ
     * 
     * @param ok
     */
    public static String showNoteDialog(String initNote) {
        final String[] note = new String[1]; // finalɂ邽ߔzɂ
        // _CAO쐬
        final Shell dialog = GuiUtil.createDialog(400, 300, "m[g");
        final Text noteTxt = GuiUtil.createMultilineTextInForm(dialog, 0, 0, 350, 180);
        noteTxt.setText(initNote);

        SelectionAdapter ok = new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                note[0] = noteTxt.getText();
                // _CAO
                dialog.close();
            }
        };
        SelectionAdapter cancel = new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                // _CAO
                dialog.close();
            }
        };
        
        GuiUtil.createButtonInForm(dialog, "OK", 100, 260, 90, 30, ok);
        GuiUtil.createButtonInForm(dialog, "LZ", 210, 260, 90, 30, cancel);
        // _CAOJ
        dialog.open();
        // ܂ő҂
        while (!dialog.isDisposed ()) {
            if (!display_.readAndDispatch ()) display_.sleep ();
        }
        
        return note[0];
    }
    
    /**
     * vJ[\ɐݒ
     * XbhZ[t
     *
     */
    public static void setWaitMouseCursor() {
        display_.syncExec(new Runnable(){
            public void run() {
                shell_.setCursor(new Cursor(display_, SWT.CURSOR_WAIT));
            }
        });
    }
    /**
     * W}EXJ[\ɐݒ
     * XbhZ[t
     * finallyĂяoƁI
     *
     */
    public static void setNormalMouseCursor() {
        display_.syncExec(new Runnable(){
            public void run() {
                shell_.setCursor(null);
            }
        });
    }

    /**
     * tH[ɃRg[쐬
     * @param dialog e
     * @param text ^Cg
     * @param x ʒuX
     * @param y ʒuY
     * @param width 
     * @param height 
     */    
    public static Button createButtonInForm(Shell dialog, String text, int x, int y, int width, int height, SelectionListener listener) {
        Button b = new Button(dialog, SWT.NULL);
        b.setText(text);
        setBoundInForm(dialog, b, x, y, width, height);
        if (listener != null) {
            b.addSelectionListener(listener);
        }
        
        return b;
    }
    
    public static Label createLabelInForm(Shell dialog, String text, int x, int y, int width, int height) {
        Label l = new Label(dialog, SWT.NULL);
        l.setText(text);
        setBoundInForm(dialog, l, x, y, width, height);
        return l;
    }
    public static Text createTextInForm(Shell dialog, int x, int y, int width, int height) {
        Text t = new Text(dialog, SWT.SINGLE | SWT.BORDER);
        setBoundInForm(dialog, t, x, y, width, height);
        return t;
    }
    public static Text createMultilineTextInForm(Shell dialog, int x, int y, int width, int height) {
        Text t = new Text(dialog, SWT.MULTI | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
        setBoundInForm(dialog, t, x, y, width, height);
        return t;
    }
    
    public static void setBoundInForm(Shell dialog, Control c, int x, int y, int width, int height) {
        FormData fd = new FormData(width, height);
        fd.left = new FormAttachment(x, dialog.getSize().x, 0);
        fd.top = new FormAttachment(y, dialog.getSize().y ,0);
        c.setLayoutData(fd);
    }
    
    
    /**
     * 
     * @param width
     * @param height
     * @param title
     * @return
     */
    public static Shell createDialog(int width, int height, String title) {
        Shell dialog = new Shell(shell_, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialog.setLayout(layout);
        dialog.setSize(width, height);
        org.eclipse.swt.graphics.Rectangle diagRect = dialog.getBounds();
        org.eclipse.swt.graphics.Rectangle dispRect = display_.getBounds();
        int x = (dispRect.width-diagRect.width) / 2;
        int y = (dispRect.height-diagRect.height) / 2;
        dialog.setLocation(x, y);
        dialog.setText(title);
        
        
        return dialog;
    }
    
    /**
     * F쐬
     * @param color
     * @return
     */
    public static Color getColor(int color) {
        Display d = shell_.getDisplay();
        return d.getSystemColor(color);
    }
    

	/**
     *  ʃj[ڍ쐬 
     */
    public static void createMenuItem(Menu menu, AbstractLatteAction laction) {
        // j[ڍ쐬
        MenuItem menuItem = new MenuItem(menu, SWT.PUSH);
        menuItem.setText(laction.getTitle());      // eLXgݒ
        menuItem.setImage(laction.getImage());     // C[Wݒ
        menuItem.addSelectionListener(laction);    // ANVݒ
        
        // ԃXio^
        laction.addListener(menuItem);
    }

    /**
     *  `FbNj[ڍ쐬 
     */
    public static MenuItem createCheckMenuItem(Menu menu, AbstractLatteAction laction, boolean b) {
        // j[ڍ쐬
        MenuItem menuItem = new MenuItem(menu, SWT.CHECK);
        menuItem.setSelection(b);
        menuItem.setText(laction.getTitle());      // eLXgݒ
        menuItem.setImage(laction.getImage());     // C[Wݒ
        menuItem.addSelectionListener(laction);    // ANVݒ
        
        // ԃXio^
        laction.addListener(menuItem);
        
        return menuItem;
    }

	/**
     *  j[쐬
     */
    public static Menu createMenu(Menu menuBar, String title) {
        // j[̃^Cg쐬
        MenuItem menuItem = new MenuItem(menuBar, SWT.CASCADE);
        menuItem.setText(title);
        // j[쐬        
        Menu menu = new Menu(menuItem);
        menuItem.setMenu(menu);
        
        // j[߂
        return menu;
    }

    /**
     * N[ACe쐬
     */
    public static void createCoolItem(CoolBar coolbar, Control control) {
        // N[ACe쐬
        CoolItem coolItem = new CoolItem(coolbar, SWT.PUSH);
        coolItem.setControl(control);
        
        // Rg[N[ACẽTCYݒ
        Point pt = control.computeSize(SWT.DEFAULT, SWT.DEFAULT);
        pt = coolItem.computeSize(pt.x, pt.y);
        coolItem.setSize(pt);
    }

    /**
     * c[o[ڍ쐬
     */
    public static void createToolbarItem(ToolBar toolBar, int style, AbstractLatteAction laction, boolean selected) {
        ToolItem item = new ToolItem(toolBar, style);
        item.setImage(laction.getImage());
        item.setToolTipText(laction.getTitle());
        item.addSelectionListener(laction);
        item.setSelection(selected);

        // ԃXio^
        laction.addListener(item);
    }
    
    /**
     * c[o[ڍ쐬(not selected)
     */
    public static void createToolbarItem(ToolBar toolBar, int style, AbstractLatteAction laction) {
        GuiUtil.createToolbarItem(toolBar, style, laction, false);
    }
    
    /**
     * Image̍쐬
     * @param InputStream 
     * @return
     */
    public static Image createImage(InputStream is) {
        
		Image image = new Image(shell_.getDisplay(), is);
		ImageData mask = image.getImageData().getTransparencyMask();
		return new Image(shell_.getDisplay(), image.getImageData(), mask);
    }

	/**
	 * t@C_CAOJ
	 * @param mode SWT.OPEN or SWT.SAVE
	 * @return
	 */
	public static String openFileDialog(int mode, String[] extention) {
		FileDialog dialog = new FileDialog(shell_, mode);
		dialog.setFilterExtensions(extention);
		return dialog.open();
	}

	/**
	 * t@C_CAOJ
	 * @param mode SWT.OPEN or SWT.SAVE
	 * @return
	 */
	public static String openFileDialog(int mode) {
		return openFileDialog(mode, GuiUtil.LATTE_EXTENTION);
	}
    
    /**
     * fBNg_CAOJ
     * @return
     */
    public static String openDirectoryDialog(String msg) {
        DirectoryDialog dialog = new DirectoryDialog(shell_);
        dialog.setMessage(msg);
        return dialog.open();
    }
	
	/**
	 * _CAOJ
	 * @return v^f[^
	 */
	public static PrinterData openPrintDialog() {
		PrintDialog dialog = new PrintDialog(shell_);
		return dialog.open();
	}
	
	/**
	 * 
	 * @param shell
	 */
	public static void init(Display display, Shell shell) {
        display_ = display;
		shell_ = shell;
	}

	/**
	 * Bold Font̎擾
	 */
	public static Font getBoldFont() {
		Font f = shell_.getFont();
		FontData[] fds = f.getFontData();
		fds[0].setStyle(SWT.BOLD);
		
		return new Font(null, fds[0]);
	}

    /**
     * Italic Bold Font̎擾
     */
    public static Font getItalicBoldFont() {
        Font f = shell_.getFont();
        FontData[] fds = f.getFontData();
        fds[0].setStyle(SWT.BOLD | SWT.ITALIC);
        
        return new Font(null, fds[0]);
    }

    /**
     * Italic Font̎擾
     */
    public static Font getItalicFont() {
        Font f = shell_.getFont();
        FontData[] fds = f.getFontData();
        fds[0].setStyle(SWT.ITALIC);
        
        return new Font(null, fds[0]);
    }
    
    /**
     * I𒆂LVDiag擾
     * @return LVDiag
     */
    public static LVDiag getSelectedLVDiag() {
        return Latte.getMainForm().getDiagFolder().getSelectedDiag();
    }

	/**
	 * eɒǉ
	 * @param parent LayoutManager=XYLayoutł邱
	 * @param child
	 */
/*
	public static void addFigure(IFigure parent, IFigure child) {
		// `FbN
		if (!(parent.getLayoutManager() instanceof XYLayout)) {
			throw new IllegalArgumentException("parentLayoutManagerXYLayoutł܂");
		}
		
		org.eclipse.draw2d.geometry.Point p = child.getBounds().getLocation();
		Rectangle rect = new Rectangle(p.x, p.y, -1, -1);		
		parent.getLayoutManager().setConstraint(child, rect);
		parent.add(child);
   	}
*/	
	/**
	 * ̃rbg
	 * @param s
	 * @return
	 */
	public static int stringExtent(String s) {
		GC gc = new GC(shell_);
		int x = gc.stringExtent(s).x;
		gc.dispose();
		
		return x;
	}
}
