/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import latte.InternalLogicException;
import latte.Latte;
import latte.di.CoreSemanticModelBridge;
import latte.di.DIFactory;
import latte.di.DIPackage;
import latte.di.Diagram;
import latte.di.GraphConnector;
import latte.di.GraphEdge;
import latte.di.GraphElement;
import latte.di.GraphNode;
import latte.di.SimpleSemanticModelElement;
import latte.view.LVDiag;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Association;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Dependency;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Generalization;
import org.eclipse.uml2.Implementation;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Factory;
import org.eclipse.uml2.UML2Package;

import com.sun.javadoc.Doc;


/**
 * @version $Id: ModelUtil.java,v 1.8 2004/10/02 04:27:58 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class ModelUtil {
    /** ft@Ng */
    public static UML2Factory Uml2Factory = UML2Factory.eINSTANCE;
    public static DIFactory DiFactory = DIFactory.eINSTANCE;
    
    /** UML2r */
    private static Comparator uml2Comparator_ = new Uml2Comparator();
    /** JavaDocr */
    private static Comparator docComparator_ = new DocComparator();


    /**
     * UML2Package.xxxŒ`ꂽClassifierID擾
     */
    public static int getClassifierID(Object object) {
        if (object == null || !(object instanceof EObject)) {
            return -1;
        }
        EObject eo = (EObject)object;
        EClass eclass = eo.eClass();
        return eclass.getClassifierID();
    }

    /**
     * }ׂꏊԂ
     * @param defs e̊Element
     * @param newDef VElement
     * @return
     */
    public static int getInsertIndex(Object[] defs, Object newDef, boolean sort) {
        int i=0;
    
        switch (getClassifierID(newDef)) {
        case UML2Package.PACKAGE:
            // pbP[W̎
            Package newPkg = (Package)newDef;
                        
            for (i=0; i<defs.length; i++) {
                // NXC^[tFCXɂȂĂ܂
                if (defs[i] instanceof Class || defs[i] instanceof Interface) {
                    return i;
                }
                if (sort) {
                    // `abŒǂz
                    Package pkg = (Package)defs[i];
                    if (pkg.getName().compareTo(newPkg.getName()) > 0) {
                        return i;
                    }
                }
            }
            break;
        
        case UML2Package.INTERFACE:
            // C^[tFCX̎
            Interface newIf = (Interface)newDef;
                    
            for (i=0; i<defs.length; i++) {
                // pbP[WȂXLbv
                if (defs[i] instanceof Package) {
                    continue;
                }
                // NXɂȂĂ܂
                if (defs[i] instanceof Class) {
                    return i;
                }
                // ⃁\bhɂȂĂ܂
                if (defs[i] instanceof Property || defs[i] instanceof Operation) {
                    return i;
                }
                if (sort) {
                    // `abŒǂz
                    Interface interf = (Interface)defs[i];
                    if (interf.getName().compareTo(newIf.getName()) > 0) {
                        return i;
                    }
                }
            }
            break;
    
        case UML2Package.CLASS:
            // NX̎
            Class newClass = (Class)newDef;
                    
            for (i=0; i<defs.length; i++) {
                // pbP[WC^[tFCXȂXLbv
                if (defs[i] instanceof Package || defs[i] instanceof Interface) {
                    continue;
                }
                // ⃁\bh֘AɂȂĂ܂
                if (defs[i] instanceof Property || defs[i] instanceof Operation || defs[i] instanceof Association) {
                    return i;
                }
                if (sort) {
                    // `abŒǂz
                    Class c = (Class)defs[i];
                    if (c.getName().compareTo(newClass.getName()) > 0) {
                        return i;
                    }
                }
            }
            break;
    
        case UML2Package.PROPERTY:
            // ̎
            Property newAttr = (Property)newDef;
                        
            for (i=0; i<defs.length; i++) {
                // NXC^[tFCXȂXLbv
                if (defs[i] instanceof Class || defs[i] instanceof Interface) {
                    continue;
                }
                // \bhɂȂĂ܂
                if (defs[i] instanceof Operation) {
                    return i;
                }
                if (sort) {
                    // `abŒǂz
                    Property attr = (Property)defs[i];
                    if (attr.getName().compareTo(newAttr.getName()) > 0) {
                        return i;
                    }
                }
            }
            break;
    
        case UML2Package.OPERATION:
            // \bh̎
            Operation newMethod = (Operation)newDef;
                        
            for (i=0; i<defs.length; i++) {
                // NXC^[tFCX⑮ȂXLbv
                if (defs[i] instanceof Class || defs[i] instanceof Interface || defs[i] instanceof Property) {
                    continue;
                }
                if (sort) {
                    // `abŒǂz
                    Operation method = (Operation)defs[i];
                    if (method.getName().compareTo(newMethod.getName()) > 0) {
                        return i;
                    }
                }
            }
            break;
            
        case UML2Package.ASSOCIATION:
            for (i=0; i<defs.length; i++) {
            }
            break;
    
        case DIPackage.DIAGRAM:
            // }Ȃ
            Diagram newDiag = (Diagram)newDef;
        
            String newDiagType = ModelUtil.getDiagType(newDiag);
            if (newDiagType.equals(LVDiag.TYPE_CLASS_DIAG)) {
                // NX}
                for (i=0; i<defs.length; i++) {
                    Diagram diag = (Diagram)defs[i];
                    String diagType = ModelUtil.getDiagType(diag);
                    // NX}ȊOɂȂĂ܂
                    if (!diagType.equals(LVDiag.TYPE_CLASS_DIAG)) {
                        return i;
                    }
                    if (sort) {                    
                        // `abŒǂz
                        if (diag.getName().compareTo(newDiag.getName()) > 0) {
                            return i;
                        }
                    }
                }
            } else if (newDiagType.equals(LVDiag.TYPE_SEQ_DIAG)) {
                // V[PX}
                for (i=0; i<defs.length; i++) {
                    Diagram diag = (Diagram)defs[i];
                    String diagType = ModelUtil.getDiagType(diag);
                    // NX}ȂXLbv
                    if (!diagType.equals(LVDiag.TYPE_CLASS_DIAG)) {
                        continue;
                    }
                    if (sort) {
                        // `abŒǂz
                        if (diag.getName().compareTo(newDiag.getName()) > 0) {
                            return i;
                        }
                    }
                }
            }
            break;   
            
        default:
            throw new InternalLogicException("zO̐VIuWFNg");     
        }
        return i;
    }


    /**
     * _擾
     * @param diagramLink
     * @param offset
     * @return
     */
    public static Point getLocation(GraphElement graphElement, Point offset) {
        int x = graphElement.getPosition().getX();
        int y = graphElement.getPosition().getY();
        Point p = new Point(x, y);
        p = p.translate(offset);
        return p;
    }
    
   
    /**
     * t@CۑKv
     */
    public static void setNeedSaving() {
        Latte.getLatteData().setNeedSaving();
    }
    
    /**
     * }^Cv̎擾
     * @param diag
     * @return
     */
    public static String getDiagType(Diagram diag) {
        SimpleSemanticModelElement element = (SimpleSemanticModelElement)diag.getNamespace();
        return element.getTypeInfo();
    }
    
    /**
     * GraphElementElemnet擾
     * @param graphElement
     * @return
     */
    public static Element getElement(GraphElement graphElement) {
        CoreSemanticModelBridge b = (CoreSemanticModelBridge)graphElement.getSemanticModel();
        return b.getElement();
    }
    
    /**
     * SĂ̐}elementwGraphNodeGraphEdge폜
     * 
     * @param element
     */
    public static void removeGraphNode(Element element) {
        
        // ׂĂ̐}[v
        Iterator i = Latte.getLatteData().getDiagrams().getContained().iterator();
        while (i.hasNext()) {
            Diagram diagram = (Diagram)i.next();
            removeGraphNodeFromDiagram(diagram, element);
        }
    }

    /**
     * }removeElementwGraphNodeGraphEdge폜
     * 
     * @param diagram
     * @param removeElement
     */
    public static void removeGraphNodeFromDiagram(Diagram diagram, Element removeElement) {
        // ׂĂGraphElement[v
        ArrayList list = new ArrayList();
        list.addAll(diagram.getContained());
        Iterator i = list.iterator();
        while (i.hasNext()) {
            // elementwGraphNode폜
            GraphElement graphElement = (GraphElement)i.next();
            Element element = ModelUtil.getElement(graphElement);
            
            // elementɊ֌WGraphEdge폜
            switch (ModelUtil.getClassifierID(element)) {
            case UML2Package.CLASS:
            case UML2Package.INTERFACE:
                // graphNode폜
                if (removeElement == element) {
                    diagram.getContained().remove(graphElement);
                }
                break;

            case UML2Package.COMMENT:
                // graphNode폜
                if (removeElement == element) {
                    diagram.getContained().remove(graphElement);
                }
                // graphEdge폜
                if (ModelUtil.getClassifierID(graphElement)==DIPackage.GRAPH_EDGE) {
                    GraphEdge graphEdge = (GraphEdge)graphElement;
                    for (Iterator j = graphEdge.getAnchor().iterator(); j.hasNext(); ) {
                        GraphConnector graphConnector = (GraphConnector)j.next();
                        Element e = ModelUtil.getElement(graphConnector.getGraphElement());
                        if (e == removeElement) {
                            ModelUtil.removeGraphEdgeFromDiagram(diagram, graphEdge);
                            break;
                        }
                    }
                }
                break;
            
            case UML2Package.ASSOCIATION:
                Association ass = (Association)element;
                for (Iterator j=ass.getMemberEnds().iterator(); j.hasNext(); ) {
                    Property p = (Property)j.next();
                    if (p.getType() == removeElement) {
                        ModelUtil.removeGraphEdgeFromDiagram(diagram, (GraphEdge)graphElement);
                    }
                }
                break;
                
            case UML2Package.DEPENDENCY:
                Dependency dep = (Dependency)element;
                if (dep.getSuppliers().contains(removeElement) || dep.getClients().contains(removeElement)) {
                    ModelUtil.removeGraphEdgeFromDiagram(diagram, (GraphEdge)graphElement);
                }
                break;

            case UML2Package.GENERALIZATION:
                Generalization gen = (Generalization)element;
                if (gen.getGeneral()==removeElement || gen.getSpecific()==removeElement) {
                    ModelUtil.removeGraphEdgeFromDiagram(diagram, (GraphEdge)graphElement);
                }
                break;
            
            case UML2Package.IMPLEMENTATION:
                Implementation imp = (Implementation)element;
                if (imp.getImplementingClassifier()==removeElement || imp.getContract()==removeElement) {
                    ModelUtil.removeGraphEdgeFromDiagram(diagram, (GraphEdge)graphElement);
                }
                break;
            }
        }
    }
    
    /**
     * }GraphEdge̍폜
     * 
     * @param graphEdge
     */
    public static void removeGraphEdgeFromDiagram(Diagram diagram, GraphEdge graphEdge) {
        graphEdge.getAnchor().clear(); // anchorageɃNA
        
        diagram.getContained().remove(graphEdge);
    }

    /**
     * GraphConnectorAssociationɑΉProperty擾
     * @param graphConnector
     * @return
     */
    public static Property getProperty(Association ass, GraphConnector graphConnector) {
        GraphNode graphNode = (GraphNode)graphConnector.getGraphElement();
        CoreSemanticModelBridge b = (CoreSemanticModelBridge)graphNode.getSemanticModel();
        Element element = b.getElement();

        // Ce[^擾
        Iterator i = null;
        switch (ModelUtil.getClassifierID(element)) {
        case UML2Package.CLASS:
            Class c = (Class)element;
            i = c.getOwnedAttributes().iterator();
            break;

        case UML2Package.INTERFACE:
            Interface in = (Interface)element;
            i = in.getOwnedAttributes().iterator();
            break;
        }

        // S`FbN
        Property p = null;
        while (i.hasNext()) {
            p = (Property)i.next();
            if (p.getAssociation() == ass) {
                return p;
            }
        }
        
        return null;
    }

    /**
     * GraphEdgeFromProperty(memberEnd[]index=0)擾
     * 
     * @param graphEdge (associationwgraphEdge)
     * @return
     */
    public static Property getFromProperty(GraphEdge graphEdge) {
        Element element = ModelUtil.getElement(graphEdge);
        
        // check
        switch (ModelUtil.getClassifierID(element)) {
        case UML2Package.ASSOCIATION:
            break;
        
        default:
            throw new InternalLogicException("associationł܂");
        
        }
        
        // 又
        Association association = (Association)element;
        Property p = (Property)association.getMemberEnds().get(0);
        return p;
    }

    /**
     * GraphEdgeFromProperty(memberEnd[]index=1)擾
     * 
     * @param graphEdge (associationwgraphEdge)
     * @return
     */
    public static Property getToProperty(GraphEdge graphEdge) {
        Element element = ModelUtil.getElement(graphEdge);
        
        // check
        switch (ModelUtil.getClassifierID(element)) {
        case UML2Package.ASSOCIATION:
            break;
        
        default:
            throw new InternalLogicException("associationł܂");
        
        }
        
        // 又
        Association association = (Association)element;
        Property p = (Property)association.getMemberEnds().get(1);
        return p;
    }

    /**
     * UML2frW^[
     */
    public static abstract class ModelVisitor {
        public void visit(Element element) {
            // operations
            operation(element);
            
            // visit
            List list = new ArrayList();
            List interfaceList = new ArrayList(); // C^[tFCX
            List classList = new ArrayList(); // NX
            
            switch (ModelUtil.getClassifierID(element)) {
            case UML2Package.MODEL:
                Model m = (Model)element;
                list = m.getOwnedMembers();
                break;
            
            case UML2Package.PACKAGE:
                Package p = (Package)element;
                list = p.getOwnedMembers();
                break;
            
            case UML2Package.CLASS:
                // NX
                Class c = (Class)element;

                // NVt@Ct@[擾
                for (Iterator i=c.getNestedClassifiers().iterator(); i.hasNext(); ) {
                    Classifier nestedClassifier = (Classifier)i.next();
                    if (nestedClassifier instanceof Interface) {
                        interfaceList.add(nestedClassifier);
                    } else {
                        classList.add(nestedClassifier);
                    }
                }
                // C^[tFCX
                list.addAll(interfaceList);
                // NX
                list.addAll(classList);
                // 
                list.addAll(c.getOwnedAttributes());
                // \bh
                list.addAll(c.getOwnedOperations());
                // ֌W
                list.addAll(c.getImplementations());
                // ĉ֌W
                list.addAll(c.getGeneralizations());
                break;
            
            case UML2Package.INTERFACE:
                // C^[tFCX
                Interface intf = (Interface)element;

                // NVt@Ct@[擾
                for (Iterator i = intf.getNestedClassifiers().iterator(); i.hasNext(); ) {
                    Classifier nestedClassifier = (Classifier)i.next();
                    if (nestedClassifier instanceof Interface) {
                        interfaceList.add(nestedClassifier);
                    } else {
                        classList.add(nestedClassifier);
                    }
                }
                // C^[tFCX
                list.addAll(interfaceList);
                // NX
                list.addAll(classList);
                // 
                list.addAll(intf.getOwnedAttributes());
                // \bh
                list.addAll(intf.getOwnedOperations());
                // ĉ֌W
                list.addAll(intf.getGeneralizations());                
                break;

            case UML2Package.PROPERTY:
            case UML2Package.OPERATION:
            case UML2Package.ASSOCIATION:
            case UML2Package.DEPENDENCY:
            case UML2Package.GENERALIZATION:
            case UML2Package.IMPLEMENTATION:        
                break;
            
            default:
                break;
            }
            
            // ċAIvisit
            for (Iterator i=list.iterator(); i.hasNext(); ) {
                visit((Element)i.next());
            }
        }

        public abstract void operation(Element e);
    }
    

    
    public static String getTypeName(Type t, boolean withNamespace) {
        String name = null;
        
        if (t != null) {
            switch (ModelUtil.getClassifierID(t)) {
            case UML2Package.ENUMERATION:
                // modelɖ
                String n = t.getName();
                n = n.substring(n.lastIndexOf(".")+1);
                name = "("+n+")";
                break;
            default:
                // modelɂ                    
                name = t.getName();
                break;
            }
        }
        return name;
    }
    
    public static boolean isExistAttributeGraphNode(GraphNode classGraphNode) {
        if (classGraphNode.getContained().size() < 1) {
            return false;
        }
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(0);
        return attributeGraphNode==null ? false : true;
    }

    public static boolean isExistMethodGraphNode(GraphNode classGraphNode) {
        if (classGraphNode.getContained().size() < 2) {
            return false;
        }
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(1);
        return attributeGraphNode==null ? false : true;
    }

    public static GraphNode getAttributeGraphNode(GraphNode classGraphNode) {
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(0);
        return attributeGraphNode;
    }

    public static GraphNode getMethodGraphNode(GraphNode classGraphNode) {
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(1);
        return attributeGraphNode;
    }
    
    public static boolean isAttributeVisible(GraphNode classGraphNode) {
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(0);
        return attributeGraphNode.isVisible();
    }

    public static boolean isMethodVisible(GraphNode classGraphNode) {
        GraphNode methodGraphNode = (GraphNode)classGraphNode.getContained().get(1);
        return methodGraphNode.isVisible();
    }

    public static void setAttributeVisible(GraphNode classGraphNode, boolean b) {
        GraphNode attributeGraphNode = (GraphNode)classGraphNode.getContained().get(0);
        attributeGraphNode.setVisible(b);
    }

    public static void setMethodVisible(GraphNode classGraphNode, boolean b) {
        GraphNode methodGraphNode = (GraphNode)classGraphNode.getContained().get(1);
        methodGraphNode.setVisible(b);
    }

    
    
    /**
     * UML2r̎擾
     * @return
     */
    public static Comparator getUml2Comparator() {
        return uml2Comparator_;
    }
    
    /**
     * UML2r
     */
    static class Uml2Comparator implements Comparator {
        /**
         * r
         * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
         */
        public int compare(Object o1, Object o2) {
            NamedElement e1 = (NamedElement)o1;
            NamedElement e2 = (NamedElement)o2;
            
            return e1.getName().compareTo(e2.getName());
        }
    }
    
    /**
     * JavaDocr̎擾
     * @return
     */
    public static Comparator getDocComparator() {
        return docComparator_;
    }
    
    public static GraphConnector getFromGraphConnector(GraphEdge graphEdge) {
        return (GraphConnector)graphEdge.getAnchor().get(0);
    }
    
    public static GraphConnector getToGraphConnector(GraphEdge graphEdge) {
        return (GraphConnector)graphEdge.getAnchor().get(1);
    }
    

    /**
     * GraphEdgeĂ邩H
     * 
     * @param graphEdge
     * @return
     */
    public static boolean isNavigable(GraphEdge graphEdge) {
        Property property = ModelUtil.getFromProperty(graphEdge);
        
        return property.isNavigable();
    }
    
    /**
     * GraphEdgẽAOQ[Vނ擾
     * 
     * @param graphEdge
     * @return
     */
    public static AggregationKind getAggregationKind(GraphEdge graphEdge) {
        Property property = ModelUtil.getFromProperty(graphEdge);
        if (property != null) {
            return property.getAggregation();
        }
        // ΉPropertynull
        return null;
    }
    
    /**
     * JavaDocr
     * 
     * Docr
     */
    static class DocComparator implements Comparator {
        /**
         * r
         * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
         */
        public int compare(Object o1, Object o2) {
            Doc d1 = (Doc)o1;
            Doc d2 = (Doc)o2;
            
            return d1.name().compareTo(d2.name());
        }
    }


}
