/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/


package latte.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

/**
 * bZ[W[eBeB
 * 
 * @version $Id: MsgUtil.java,v 1.3 2004/10/02 04:27:58 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class MsgUtil {
    private static Display display_ = null;
    
	/** shell */
	private static Shell shell_ = null;
	
	/**
	 * 
	 * 
	 * ꂸshowXxxxĂ΂ƃG[
	 * 
	 * @param shell
	 */
	public static void init(Display display, Shell shell) {
        display_ = display;
		shell_ = shell;
	}

    
    /**
     * bZ[W\
     */
    public static void showMsg(String msg) {
        if (msg == null) {
            LogUtil.writeln("showMsg()null̂ߕ\łȂ");
            msg = "G[Bڍׂ̓OQƁB";
        }
        
        MessageBox mesBox = new MessageBox(shell_);
        mesBox.setMessage(msg);
        mesBox.setText("latte");
        mesBox.open();                
    }

    /**
     * bZ[W\
     */
    public static void showMsgAsync(final String msg) {
        display_.syncExec(new Runnable() {
            public void run() {
                MessageBox mesBox = new MessageBox(shell_);
                mesBox.setMessage(msg);
                mesBox.setText("latte");
                mesBox.open();                
            }
        });
    }

    /**
     * bZ[W\(YES/NO)
     */
    public static int showYesNoMsg(String msg) {
        MessageBox mesBox = new MessageBox(shell_, SWT.YES|SWT.NO);
        mesBox.setMessage(msg);
        mesBox.setText("latte");
        return mesBox.open();
    }

    /**
     * bZ[W\(YES/NO/CANCEL)
     */
    public static int showYesNoCancelMsg(String msg) {
        MessageBox mesBox = new MessageBox(shell_, SWT.YES|SWT.NO|SWT.CANCEL);
        mesBox.setMessage(msg);
        mesBox.setText("latte");
        return mesBox.open();
    }
}
