/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Enumeration;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Parameter;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.TypedElement;
import org.eclipse.uml2.UML2Package;

import latte.Latte;
import latte.action.mm.AllManip;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;

/**
 * o[XDoclet
 * 
 * o[XɃXiƂLVTreeǉB
 * FileOpen͓ǂݍ񂾌AꊇăXiǉł邪A
 * o[X͊fɒǉȂ̂ŁAꊇXio^łȂB
 * 
 * @version $Id: ReverseDoclet.java,v 1.7 2004/10/02 04:27:58 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class ReverseDoclet {
    /** model -> ^  ex. UML2Factory.createClass()ō쐬ꂽObj -> "latte.Latte" */
    private static HashMap element2QualifiedNameMapping_ = null;

    public static boolean start(RootDoc root) {
        EObject parent = Latte.getLatteData().getModel();
        element2QualifiedNameMapping_ = new HashMap();
        
        // pbP[WŃ[v
        PackageDoc[] packageDocs = root.specifiedPackages();
        Arrays.sort(packageDocs, ModelUtil.getDocComparator());
        for (int i=0; i<packageDocs.length; i++) {

            // pbP[Wǉ
            EObject pkg = addPackage(parent, packageDocs[i]);
            // NXDOC擾
            ClassDoc[] classDocs = packageDocs[i].allClasses();
            Arrays.sort(classDocs, ModelUtil.getDocComparator());
            // C^[tFCXǉ
            for (int j=0; j<classDocs.length; j++) {                
                if (!classDocs[j].isInterface()) {
                    continue;
                }
                // NXłȂΒǉ
                if (classDocs[j].containingClass()==null) {
                    if (classDocs[j].isInterface()) {
                        addInterface(pkg, classDocs[j]);                        
                    } else {
                        addClass(pkg, classDocs[j]);
                    }
                }
            }
            // NXǉ
            for (int j=0; j<classDocs.length; j++) {             
                if (!classDocs[j].isClass()) {
                    continue;
                }
                // NXłȂΒǉ
                if (classDocs[j].containingClass()==null) {
                    if (classDocs[j].isInterface()) {
                        addInterface(pkg, classDocs[j]);                        
                    } else {
                        addClass(pkg, classDocs[j]);
                    }
                }
            }
        }
        
        // PropertyOperatioň^ݒ肷 setType()
        // |Wgɑ݂ȂEnumlateLiteral쐬AsetName
        setType();
        
        element2QualifiedNameMapping_ = null;

        return true;
    }
    
    /**
     * pbP[Wǉ
     */
    private static EObject addPackage(EObject parent, PackageDoc childPackageDoc) {
        // 쐬
        EObject eobject = AllManip.PACKAGE.createDef(childPackageDoc);
        // IuU[oǉ
        eobject.eAdapters().add(Latte.getMainForm().getTree());
        // eɒǉ
        AllManip.PACKAGE.addDef(parent, eobject);
        
        return eobject;
    }
    
    /**
     * NXǉ
     */
    private static void addClass(EObject parent, ClassDoc childClassDoc) {
        // 쐬
        EObject eobject = AllManip.CLASS.createDef(childClassDoc);
        // IuU[oǉ
        eobject.eAdapters().add(Latte.getMainForm().getTree());
        // eɒǉ
        AllManip.CLASS.addDef(parent, eobject);
        
        // ^L[objecto^
        String type = childClassDoc.qualifiedName();
        Latte.getLatteData().addElementByQualifiedName(type, (Element)eobject);

        // ͉Ȃ
        ClassDoc superclass = childClassDoc.superclass();        // X[p[NX
        ClassDoc[] interfaces = childClassDoc.interfaces();      // C^[tFCX


        // NX擾
        ClassDoc[] innerClassDocs = childClassDoc.innerClasses();  // NX
        Arrays.sort(innerClassDocs, ModelUtil.getDocComparator());
        // C^[tFCXǉ
        for (int i=0; i<innerClassDocs.length; i++) {
            if (innerClassDocs[i].isInterface()) {
                addInterface(eobject, innerClassDocs[i]);
            }
        }
        // NXǉ
        for (int i=0; i<innerClassDocs.length; i++) {
            if (innerClassDocs[i].isClass()) {
                addClass(eobject, innerClassDocs[i]);
            }
        }
        
        // ǉ
        FieldDoc[] fieldDocs = childClassDoc.fields();
        Arrays.sort(fieldDocs, ModelUtil.getDocComparator());
        for (int i=0; i<fieldDocs.length; i++) {
            addAttribute(eobject, fieldDocs[i]);
        }

        // RXgN^
        ConstructorDoc[] constructorDoc = childClassDoc.constructors();
        Arrays.sort(constructorDoc, ModelUtil.getDocComparator());
        for (int i=0; i<constructorDoc.length; i++) {
            addConstructor(eobject, constructorDoc[i]);
        }
        
        // \bhǉ
        MethodDoc[] methodDocs = childClassDoc.methods();
        Arrays.sort(methodDocs, ModelUtil.getDocComparator());
        for (int i=0; i<methodDocs.length; i++) {
            addMethod(eobject, methodDocs[i]);
        }
    }
    
    /**
     * C^[tFCXǉ
     */
    private static void addInterface(EObject parent, ClassDoc childClassDoc) {
        // 쐬
        EObject eobject = AllManip.INTERFACE.createDef(childClassDoc);
        // IuU[oǉ
        eobject.eAdapters().add(Latte.getMainForm().getTree());
        // eɒǉ
        AllManip.INTERFACE.addDef(parent, eobject);
        
        // ^L[objecto^
        String type = childClassDoc.qualifiedName();
        Latte.getLatteData().addElementByQualifiedName(type, (Element)eobject);

        // ͉Ȃ
        ClassDoc superclass = childClassDoc.superclass();        // X[p[NX
        ClassDoc[] interfaces = childClassDoc.interfaces();      // C^[tFCX


        // NX擾
        ClassDoc[] innerClassDocs = childClassDoc.innerClasses();  // NX
        Arrays.sort(innerClassDocs, ModelUtil.getDocComparator());
        // C^[tFCXǉ
        for (int i=0; i<innerClassDocs.length; i++) {
            if (innerClassDocs[i].isInterface()) {
                addInterface(eobject, innerClassDocs[i]);
            }
        }
        // NXǉ
        for (int i=0; i<innerClassDocs.length; i++) {
            if (innerClassDocs[i].isClass()) {
                addClass(eobject, innerClassDocs[i]);
            }
        }
        
        // ǉ
        FieldDoc[] fieldDocs = childClassDoc.fields();
        Arrays.sort(fieldDocs, ModelUtil.getDocComparator());
        for (int i=0; i<fieldDocs.length; i++) {
            addAttribute(eobject, fieldDocs[i]);
        }
        
        // \bhǉ
        MethodDoc[] methodDocs = childClassDoc.methods();
        Arrays.sort(methodDocs, ModelUtil.getDocComparator());
        for (int i=0; i<methodDocs.length; i++) {
            addMethod(eobject, methodDocs[i]);
        }
    }

    /**
     * ǉ
     */
    private static void addAttribute(EObject parent, FieldDoc childFieldDoc) {
        // 쐬
        EObject eobject = AllManip.ATTRIBUTE.createDef(childFieldDoc);
        // IuU[oǉ
        eobject.eAdapters().add(Latte.getMainForm().getTree());
        // eɒǉ
        AllManip.ATTRIBUTE.addDef(parent, eobject);
        
        
        String type = childFieldDoc.type().qualifiedTypeName();
        element2QualifiedNameMapping_.put(eobject, type);
    }

    /**
     * RXgN^ǉ
     */
    private static void addConstructor(EObject parent, ConstructorDoc childConstructorDoc) {
        // 쐬
        EObject eobject = AllManip.METHOD.createDef(childConstructorDoc);
        // IuU[oǉ
        eobject.eAdapters().add(Latte.getMainForm().getTree());
        // eɒǉ
        AllManip.METHOD.addDef(parent, eobject);
    }

    /**
     * \bhǉ
     */
    private static void addMethod(EObject parent, MethodDoc childMethodDoc) {
        // 쐬
        EObject eobject = AllManip.METHOD.createDef(childMethodDoc);
        // IuU[oǉ
        eobject.eAdapters().add(Latte.getMainForm().getTree());
        // eɒǉ
        AllManip.METHOD.addDef(parent, eobject);

        String type = childMethodDoc.returnType().qualifiedTypeName();
        element2QualifiedNameMapping_.put(eobject, type);
    }
    
    /**
     * ^̐ݒ
     * ΏہFPropertyOperation
     */
    private static void setType() {
        // ^ݒ
        Iterator i = element2QualifiedNameMapping_.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = (Map.Entry)i.next();
            TypedElement te = (TypedElement)me.getKey();
            String typename = (String)me.getValue();
            // ^
            Type type = (Type)Latte.getLatteData().lookupElementByQualifiedName(typename);
            
            if (type != null) {
                // typefɂ(v~eBu܂)
                switch (ModelUtil.getClassifierID(te)) {
                case UML2Package.PROPERTY:
                    te.setType(type);
                    break;
                case UML2Package.OPERATION:
                    Operation o = (Operation)te;
                    Parameter p = o.createReturnResult(UML2Package.eINSTANCE.getParameter());
                    p.setType(type);
                    break;
                }
            } else {
                // typefɖ

                // ǉ
                Enumeration e = Latte.getLatteData().createAndAddEnumerationType(typename);
                
                // 
                switch (ModelUtil.getClassifierID(te)) {
                case UML2Package.PROPERTY:
                    te.setType(e);
                    break;
                case UML2Package.OPERATION:
                    Operation o = (Operation)te;
                    Parameter p = o.createReturnResult(UML2Package.eINSTANCE.getParameter());
                    p.setType(e);
                    break;            
                }
            }
        }
    }
}


