/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/


package latte.view;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

/**
 * ChopAnchor
 * 
 * @version $Id: ChopAnchor.java,v 1.2 2004/09/04 16:05:41 ohnuki Exp $
 * @author $Author: ohnuki $
 */
class ChopAnchor extends AbstractConnectionAnchor {
    public ChopAnchor(IFigure owner) {
        super(owner);
    }

    /**
     * Gets a Rectangle from {@link #getBox()} and returns the Point where a line from the
     * center of the Rectangle to the Point <i>reference</i> intersects the Rectangle.
     * 
     * @param reference The reference point
     * @return The anchor location
     */
    public Point getLocation(Point reference) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(getBox());
        r.translate(-1, -1);
        r.resize(1, 1);

        getOwner().translateToAbsolute(r);
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
    
        return new Point((int)centerX, (int)centerY);
    }

    /**
     * Returns the bounds of this ChopboxAnchor's owner.  Subclasses can override this method
     * to adjust the box the anchor can be placed on.  For instance, the owner figure may have
     * a drop shadow that should not be included in the box. 
     *  
     * @return The bounds of this ChopboxAnchor's owner
     * @since 2.0
     */
    protected Rectangle getBox() {
        return getOwner().getBounds();
    }

    /**
     * Returns the anchor's reference point. In the case of the ChopboxAnchor, this is the
     * center of the anchor's owner.
     * 
     * @return The reference point
     */
    public Point getReferencePoint() {
        if (getOwner() == null)
            return null;
        else {
            Point ref = getBox().getCenter();
            getOwner().translateToAbsolute(ref);
            return ref;
        }
    }

}
