/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import latte.util.LogUtil;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Interface;


/**
 * hbO\[XL
 * 
 * @version $Id: DragSourceEnabler.java,v 1.2 2004/09/04 16:05:40 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class DragSourceEnabler implements DragSourceListener {
    LVTree tree_ = null;
    /** hbOœ]f[^^Cv */
    private static Transfer[] TYPE = new Transfer[]{TextTransfer.getInstance()};
    /**  */
    private static int OPERATION = DND.DROP_MOVE | DND.DROP_COPY | DND.DROP_LINK;
    
    /**
     * RXgN^
     * @param tree
     */
    public DragSourceEnabler(LVTree tree) {
        this.tree_ = tree;
        DragSource source = new DragSource(tree_.getTree(), OPERATION);
        source.setTransfer(TYPE);
        source.addDragListener(this);
    }

    /**
     * hbOJn
     */
    public void dragStart(DragSourceEvent event) {
        LogUtil.writeln("DragSource.dragStart() ");
        EObject draggedModel = tree_.getSelectedModels();
        // DND\ƕs\ɕ
        if (draggedModel instanceof Class || draggedModel instanceof Interface) {
            event.doit = true;
        } else {
            event.doit = false;
        }
    }

    /**
     * hbOf[^ݒ
     */
    public void dragSetData(DragSourceEvent event) {
        event.data = "dummy";
    }
    
    /**
     * hbOI
     */
    public void dragFinished(DragSourceEvent event) {
        LogUtil.writeln("DragSource.dragFinished() "+event);
    }
}
