/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import latte.InternalLogicException;
import latte.Latte;
import latte.di.CoreSemanticModelBridge;
import latte.di.GraphNode;
import latte.di.Point;
import latte.util.DebugUtil;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.SimpleTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.Comment;



/**
 * NX}̃RgFigure
 * 
 * FwiFARec쐬
 * 
 * @version $Id: LVClassDiagCommentFigure.java,v 1.4 2004/09/22 18:05:22 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class LVClassDiagCommentFigure extends LVClassDiagFigure  {
	TextFlow textFlow_ = new TextFlow();

    /**
     * RgFigureRXgN^
     */
	protected LVClassDiagCommentFigure(LVClassDiag parent, GraphNode graphNode) {
        super(parent, graphNode);
        
        // ܂Ԃ
        setBorder(BORDER);

		// Rec\쐬
        textFlow_.setLayoutManager(new SimpleTextLayout(textFlow_));
        BlockFlow flow = new BlockFlow();
        FlowPage page = new FlowPage();
        flow.add(textFlow_);
		page.add(flow);
		add(page);
        
        // Rec쐬
        createFigureContents();
	}
	
	
	/**
	 * Rec쐬
	 */
    public void createFigureContents() {
        // Rg`擾
        CoreSemanticModelBridge b = (CoreSemanticModelBridge)graphNode_.getSemanticModel();
        Comment comment = (Comment)b.getElement();

        textFlow_.setText(comment.getBody());
	}
    
    /**
     * ύXʒm
     * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
     */
    public void notifyChanged(Notification notification) {
        // eɓ]
        super.notifyChanged(notification);
        
        if (Latte.TRACE_EVENT) {
            System.out.print(DebugUtil.getEventId(this, notification) + " ");
            System.out.println("LVClassDiagCommentFigure notifyChanged:"+notification);
        }
      
        Object newValue = notification.getNewValue();
        if (newValue instanceof Point) {
            if (Latte.TRACE_EVENT) {
                System.out.println("LVClassDiagCommentFigure Ȃ");
            }
            return;
        }
        
        // CxgɂďU蕪
        switch (notification.getEventType()) {
        case Notification.SET:       // Rg̕ύX 24
            createFigureContents();
            setConstraint();
            setValid(false);
    //      invalidate();
            break;
        
        case Notification.ADD:             // ǉ
        case Notification.REMOVE:          // 폜
        case Notification.REMOVING_ADAPTER:// A_v^폜
            if (Latte.TRACE_EVENT) {
                System.out.println("LVClassDiagCommentFigureŏȂCxgȂ̂Ŗ߂");
            }
            break;
                
        default:
            throw new InternalLogicException("T|[g̕ύXʒm");
        }
    }
        
    /**
     * wiF̎擾
     */
    public Color getBackgroundColor() {
        return LVConst.diagColor_;
    }
    
	
    /**
     * ܂肩{[_[
     */
	static final Border BORDER = new CompoundBorder(
		new FoldedPageBorder(),
		new MarginBorder(2,2,2,2));

	static class FoldedPageBorder extends AbstractBorder {
		static final Color corner1 = new Color(null, 200, 208, 223);
		static final Color corner2 = new Color(null, 160, 172, 200);
		static final Color blue = new Color(null, 152,168,200);
		static final Color shadow = new Color(null, 202,202,202);
		static final int CORNER_SIZE = 6;
		
		static final PointList CORNER_ERASE;
		static final PointList CORNER_PAINT;
		static {
			CORNER_ERASE = new PointList(3);
			CORNER_ERASE.addPoint(1,0);
			CORNER_ERASE.addPoint(1, CORNER_SIZE + 1);
			CORNER_ERASE.addPoint(-CORNER_SIZE, 0);
			CORNER_PAINT = new PointList(3);
			CORNER_PAINT.addPoint(-CORNER_SIZE, 0);
			CORNER_PAINT.addPoint(0, CORNER_SIZE);
			CORNER_PAINT.addPoint(-CORNER_SIZE, CORNER_SIZE);
		}
	
		static final Insets insets = new Insets(CORNER_SIZE,2,4,4);

		public Insets getInsets(IFigure figure) {
			return insets;
		}

		public void paint(IFigure figure, Graphics g, Insets insets) {
			Rectangle r = getPaintRectangle(figure, insets);

			g.setLineWidth(4);
			r.resize(-2, -2);
			g.setForegroundColor(shadow);
			g.drawLine(r.x+3, r.bottom(), r.right() - 1, r.bottom());
			g.drawLine(r.right(), r.y + 3 + CORNER_SIZE, r.right(), r.bottom() - 1);
		
			g.restoreState();
			r.resize(-1, -1);
			g.drawRectangle(r);
			g.setForegroundColor(blue);
			g.drawRectangle(r.x + 1, r.y+1, r.width - 2, r.height - 2);
			g.translate(r.getTopRight());
			g.fillPolygon(CORNER_ERASE);
			g.setBackgroundColor(corner1);
			g.fillPolygon(CORNER_PAINT);
			g.setForegroundColor(figure.getForegroundColor());
			g.drawPolygon(CORNER_PAINT);
			g.restoreState();
			g.setForegroundColor(corner2);
			g.drawLine(
				r.right() - CORNER_SIZE + 1,
				r.y + 2,
				r.right() - 2,
				r.y + CORNER_SIZE-1);
		}
	}	
}

