/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import latte.InternalLogicException;
import latte.Latte;
import latte.action.AllAction;
import latte.di.GraphNode;
import latte.util.ModelUtil;


import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.uml2.UML2Package;

/**
 * 
 * NX}̒ۃtBMBA
 * @F}EXXi
 * 
 * 
 * @version $Id: LVClassDiagFigure.java,v 1.5 2004/02/19 18:23:39 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public abstract class LVClassDiagFigure extends LVDiagFigure {

    /**
     * RXgN^
     */
    public LVClassDiagFigure(LVClassDiag lvClassDiag, GraphNode graphNode) {
        super(lvClassDiag, graphNode);

		// CAEg}l[Wݒ
		setLayoutManager(new ToolbarLayout());

        // Xi[o^
        addMouseListener(new ClassDiagFigureMouseListener(this));
        addMouseMotionListener(new ClassDiagFigureMouseMotionListener(this));
    }

    /**
     * \bh\Figure
     */
	protected static class CompartmentFigure extends Figure {

	  public CompartmentFigure() {
		ToolbarLayout layout = new ToolbarLayout();
		layout.setMinorAlignment(ToolbarLayout.ALIGN_TOPLEFT);
		layout.setStretchMinorAxis(false);
		layout.setSpacing(1); // ԁA\bhԂ̊Ԋu
		setLayoutManager(layout);
		setBorder(new CompartmentFigureBorder());
	  }
	  
	  /**
	   * CompartmentFigure{[_̒`
	   */
	  public class CompartmentFigureBorder extends AbstractBorder {
		public Insets getInsets(IFigure figure) {
		  return new Insets(1,0,1,0);
		}
		public void paint(IFigure figure, Graphics graphics, Insets insets) {
		  graphics.drawLine(getPaintRectangle(figure, insets).getTopLeft(),
							tempRect.getTopRight());
		}
	  }
	}



    /**
     * }EXXi[
     */
    class ClassDiagFigureMouseListener implements MouseListener {
        /** Xi[Ώ */
        private LVClassDiagFigure figure_ = null;
        
        /**
         * RXgN^
         * @param figure
         */
        ClassDiagFigureMouseListener(LVClassDiagFigure figure) {
            figure_ = figure;
        }

        /**
         * }EXvX
         */
        public void mousePressed(MouseEvent me) {
            // NX}擾
            LVClassDiag lvClassDiag = (LVClassDiag)figure_.getLvDiag();
            GraphNode selectedGraphNode = figure_.getGraphNode();
            
            // POPUPj[ݒ
            Menu menu = null;
            switch (ModelUtil.getClassifierID(ModelUtil.getElement(selectedGraphNode))) {
            case UML2Package.CLASS:
            case UML2Package.INTERFACE:
                boolean attributeVisible = ModelUtil.isAttributeVisible(selectedGraphNode);
                boolean methodVisible = ModelUtil.isMethodVisible(selectedGraphNode);
                lvClassDiag.POPUPMENU_CLASS_FIG.showAttributeMenuItem_.setSelection(attributeVisible);
                lvClassDiag.POPUPMENU_CLASS_FIG.showMethodMenuItem_.setSelection(methodVisible);
                menu = lvClassDiag.POPUPMENU_CLASS_FIG.menu_;
                break;
            
            case UML2Package.COMMENT:
                menu = lvClassDiag.POPUPMENU_COMMENT;
                break;
            
            default:
                menu = lvClassDiag.POPUPMENU_NORMAL;
                break;
            }
            lvClassDiag.setPopupMenu(menu);
/*            
            if (figure_ instanceof LVClassDiagClassFigure || figure_ instanceof LVClassDiagInterfaceFigure) {
                boolean attributeVisible = ModelUtil.isAttributeVisible(selectedGraphNode);
                boolean methodVisible = ModelUtil.isMethodVisible(selectedGraphNode);
                lvClassDiag.POPUPMENU_CLASS_FIG.showAttributeMenuItem_.setSelection(attributeVisible);
                lvClassDiag.POPUPMENU_CLASS_FIG.showMethodMenuItem_.setSelection(methodVisible);
                menu = lvClassDiag.POPUPMENU_CLASS_FIG.menu_;
            }
            lvClassDiag.setPopupMenu(menu);
*/          
            // ẽCxgnhďoj[\
            figure_.getParent().handleMousePressed(me);
                
            // `NIԂɐݒ
            figure_.setSelectedBackgroundColor();
            Latte.getMainForm().setSelectedModels(selectedGraphNode);

            // [h
            switch (lvClassDiag.getMode()) {
            case LVDiag.MODE_SELECTION:
                // I[hȂFigureŏʂɂ
                lvClassDiag.getDraw2dView().remove(figure_);
                lvClassDiag.getDraw2dView().add(figure_);                
                break;
                
            case LVDiag.MODE_ASSOCIATION:
            case LVDiag.MODE_DEPENDENCY:
            case LVDiag.MODE_GENELIZATION:
            case LVDiag.MODE_IMPLEMENTATION:
            case LVDiag.MODE_NOTELINK:            
                // }I[hȊOȂ֌Wǉ̊Jn
                ((LVClassDiag)getLvDiag()).getAddingLine().start(figure_, me.getLocation());
//                addingConn_.start(figure_, me.getLocation());
                break;
                
            default:
                throw new InternalLogicException("mousePressed()lR");
            }
        }
    
        /**
         * }EX[X
         */
        public void mouseReleased(MouseEvent me) {
            // ẽCxgnhďo
            figure_.getParent().handleMouseReleased(me);
        
            // ֌Wǉ̏I
            ((LVClassDiag)getLvDiag()).getAddingLine().end();
        }

        /**
         * }EX_uNbN
         */ 
        public void mouseDoubleClicked(MouseEvent me) {
            // ẽCxgnhďo
            figure_.getParent().handleMouseDoubleClicked(me);
            // RgȂRgC
            if (me.getSource() instanceof LVClassDiagCommentFigure) {
                AllAction.EDIT_NOTE.execMain(null);
            }
        }
    }
 
    /**
     * }EXXi[
     */
    class ClassDiagFigureMouseMotionListener implements MouseMotionListener {
        /** Xi[Ώ */
        private LVClassDiagFigure figure_ = null;
        
        /**
         * RXgN^
         * @param figure
         */
        ClassDiagFigureMouseMotionListener(LVClassDiagFigure figure) {
            figure_ = figure;
        }

        /**
         * }EXhbO
         */ 
        public void mouseDragged(MouseEvent me) {
            // ẽCxgnhďo
            figure_.getParent().handleMouseDragged(me);
        }
        /**
         * }EXړ
         */ 
        public void mouseMoved(MouseEvent me) {
            // ẽCxgnhďo
            figure_.getParent().handleMouseMoved(me);
        }
        /**
         * }EXObject̒ɓ
         */
        public void mouseEntered(MouseEvent me) {
            // ẽCxgnhďo
            figure_.getParent().handleMouseEntered(me);
        
            // ֌W쐬fromȊOfigureɓ
            if (((LVClassDiag)getLvDiag()).getAddingLine().isToFigCandidate(figure_)) {
                // toFigݒ
                ((LVClassDiag)getLvDiag()).getAddingLine().setToFig(figure_);
                // `NIԂɐݒ
                figure_.setSelectedBackgroundColor();
//                AllAction.SELECT_DEF.execute(figure_);        
            }
        }
        /**
         * }EXObjecto
         */
        public void mouseExited(MouseEvent me) {
            // ẽCxgnhďo
            figure_.getParent().handleMouseExited(me);

            // ֌W쐬fromȊOfigureo
            if (((LVClassDiag)getLvDiag()).getAddingLine().isToFigCandidate(figure_)) {
                // toFigNA
                ((LVClassDiag)getLvDiag()).getAddingLine().setToFig(null);
                // `NIԂɐݒ
                figure_.setNormalBackgroundColor();
//                AllAction.SELECT_NONE.execute(figure_);            
            }
        }
        public void mouseHover(MouseEvent me) {
            // ẽCxgnhďo
            figure_.getParent().handleMouseHover(me);
        }
    }
}