/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.VisibilityKind;

import latte.InternalLogicException;
import latte.Latte;
import latte.action.AllAction;
import latte.di.CoreSemanticModelBridge;
import latte.di.DIPackage;
import latte.di.GraphNode;
import latte.di.Point;
import latte.util.DebugUtil;
import latte.util.ModelUtil;


/**
 * NX}̃C^[tFCXFigure
 * 
 * FRec쐬
 * 
 * @version $Id: LVClassDiagInterfaceFigure.java,v 1.4 2004/09/08 13:17:13 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class LVClassDiagInterfaceFigure extends LVClassDiagFigure  {
    private Label name_ = new Label();
    private CompartmentFigure attributeFigure_ = new CompartmentFigure();
    private CompartmentFigure methodFigure_ = new CompartmentFigure();
    
    /**
     * NXFigureRXgN^
     */
    protected LVClassDiagInterfaceFigure(LVClassDiag parent, GraphNode graphNode) {
        super(parent, graphNode);

        // XeI^Cvݒ
        setStereoType("Interface");
        
        // Rec\쐬
        add(name_);
        add(attributeFigure_);
        add(methodFigure_);
        
        // Rec쐬
        createFigureContents();
    }
    
    /**
     * Rec쐬
     */
    private void createFigureContents() {
        // 
        attributeFigure_.removeAll();
        methodFigure_.removeAll();
        
        // NX`擾
        CoreSemanticModelBridge b = (CoreSemanticModelBridge)graphNode_.getSemanticModel();
        Interface interf = (Interface)b.getElement();
        
        // O
        name_.setText(interf.getName());
        name_.setIcon(AllAction.ADD_INTERFACE.getImage());
        name_.setFont(BOLD);

        // 
        if (ModelUtil.isAttributeVisible(graphNode_)) {
            // \Ȃ
            List al = new ArrayList(interf.getOwnedAttributes());
            Iterator ai = al.iterator();
            while (ai.hasNext()) {
                Property p = (Property)ai.next();
                String name = null;
                // 
                switch (p.getVisibility().getValue()) {
                case VisibilityKind.PUBLIC:   name = "+"; break;
                case VisibilityKind.PROTECTED:name = "#"; break;
                case VisibilityKind.PACKAGE:  name = "~"; break;
                case VisibilityKind.PRIVATE:  name = "-"; break;
                }
                // O
                name += p.getName();
                // ^
                Type t = p.getType();
                name += " : " + ModelUtil.getTypeName(t, false);
            
                Label l = new Label(name, AllAction.SHOW_ATTRIBUTE.getImage());
                attributeFigure_.add(l);
            }
        }
        
        // \bh
        if (ModelUtil.isMethodVisible(graphNode_)) {
            // \Ȃ
            List ol = new ArrayList(interf.getOwnedOperations());
            Iterator oi = ol.iterator();
            while (oi.hasNext()) {
                Operation o = (Operation)oi.next();
                String name = null;
                // 
                switch (o.getVisibility().getValue()) {
                case VisibilityKind.PUBLIC:   name = "+"; break;
                case VisibilityKind.PROTECTED:name = "#"; break;
                case VisibilityKind.PACKAGE:  name = "~"; break;
                case VisibilityKind.PRIVATE:  name = "-"; break;
                }
                // O
                name += o.getName();
                // ()
                name += "()";
                // ^
                Type t = o.getType();
                name += " : " + ModelUtil.getTypeName(t, false);

                Label l = new Label(name, AllAction.SHOW_METHOD.getImage());
                methodFigure_.add(l);
            }
        }
    }
    
    
    /**
     * ύXʒm
     * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
     */
    public void notifyChanged(Notification notification) {
        // eɓ]
        super.notifyChanged(notification);

        if (Latte.TRACE_EVENT) {
            System.out.print(DebugUtil.getEventId(this, notification) + " ");
            System.out.println("LVClassDiagInterfaceFigure notifyChanged:"+notification);
        }

        EObject notifier = (EObject)notification.getNotifier();
        Object newValue = notification.getNewValue();
        Object oldValue = notification.getOldValue();
        Object feature = notification.getFeature();
        String name = (feature instanceof EAttribute) ? ((EAttribute)feature).getName() : null;
        boolean wasSet = notification.wasSet();
        
        // ʂ̂œʂɖ߂
        if (newValue instanceof Point) {
//          System.out.println("LVClassDiagInterfaceFigure Ȃ");
            return;
        }

        
        // CxgɂďU蕪        
        switch (notification.getEventType()) {
        case Notification.ADD:           // A\bh̒ǉ
            if ((notifier instanceof Interface) && // 19
                 (newValue instanceof Property || newValue instanceof Operation)){
                     createFigureContents();
                     setConstraint();
                     setValid(false);
            } else {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagInterfaceFigureŏȂCxgȂ̂Ŗ߂");
                }
            }
            break;
            
        case Notification.SET:
            // 1. NXAA\bh̕ύX
            // 2. ̈A\bḧ̕\^\ݒ̕ύX
            doSetEvent(notifier, feature, name, wasSet);
            break;

        case Notification.REMOVE:       // A\bh̍폜
            if ((notifier instanceof Interface) && // 21
                 (oldValue instanceof Property || oldValue instanceof Operation)){
                     createFigureContents();
                     setConstraint();
                     setValid(false);
            } else {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagClassFigureŏȂCxgȂ̂Ŗ߂");
                }
            }
            break;

        // A_v^폜
        case Notification.REMOVING_ADAPTER:
            System.out.println("LVClassDiagClassFigureŏȂCxgȂ̂Ŗ߂");
            break;
            
        default:
            throw new InternalLogicException("T|[g̕ύXʒm");
        }
    }

    /**
     * SETCxg
     * 
     */
    private void doSetEvent(EObject notifier, Object feature, String name, boolean wasSet) {
        // 1. NXAA\bh̕ύX
        // 2. ̈A\bḧ̕\^\ݒ̕ύX
        switch (ModelUtil.getClassifierID(notifier)) {
        case UML2Package.CLASS:
        case UML2Package.PROPERTY:
        case UML2Package.OPERATION:
            if (!(feature instanceof EAttribute && name.equals("name") && wasSet)) {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagInterfaceFigureŏȂCxgȂ̂Ŗ߂");
                }
                return;
            }
            break;
         
        case DIPackage.GRAPH_NODE:
            if (!(feature instanceof EAttribute && name.equals("visible"))) {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagInterfaceFigureŏȂCxgȂ̂Ŗ߂");
                }
                return;
            }
            break;
        
        default:
            if (Latte.TRACE_EVENT) {
                System.out.println("LVClassDiagInterfaceFigureŏȂCxgȂ̂Ŗ߂");
            }
            return;
        }
        
        // SETCxg
        createFigureContents();
        setConstraint();
        setValid(false);
    }
}

