/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/


package latte.view;

import java.util.ArrayList;

import latte.LMChangedEvent;
import latte.action.AllAction;
import latte.di.Diagram;
import latte.model.ILM13UMLDiagramFeaturesChoice;
import latte.model.LM13ClassifierRole;
import latte.model.LM13Comment;
import latte.model.LM13Diagram;
import latte.model.LM13DiagramElement1;
import latte.model.LM13DiagramElement2;
import latte.model.LM13Message;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;

import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/**
 * V[PX}
 * 
 * @version $Id: LVSeqDiag.java,v 1.2 2004/09/04 16:05:42 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class LVSeqDiag extends LVDiag {
	/**
	 * @param lmDiag
	 */
	LVSeqDiag(Diagram diag) {
		super(diag);
		// DiagRec쐬
		createDiagContent();
	}
	
	/**
	 * V[PX}Rec̍쐬
	 * @see createDiagContentBase
	 */
	void createDiagContent() {
        LogUtil.writeln("<!-- <<<<<<<<  V[PX}Rec쐬 >>>>>>> -->");

        LM13DiagramElement1 de1 = ModelUtil.getDiagramElement(getDiagram());
        LM13DiagramElement2[] de2 = de1.getDiagramElement();

        // tBMA쐬
        LogUtil.writeln("<!-- <<<<<<<<  FIGURE쐬 >>>>>>> -->"); 
        for (int i=0; i<de2.length; i++) {
            // Figureǉ
            addFigure(de2[i]);
        }

        // bZ[WRlNV쐬
        LogUtil.writeln("<!-- <<<<<<<<  CONNECTION쐬 >>>>>>> -->"); 
        for (int i=0; i<de2.length; i++) {
            // Figureǉ
            addMessage(de2[i]);
        }

        // m[gN쐬
        LogUtil.writeln("<!-- <<<<<<<<  NOTELINK쐬 >>>>>>> -->");
        for (int i=0; i<de2.length; i++) {
            // Figureǉ
//            addNoteLink(de2[i]);
        }
	}
	
	/**
	 * Figureǉ
	 */
	private void addFigure(LM13DiagramElement2 diagElement) {
		LogUtil.writeln("\n");
		// fElement쐬
		Object modelElement = ModelUtil.getModel(diagElement);
		
		try {
			LogUtil.write("Model쐬 Class="+modelElement.getClass().getName());
			LogUtil.write("  Xmiid="+diagElement.getXmiId());
			if (modelElement instanceof LM13ClassifierRole) {
                // diagvfXgɒǉ
                addDiagElement(diagElement);
                
				// NXAC^[tFCXAAN^[̎
				// Figure쐬
				LVSeqDiagFigure lvDiagFig = LVSeqDiagFigure.createFigure(this, diagElement);
				// viewɒǉ
				GuiUtil.addFigure(getDraw2dView(), lvDiagFig);
			} else {
				LogUtil.writeln("<-̃NX͍쐬Ȃ");				
				return;
			}
			LogUtil.writeln("I");
		}
		catch(IllegalStateException e) {
			e.printStackTrace();
			LogUtil.writeln("sI");
			LogUtil.writeln(e.getMessage());
			MsgUtil.showMsg("G[܂B:"+e.getMessage());
		}
	}

	/**
	 * Connectionǉ
	 */
	private void addMessage(LM13DiagramElement2 diagElement) {
		LogUtil.writeln("\n");
    	
		// fElement쐬
		Object modelElement = ModelUtil.getModel(diagElement);
		Point location = ModelUtil.getLocation(diagElement);
		
		try {
			LogUtil.write("Model쐬 Class="+modelElement.getClass().getName());
			LogUtil.write("  Xmiid="+diagElement.getXmiId());
			if (modelElement instanceof LM13Message) {
				// bZ[W̎
                // diagvfXgɒǉ
                addDiagElement(diagElement);
                
                // ǉ
				LM13Message message = (LM13Message)modelElement;
				String senderXmiid = message.getSender(0);
				String receiverXmiid = message.getReceiver(0);
				LVSeqDiagFigure sendFigure = (LVSeqDiagFigure)lookupFigure(senderXmiid);
                LVSeqDiagFigure receiveFigure = (LVSeqDiagFigure)lookupFigure(receiverXmiid);
				IFigure sendActiveline = null;
				IFigure receiveActiveline = null;
                // SendFigureɃANeBuCǉ
				if (message.getPredecessor()==null) {
					// AȂƂiŏ̃bZ[Wj
					sendActiveline = sendFigure.addActiveline(message, location.y);
				} else {
					// bZ[WkăANeBuC擾
					sendActiveline = sendFigure.getActivelineTaraceback(message);
				}
				// ReceiveFigureɃANeBuCǉ
                receiveActiveline = receiveFigure.addActiveline(message, location.y);
                int senderDy, receiverDy;
                ConnectionRouter router = null;
				if (receiverXmiid.equals(senderXmiid)) {
                    // senderXmiid == receiverXmiid
                    senderDy = LVSeqDiagFigure.ACTIVELINE_HEIGHT/2;
//                    receiverDy = LVSeqDiagFigure.ACTIVELINE_HEIGHT/2;
                    receiverDy = 0;
                    router = new MessageRouter();
				} else {
                    // senderXmiid != receiverXmiid
                    senderDy = receiveActiveline.getBounds().y - sendActiveline.getBounds().y;
                    receiverDy = 0;
				}
				
				// message쐬
				LVSeqDiagConnection lvDiagConn = LVSeqDiagConnection.createConnection(this, diagElement, router);
				lvDiagConn.setSourceAnchor(new MessageAnchor(sendActiveline, senderDy));
				lvDiagConn.setTargetAnchor(new MessageAnchor(receiveActiveline, receiverDy));
								
				// messageviewɒǉ
				GuiUtil.addFigure(getDraw2dView(), lvDiagConn);
			} else {
				LogUtil.writeln("<-̃NX͍쐬Ȃ");				
				return;
			}
			LogUtil.writeln("I");
		}
		catch(IllegalStateException e) {
			e.printStackTrace();
			LogUtil.writeln("sI");
			LogUtil.writeln(e.getMessage());
			MsgUtil.showMsg("G[܂B:"+e.getMessage());
		}
	}
	
	
	/**
	 * @see latte.view.LVDiag#getTabImage()
	 */
	Image getTabImage() {
		return AllAction.ADD_SEQUENCE_DIAGRAM.getImage();
	}

	/**
	 * @see latte.view.LVDiag#createDiagModeBar(org.eclipse.swt.widgets.Composite)
	 */
	void createDiagModeBar(Composite parent) {
		ToolBar toolbar = new ToolBar(parent, SWT.FLAT);
		GuiUtil.createToolbarItem(toolbar, SWT.RADIO, AllAction.MODE_SELECTION, true);
		GuiUtil.createToolbarItem(toolbar, SWT.RADIO, AllAction.MODE_ASSOCIATION);
		new ToolItem(toolbar,SWT.SEPARATOR);// Zp[^
		GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.ADD_NOTE);
	}


	/* ( Javadoc)
	 * @see latte.view.LVDiag#updateDiag(latte.LMChangedEvent)
	 */
	void updateDiag(LMChangedEvent lmce) {
		// TODO ꂽ\bhEX^u
	}
	
	
	/**
	 * ChopAnchor
	 * 
	 */
	static class MessageAnchor extends AbstractConnectionAnchor {
		int dy_;
		
		public MessageAnchor(IFigure owner, int dy) {
			super(owner);
			dy_ = dy;
		}

		/**
		 * Gets a Rectangle from {@link #getBox()} and returns the Point where a line from the
		 * center of the Rectangle to the Point <i>reference</i> intersects the Rectangle.
		 * 
		 * @param reference The reference point(owner̒_)
		 * @return The anchor location
		 */
		public Point getLocation(Point reference) {
			// ownerRectangle擾
			Rectangle r = Rectangle.SINGLETON;
			r.setBounds(getBox());

			// owner̒_߂
			getOwner().translateToAbsolute(r);
			float centerX = (float)r.x + 0.5f * (float)r.width;
			float centerY = (float)r.y + dy_;
			if (r.isEmpty() || (reference.x == (int)centerX && reference.y == (int)centerY))
				return new Point((int)centerX, (int)centerY);  //This avoids divide-by-zero

			// _Ԃ̍dx,dy߂
			float dx = (float)reference.x - centerX;
			float dy = (float)0;
	
			//r.width, r.height, dx, and dy are guaranteed to be non-zero. 
			float scale = 0.5f / Math.max(Math.abs(dx) / r.width, Math.abs(dy) / r.height);

			dx *= scale;
			dy *= scale;
			centerX += dx;
			centerY += dy;

			return new Point(Math.round(centerX), Math.round(centerY));
		}

		/**
		 * Returns the bounds of this ChopboxAnchor's owner.  Subclasses can override this method
		 * to adjust the box the anchor can be placed on.  For instance, the owner figure may have
		 * a drop shadow that should not be included in the box. 
		 *  
		 * @return The bounds of this ChopboxAnchor's owner
		 * @since 2.0
		 */
		protected Rectangle getBox() {
			return getOwner().getBounds();
		}

		/**
		 * Returns the anchor's reference point. In the case of the ChopboxAnchor, this is the
		 * center of the anchor's owner.
		 * 
		 * @return The reference point
		 */
		public Point getReferencePoint() {
			if (getOwner() == null)
				return null;
			else {
				Point ref = getBox().getCenter();
				getOwner().translateToAbsolute(ref);
				return ref;
			}
		}

	}

    /**
     * bZ[W[^
     */    
    class MessageRouter extends AbstractRouter {
        private final PrecisionPoint A_POINT = new PrecisionPoint();
        
        /**
         * [^
         */
        public void route(Connection conn) {
            PointList points = conn.getPoints();
            points.removeAllPoints();

            Point ref1 = conn.getTargetAnchor().getReferencePoint();
            Point ref2 = conn.getSourceAnchor().getReferencePoint();

            A_POINT.setLocation(conn.getSourceAnchor().getLocation(ref1));
            conn.translateToRelative(A_POINT);
            points.addPoint(A_POINT);
            
            A_POINT.translate(30, 0);
            points.addPoint(A_POINT);

            A_POINT.translate(0, conn.getTargetAnchor().getOwner().getBounds().y - conn.getSourceAnchor().getOwner().getBounds().y-LVSeqDiagFigure.ACTIVELINE_HEIGHT/2);
            points.addPoint(A_POINT);
            
            A_POINT.setLocation(conn.getTargetAnchor().getLocation(A_POINT));
            conn.translateToRelative(A_POINT);
            points.addPoint(A_POINT);

            conn.setPoints(points);
        }
    }
}
