/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import latte.model.LM13DiagramElement2;
import latte.model.LM13Message;
import latte.util.ModelUtil;

import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;


/**
 * 
 * V[PX}̃RlNVtBMBA
 * 
 * }EXCxgeɂʒm
 * 
 * @version $Id: LVSeqDiagConnection.java,v 1.2 2004/09/04 16:05:40 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class LVSeqDiagConnection extends PolylineConnection implements MouseListener, MouseMotionListener {
    /** e */
    protected LVSeqDiag parent_ = null;
    /** LMRelation */
    protected LM13DiagramElement2 lmDiagElement_ = null; // subject:LM13Generalization, LM13Association,LM13Dependency,LM13Abstraction
    /** NbNʒu */
    private int clickPos_ = 0; // CLICKPOS_SOURCE or CLICKPOS_TARGET
    
    /** ̑(W) */
    public static final int WIDTH_NORMAL = 1;
    /** ̑(I) */
    public static final int WIDTH_SELECTED = 2;
    
    /**
     * RXgN^
     * 
     * @param parent
     * @param rel
     */
    public LVSeqDiagConnection(LVSeqDiag parent, LM13DiagramElement2 element) {
        // e
        parent_ = parent;
        // f
		lmDiagElement_ = element;
		// F
		setForegroundColor(LVConst.ForeColor);// ̐F

		// RlNV\쐬
		//add(); // \bh

		/*
				// Xi[ǉ
			addMouseListener(this);
			addMouseMotionListener(this);
		*/
    }
    
    /**
     * RlNV̍쐬
     * @param parent
     * @param element
     * @return RlNV
     */
    public static LVSeqDiagConnection createConnection(LVSeqDiag parent, LM13DiagramElement2 element, ConnectionRouter router) {
    	// 쐬RlNV
		LVSeqDiagConnection createdConnection = null;
		// TuWFNg擾
		Object subject = ModelUtil.getModel(element);
		
    	if (subject instanceof LM13Message) {
    		//bZ[W
			createdConnection = new LVSeqDiagConnection(parent, element);
    	} else {
    		throw new IllegalArgumentException("T|[gĂȂelemenť^ł");
    	}
    	
		// RlNVX^C쐬
		createdConnection.setupConnectionStyle(router);

		return createdConnection;
    }
    
   	/**
	 * RlNVX^C쐬
	 * @return
	 */
	protected void setupConnectionStyle(ConnectionRouter router) {
		
		setConnectionRouter(new BendpointConnectionRouter());// [^ݒ
		// 
		RotatableDecoration targetDeco = new LVSeqDiagConnection.LineArrowDecoration();
		setTargetDecoration(targetDeco);
        // [^ݒ
        setConnectionRouter(router);
	}
	

	/**
	 * ΉDiagelement->Subject擾
	 * @return Subject(f̎)
	 */
	public Object getModel() {
		return ModelUtil.getModel(lmDiagElement_);
	}
	

    /**
     * }EXvX
     */
	public void mousePressed(MouseEvent me) {
	}

    
    /**
     * }EX[X
     */
    public void mouseReleased(MouseEvent me) {
    }

    /**
     * }EX_uNbN
     */ 
    public void mouseDoubleClicked(MouseEvent me) {
    }
    
    /**
     * }EXhbO
     */ 
    public void mouseDragged(MouseEvent me) {
    }
    /**
     * }EXړ
     */ 
    public void mouseMoved(MouseEvent me) {
    }
    public void mouseEntered(MouseEvent me) {
    }
    public void mouseExited(MouseEvent me) {
    }
    public void mouseHover(MouseEvent me) {
    }
    

	/**
	 * Returns the clickPos_.
	 * @return int
	 */
	public int getClickPos() {
		return clickPos_;
	}

	/**
	 * 
	 */
	static class LineArrowDecoration extends PolylineDecoration {
		/**
		 * 
		 *
		 */
		LineArrowDecoration() {
			setScale(8, 5);		
		}
	}
}
       