/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import java.util.ArrayList;
import java.util.Iterator;

import latte.Latte;
import latte.model.LM13Actor;
import latte.model.LM13Class;
import latte.model.LM13ClassifierRole;
import latte.model.LM13DiagramElement2;
import latte.model.LM13Interface;
import latte.model.LM13Message;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.swt.graphics.GC;

/**
 * 
 * NX}̒ۃtBMBA
 * @NXAC^[tFCXAm[g
 * 
 * E}EXCxgeɒʒm
 * EIԂɂ
 * 
 * @version $Id: LVSeqDiagFigure.java,v 1.2 2004/09/04 16:05:41 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public abstract class LVSeqDiagFigure extends LVDiagFigure {
	// ^
	protected Label classNameLabel_ = new Label();
	// CtC
	protected RectangleFigure lifeLine_ = new RectangleFigure();
	// ANeBuC
	static final int ACTIVELINE_WIDTH = 10;
	static final int ACTIVELINE_HEIGHT = 30;
	private ArrayList activelineList_ = new ArrayList();
	
	static final int FIGURE_Y = 20;


    /**
     * RXgN^
     */
    public LVSeqDiagFigure(LVSeqDiag lvSeqDiag, LM13DiagramElement2 lmDiagElement) {
        super(lvSeqDiag, lmDiagElement);
		// CAEg}l[Wݒ
		setLayoutManager(new XYLayout());
		// g
		setBorder(null);
		// ʒuݒ
		Point p = getLocation();
		setLocation(new Point(p.x, FIGURE_Y));

        // Xi[o^
/*
        addMouseListener(this);
        addMouseMotionListener(this);
*/
    }

    /* ( Javadoc)
     * @see latte.view.LVDiagFigure#updateFigure()
     */
    void updateFigure() {
        // TODO ꂽ\bhEX^u
        
    }

    /* ( Javadoc)
     * @see latte.view.LVDiagFigure#updateFigure(boolean)
     */
    void updateFigure(boolean contens) {
        // TODO ꂽ\bhEX^u
        
    }
    
    /**
     * Figure̍쐬
     * @param parent
     * @param lmDiagElement
     * @pre lmDiagElement̃f = LM13ClassifierRole
     * @return
     */
    protected static LVSeqDiagFigure createFigure(LVSeqDiag parent, LM13DiagramElement2 lmDiagElement) {
		// `FbN
		Object o = ModelUtil.getModel(lmDiagElement);
		if (!(o instanceof LM13ClassifierRole)) {
			LogUtil.writeln("Class="+o.getClass().getName());
			throw new IllegalArgumentException("T|[gĂȂł");    	
		}


		// 쐬Figure
		LVSeqDiagFigure createdFigure = null;
		// TuWFNg擾
		LM13ClassifierRole cRole = (LM13ClassifierRole)o;
    	
		Object model = ModelUtil.getModel(cRole);
		
		if (model instanceof LM13Class) {
			//NXFigure
			createdFigure = new LVSeqDiagClassFigure(parent, lmDiagElement);

		} else if (model instanceof LM13Interface) {
			//C^[tFCXFigure
			createdFigure = new LVSeqDiagInterfaceFigure(parent, lmDiagElement);

		} else if (model instanceof LM13Actor) {
			//AN^[Figure
			createdFigure = new LVSeqDiagActorFigure(parent, lmDiagElement);
			
		} else {
			LogUtil.writeln("Class="+model.getClass().getName());
			throw new IllegalArgumentException("T|[gĂȂlmDiagElemenť^ł");
		}

		// Rec쐬
		createdFigure.createFigureContents();        
		
		return createdFigure;
    }
    /**
     * tBMARec쐬
     */
	protected void createFigureContents() {
		// NX`擾
		LM13ClassifierRole cRole = (LM13ClassifierRole)ModelUtil.getModel(lmDiagElement_);
		
		// O
		String name = ModelUtil.getName(cRole);
		classNameLabel_.setText(name);
		classNameLabel_.setOpaque(true);
		classNameLabel_.setBackgroundColor(LVConst.ClassBackColor);
		classNameLabel_.setBorder(new SchemeBorder(SchemeBorder.SCHEMES.ETCHED));
		
		int x = GuiUtil.stringExtent(name) / 2 + 10;
		int y = classNameLabel_.getLocation().y+25;
		lifeLine_.setLineStyle(Graphics.LINE_DOT);
		lifeLine_.setBounds(new Rectangle(x, y, 1, 2048));
		
		GuiUtil.addFigure(this, classNameLabel_);
		GuiUtil.addFigure(this, lifeLine_);
	}
	
	/**
	 * bZ[WkĒT
	 * @param msg
	 * @return
	 */
	public Activeline getActivelineTaraceback(LM13Message message) {
		String[] pre = message.getPredecessor();
		if (pre != null && pre.length > 0) {
			LM13Message preMsg = (LM13Message)ModelUtil.getModel(pre[0]);
			Activeline activeline = getActiveline(preMsg.getXmiId());
			if (activeline == null) {
				return getActivelineTaraceback(preMsg);
			} else {
				return activeline;
			}
		}
		throw new IllegalArgumentException("bZ[WɑΉANeBułȂBbZ[WsłB");
	}

	/**
	 * 
	 * @param message
	 * @return
	 */
	public Activeline getActiveline(String msgXmiid) {
		Iterator ite = activelineList_.iterator();
		
		Activeline activeline = null;
		while (ite.hasNext()) {
			activeline = (Activeline)ite.next();
			if (activeline.getMessage().getXmiId().equals(msgXmiid)) {
				return activeline;
			}
		}
		return activeline;
	}
	
	/**
	 * ANeBuC̍쐬
	 */
	public IFigure addActiveline(LM13Message message, int y) {
        LogUtil.writeln("activeline.y = " + y);
		int x = lifeLine_.getLocation().x + ACTIVELINE_WIDTH/2*(getRecursiveCount(message.getReceiver(0), message, 0)-1);
		
		int height = ACTIVELINE_HEIGHT * getChainCount(message, 1);
		if (message.getSender(0).equals(ModelUtil.getModel(lmDiagElement_))) {
			// 擪FigureȂPUP
			height += ACTIVELINE_HEIGHT;
		}
		
		int width = ACTIVELINE_WIDTH;
		
		Activeline activeline = new Activeline(message);
		activeline.setBounds(new Rectangle(x, y, width, height));
		
		GuiUtil.addFigure(this, activeline);
		// Xgɒǉ
		activelineList_.add(activeline);
		
		return activeline;
	}
	
	/**
	 * ɉAĂ邩iċAĂ邩j߂
	 * @param targetXmiid
	 * @param message
	 * @param n
	 * @return 0,1,2,....
	 */
	private int getRecursiveCount(String targetXmiid, LM13Message message, int n) {
		if (message.getSender(0).equals(targetXmiid)) {
			n = n + 1;
		}
		// Ăяok
		String[] pre = message.getPredecessor();
		if (pre != null && pre.length > 0) {
			LM13Message preMsg = (LM13Message)ModelUtil.getModel(pre[0]);
			return getRecursiveCount(targetXmiid, preMsg, n);
		}
		return n;
	}
	
	/**
	 * AԂ
	 * @param message
	 * @param count
	 * @return
	 */
	private int getChainCount(LM13Message message, int count) {
		String[] mes3xmiid = message.getMessage3();
		if (mes3xmiid != null && mes3xmiid.length > 0) {
			LM13Message nextMessage = (LM13Message)ModelUtil.getModel(mes3xmiid[0]);
			return getChainCount(nextMessage, count+1);
		}
		
		return count;
	}
    
    /**
     * ΉDiagElement擾
     * @return LMFigure
     */
    public LM13DiagramElement2 getDiagElement2() {
        return lmDiagElement_;
    }
    
    /**
     * ΉDiagelement->Subject擾
     * @return Subject(f̎)
     */
    public Object getModel() {
    	return ModelUtil.getModel(lmDiagElement_);
    }
    
    /**
     * XV
     * 
     * XVΏہFʒuAFATCYAĕ`
     */
/*
    public void updateFigure() {
        // ʒu
        setLocation(ModelUtil.getPosition(lmDiagElement_));        
        // wiF
//		setBackgroundColor(LVConst.BackColor);
		// TCYݒ
//		setSize(computeSize());
		// ĕ`
		repaint();
    }
*/  

	static class Activeline extends RectangleFigure {
		private LM13Message lmMessage_;
		Activeline(LM13Message lmMessage) {
			lmMessage_ = lmMessage;
		}
		LM13Message getMessage() {
			return lmMessage_;
		}
	}
	  
    /**
     * LifelineAnchor
     */
	static class LifelineAnchor extends AbstractConnectionAnchor {
		public LifelineAnchor(IFigure owner) {
			super(owner);
		}

		/**
		 * Gets a Rectangle from {@link #getBox()} and returns the Point where a line from the
		 * center of the Rectangle to the Point <i>reference</i> intersects the Rectangle.
		 * 
		 * @param reference The reference point
		 * @return The anchor location
		 */
		public Point getLocation(Point reference) {
			Rectangle r = Rectangle.SINGLETON;
			r.setBounds(getBox());
			r.translate(-1, -1);
			r.resize(1, 1);

			getOwner().translateToAbsolute(r);
			float centerX = (float)r.x + 0.5f * (float)r.width;
			float centerY = (float)r.y + 0.5f * (float)r.height;
	
			return new Point((int)centerX, (int)centerY+2000);
		}

		/**
		 * Returns the bounds of this ChopboxAnchor's owner.  Subclasses can override this method
		 * to adjust the box the anchor can be placed on.  For instance, the owner figure may have
		 * a drop shadow that should not be included in the box. 
		 *  
		 * @return The bounds of this ChopboxAnchor's owner
		 * @since 2.0
		 */
		protected Rectangle getBox() {
			return getOwner().getBounds();
		}
		/**
		 * Returns the anchor's reference point. In the case of the ChopboxAnchor, this is the
		 * center of the anchor's owner.
		 * 
		 * @return The reference point
		 */
		public Point getReferencePoint() {
			if (getOwner() == null)
				return null;
			else {
				Point ref = getBox().getCenter();
				getOwner().translateToAbsolute(ref);
				return ref;
			}
		}
	}
	
/*
	static class LifeLineConnection extends PolylineConnection{
		{
			setSize(1, 2000);
		}
		public boolean isOpaque() {
			return true;
		}
		public Rectangle gerBounds() {
			Rectangle r = new Rectangle(1,1,1,2000);
			
			return r;
		}
		
	}
*/
}