/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import latte.action.AllAction;
import latte.util.GuiUtil;
import latte.util.MsgUtil;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/**
 * 
 * @version $Id: MainForm.java,v 1.3 2004/02/19 18:23:39 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class MainForm {
	/** fBXvC */
    private static Display display_ = new Display ();
    /** VF */
    private static Shell shell_ = new Shell(display_);
    static {
		// util
		GuiUtil.init(display_, shell_);
		MsgUtil.init(display_, shell_);
    }
	
    /** S */
    private SashForm latteForm_ = null;
	/** c[ */
	private LVTree tree_ = null;
	/** vpeB */
	// @TODO
	private Text prop_ = null;
	/** }tH_ */
	private LVDiagFolder diagFolder_ = null;
    /** I𒆂̃f */
    private EObject selectedModel_ = null;

    /**
     * RXgN^
     */
	public MainForm() {
	    // EBhẼ^Cgw
	    shell_.setText(AllAction.LATTE_MYSELF.getTitle());
        shell_.setImage(AllAction.LATTE_MYSELF.getImage());
        
        // X{^Ή
        shell_.addShellListener(new ShellAdapter() {
            public void shellClosed(ShellEvent e){
                AllAction.FILE_EXIT.execute(e);
            }
        });
	    
	    // CAEg
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
		shell_.setLayout(layout);
		
		// S
        createMainMenuBar();// j[o[쐬
        createMainCoolBar();// N[o[쐬
 		latteForm_ = new SashForm(shell_, SWT.HORIZONTAL);
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.FILL_VERTICAL);
        latteForm_.setLayoutData(gridData);
        //
		// 
		Composite leftView = new Composite(latteForm_, SWT.BORDER);
		leftView.setLayout(new FillLayout());
		SashForm leftSash = new SashForm(leftView, SWT.VERTICAL);
        // c[̈
		tree_ = new LVTree(leftSash);
        // vpeB̈
		prop_ = new Text(leftSash,SWT.MULTI|SWT.H_SCROLL|SWT.V_SCROLL);
        //
		// E
		diagFolder_ = new LVDiagFolder(latteForm_);
		// I[v
		shell_.open();
	}
    
    /**
     * 
     *
     */
    public void init() {
        // ^Cg̏
        shell_.setText("Latte:");
        // Treȅ
        tree_.init();
        // DiagFoldeȑ
        diagFolder_.init();
    }
    
    /**
     * I𒆂̃f
     *
     */
    public EObject getSelectedModels() {
        return selectedModel_;
    }

    /**
     * I𒆂̃f
     *
     */
    public void setSelectedModels(EObject model) {
        selectedModel_ = model;
        // gANVXV
        AllAction.updateActionState();
    }

	/**
	 * N[o[쐬
	 */
	private void createMainCoolBar() {
        // N[o[쐬
        CoolBar coolbar = new CoolBar(shell_, SWT.NULL);

        // c[o[쐬
        Control fileToolbar = createFileToolBar(coolbar);
        Control editToolbar = createEditToolBar(coolbar);
        Control addToolbar = createAddToolBar(coolbar);

        // N[ACe쐬FCoolItemCoolBarŃhbN\ȋƂȂ
        GuiUtil.createCoolItem(coolbar, fileToolbar);
        GuiUtil.createCoolItem(coolbar, editToolbar);
        GuiUtil.createCoolItem(coolbar, addToolbar);
	}
    

    /**
     * t@Cc[o[쐬
     */
    private Control createFileToolBar(CoolBar coolbar) {
        ToolBar toolbar = new ToolBar(coolbar, SWT.FLAT);    
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.FILE_NEW);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.FILE_OPEN);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.FILE_SAVE);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.FILE_SAVEAS);
        new ToolItem(toolbar,SWT.SEPARATOR);// Zp[^
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.FILE_PRINT);
        
        return toolbar;
    }
    /**
     * ҏWc[o[쐬
     */
    private Control createEditToolBar(CoolBar coolbar) {
        ToolBar toolbar = new ToolBar(coolbar, SWT.FLAT);
/*
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.EDIT_CUT);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.EDIT_COPY);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.EDIT_PASTE);
*/
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.EDIT_REMOVE);

        return toolbar;
    }
    /**
     * ǉc[o[쐬
     */
    private Control createAddToolBar(CoolBar coolbar) {
        ToolBar toolbar = new ToolBar(coolbar, SWT.FLAT);    
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.ADD_CLASS_DIAGRAM);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.ADD_SEQUENCE_DIAGRAM);
        new ToolItem(toolbar,SWT.SEPARATOR);// Zp[^
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.ADD_PACKAGE);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.ADD_CLASS);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.ADD_INTERFACE);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.ADD_ATTRIBUTE);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.ADD_METHOD);

        return toolbar;
    }
        


	/**
	 * j[o[쐬
	 */
	private void createMainMenuBar() {
        // Cj[o[쐬
        Menu menubar = new Menu(shell_,SWT.BAR);
        shell_.setMenuBar(menubar);

        // t@Cj[
        Menu fileMenu = GuiUtil.createMenu(menubar ,"t@C");
        GuiUtil.createMenuItem(fileMenu, AllAction.FILE_OPEN);
        GuiUtil.createMenuItem(fileMenu, AllAction.FILE_SAVE);
        GuiUtil.createMenuItem(fileMenu, AllAction.FILE_SAVEAS);
        new MenuItem(fileMenu,SWT.SEPARATOR);
        GuiUtil.createMenuItem(fileMenu, AllAction.FILE_PRINT);
        new MenuItem(fileMenu,SWT.SEPARATOR);
        GuiUtil.createMenuItem(fileMenu, AllAction.FILE_EXIT);

        // ҏWj[
        Menu editMenu = GuiUtil.createMenu(menubar ,"ҏW");
        GuiUtil.createMenuItem(editMenu, AllAction.EDIT_CUT);
        GuiUtil.createMenuItem(editMenu, AllAction.EDIT_COPY);
        GuiUtil.createMenuItem(editMenu, AllAction.EDIT_PASTE);
        GuiUtil.createMenuItem(editMenu, AllAction.EDIT_REMOVE);

        // ǉj[
        Menu addMenu = GuiUtil.createMenu(menubar ,"ǉ");
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_CLASS_DIAGRAM);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_SEQUENCE_DIAGRAM);
        new MenuItem(addMenu,SWT.SEPARATOR);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_PACKAGE);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_CLASS);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_INTERFACE);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_ATTRIBUTE);
        GuiUtil.createMenuItem(addMenu, AllAction.ADD_METHOD);
        
		// ǉj[
		Menu toolMenu = GuiUtil.createMenu(menubar ,"c[");
        GuiUtil.createMenuItem(toolMenu, AllAction.TOOL_JAVA_REVERSE);
//		GuiUtil.createMenuItem(toolMenu, AllAction.TOOL_OPEN_RXP);
        
        // wvj[
        Menu helpMenu = GuiUtil.createMenu(menubar ,"wv");
        GuiUtil.createMenuItem(helpMenu, AllAction.HELP_DOC);        
        GuiUtil.createMenuItem(helpMenu, AllAction.HELP_VER);        
   	}
    
    
    /**
     * ^Cg̐ݒ
     * @param title
     */
    public void setTitle(String title) {
        shell_.setText(title);        
    }
    

    /**
     * s[vJn
     */	
	public void run() {
		// C[v
	    while (!shell_.isDisposed ()){
            try {
                if (!display_.readAndDispatch ()){
                    display_.sleep ();
                }
            } catch (Exception e) {
                e.printStackTrace();
                MsgUtil.showMsg(e.getMessage());
            }
	    }
	    // [vIɃfBXvCj
	    display_.dispose ();
	}


    /**
     * vpeBԂ
     */
	public Text getProp() {
		return prop_;
	}
	
	/**
	 * Returns the tree.
	 * @return Tree
	 */
	public LVTree getTree() {
		return tree_;
	}

	/**
	 * Returns the rightView.
	 * @return Composite
	 */
	public LVDiagFolder getDiagFolder() {
		return diagFolder_;
	}

	/**
	 * Returns the latteForm.
	 * @return SashForm
	 */
	public SashForm getLatteForm() {
		return latteForm_;
	}

	/**
	 * I
	 *
	 */
	public void destroy() {
		shell_.dispose();
	}
}
