/**
 * $Id: Logger.java,v 1.1 2004/07/28 02:48:20 dobashi Exp $
 *
 * Copyright Lavans Networks Inc.
 */
package com.lavans.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.w3c.dom.Element;

/**
 * K[B
 * Oo͗p[eBeBB
 *
 * @author	dobashi
 * @version	1.0
 */

public class Logger{
	/**
	 * NXB
	 * getMethodName()ŎgpBgetClass().getName()ł͒xȂ邽߁B
	 */
	private static final String CLASSNAME="com.lavans.util.Logger";
	 
	/**
	 * ݒt@C̃ZNVB
	 */
	private static final String CONFIG_SECTION="logger";	// ftHg:Logger getInstance(String)Ŏw

	/**
	 * Oo̓xB
	 **/
	public static final int ERR   = 0;
	public static final int LOG   = 1;
	public static final int DEBUG = 2;
	public static final int TRACE = 3;
	/**
	 * OxB
	 **/
	private int logLevel = 0;

	/**
	 * Oe[gԊu`B
	 */
	public static final String SECONDLY = "secondly";
	public static final String MINUTELY = "minutely";
	public static final String HOURLY   = "hourly";
	public static final String DAILY    = "daily";
	public static final String WEEKLY   = "weekly";
	public static final String MONTHLY  = "monthly";
	/**
	 * Oe[gԊuB
	 */
//	private String term = null;
	private int rotate_term = Calendar.DATE;	
	
	/**
	 * CfgpB\bhin/out̃g[XsƂ̃Cfg̐[B
	 **/
	private StringBuffer buf = new StringBuffer();
	
	/**
	 * O\tH[}bg
	 */
	private DateFormat time_format = null;

	/**
	 * ŌɃOƂ̎
	 */
	private Calendar lastLog = null;
	
	/**
	 * e[g
	 */
	private int rotate = 5;
	
	/**
	 * Ot@C
	 * tXVɃOt@C蒼߁A
	 * CX^XϐƂĂƂĂB
	 */
	private String logfileName = null;
	
	/**
	 * ߋ̃Ot@C̈ꗗ
	 */
	//private List logfileList = null;

	/**
	 * CX^XǗ
	 **/
//	private static Logger instance = null;
	private static Map instanceMap = new HashMap();
	
	/**
	 * o͐
	 **/
	private PrintStream log;
	/**
	 * o͐FileOutputStream.
	 * t@CXVɃN[YKv邽
	 * CX^XϐƂB
	 */
	private OutputStream fileOut;
	
	/**
	 * main method for test.
	 **/
	public static void main(String[] args){
		Logger logger = Logger.getInstance();
		logger.log("LogTest:"+new java.util.Date().toString());		// No.4
		logger.err("LogTest:"+new java.util.Date().toString());		// No.5
		logger.debug("LogTest:"+new java.util.Date().toString());		// No.6
	}
	
	/**
	 * You can't call constructor.
	 **/
	private Logger(String configSection) {
		//logfileList = new ArrayList();
		
		Element conf = (Element)Config.getNode(configSection);
		// O̎tH[}bg
		String format = conf.getAttribute("time_format");
		//System.out.println("time_format["+ format +"]");
		if(format.equals("")){							// w肳ĂȂꍇ
			format = "yyyy/MM/dd HH:mm:ss.SSS";		// ftHg
		}
		time_format = new SimpleDateFormat(format);

		// Oo͐
		logfileName = conf.getAttribute("file");
		if(logfileName.equals("System.out")){
			log = System.out;
		}else{
			// Ot@CI[vOɑ݊mF
			boolean isExistFile = new File(logfileName).exists();
			log = setStream(logfileName);
			// Ot@C̍XVԊu
			String term = conf.getAttribute("term");
			if((term==null) || (term.equals(""))){							// w肳ĂȂꍇ
				rotate_term = Calendar.DATE;
			}else if(SECONDLY.equals(term)){
				rotate_term = Calendar.SECOND;
			}else if(MINUTELY.equals(term)){
				rotate_term = Calendar.MINUTE;
			}else if(HOURLY.equals(term)){
				rotate_term = Calendar.HOUR_OF_DAY;
			}else if(WEEKLY.equals(term)){
				rotate_term = Calendar.WEEK_OF_YEAR;
			}else if(MONTHLY.equals(term)){
				rotate_term = Calendar.MONTH;
			}


			// Ot@C̃e[g
			try{
				rotate = Integer.parseInt(conf.getAttribute("rotate"));
			}catch (Exception e) {
				debug("log rotate擾sBftHg"+ rotate);
			}

			// 񋭐e[g
			boolean isInitialRotate = false;
			try{
				isInitialRotate = Boolean.valueOf(conf.getAttribute("initial_rotate")).booleanValue();
			}catch (Exception e) {
			}
			if(isInitialRotate && isExistFile){ // 񃍃e[gKvȂ
				rotate();			 			// e[g
			}
		}

		lastLog = Calendar.getInstance();

		// Ox̎擾
		try{
			logLevel = Integer.parseInt(conf.getAttribute("level"));
		}catch(Exception e){
			log.println(timeFormat()+"get [level] failed. level is set to TRACE");
			logLevel = TRACE;
		}
	}
	
	/**
	 * Oo͐̎w
	 **/
	private PrintStream setStream(String logfile){
		PrintStream out = null;
		try{
			fileOut = new FileOutputStream(logfile,true);
			out = new PrintStream(fileOut);
		}catch(FileNotFoundException e){
			System.err.println("Can't open logfile.["+logfile+"] log is set to [System.out]");
			System.err.println(e.getMessage());
			out = System.out;
		}
		return out;
	}

	/**
	 * This is Singleton pattern.
	 **/
	public static Logger getInstance(String configSection) {
		Logger instance = (Logger)instanceMap.get(configSection);
		if(instance==null){
			instance = new Logger(configSection);
			instanceMap.put(configSection,instance);
		}
		return instance;
	}

	/**
	 * This is Singleton pattern.
	 **/
	public static Logger getInstance() {
		return getInstance(CONFIG_SECTION);
	}

	/**
	 * Oo͐̃`FbNуOp\ݒ
	 * @param date
	 * @return
	 */
	private String timeFormat(){
		// System.out
		if(log==System.out){
			return time_format.format(new Date());
		}
		
		
		Calendar now = Calendar.getInstance();

		if(now.get(rotate_term)!=lastLog.get(rotate_term)){ 		// ςĂ(̏ꍇ)
			System.out.println("rotateԊu"+ rotate_term +" now["+ now.get(rotate_term) +"] last["+ lastLog.get(rotate_term) +"]");
			rotate();
		}
		
		lastLog = now;
		return time_format.format(now.getTime());
	}
	
	private void rotate(){
		// ԌÂO̍폜
		File file = new File(logfileName + "."+ rotate);
		file.delete();
			
		// ߋOmv
		for(int i=rotate; i>1; i--){
			file = new File(logfileName + "."+ (i-1));
			file.renameTo(new File(logfileName + "."+ i));
		}
		// ݂̃Ot@C
		log.close();
		try{
			fileOut.close();
		}catch(IOException e){
			System.out.println("Ot@CN[Ys.\n"+ e.getMessage());
		}
		file = new File(logfileName);
			
		if(file.renameTo(new File(logfileName + ".1"))){
			System.out.println("Ot@CXV");
		}else{
			System.out.println("Ot@CXVs");
		}		

		// VOt@C
		log = setStream(logfileName);
	}
	
	/**
	 * G[o
	 * Create exception log. This log is important for recovery.
	 **/
	public void err(String msg){
		log.println(timeFormat() + " ERR  :" + buf + msg);
	}
	
	/**
	 * G[o
	 * Create exception log. This log is important for recovery.
	 **/
	public void err(Exception e){
		log.println(timeFormat() + " ERR  :" + buf + e.getMessage());
		e.printStackTrace(log);
	}

	/**
	 * OB
	 **/
	public void log(String msg){
		if(logLevel<LOG){
			return;
		}
		log.println(timeFormat() + " LOG  :" + buf + msg);
	}

	/**
	 * fobOOBbyte[]pBfobOoff̎ɖpString𐶐Ȃ߂ɍ쐬B
	 **/
	public void debug(byte[] msg){
//			msg = new String(msg.getBytes("EUC_JP")).trim();
		if(logLevel<DEBUG){
			return;
		}
		log.println(timeFormat() + " DEBUG:" + buf +new String(msg));
	}

	/**
	 * fobOOBfobOp̏o͂ёzONullPointerExceptionfoB
	 **/
	public void debug(String msg){
		if(logLevel<DEBUG){
			return;
		}
		log.println(timeFormat() + " DEBUG:" + buf +msg);
	}

	/**
	 * g[XB\bhinB
	 **/
	public void entering(String sourceClass,String sourceMethod){
		if(logLevel<TRACE){
			return;
		}
		log.println(timeFormat() + " TRACE:" + buf + sourceClass + "#" + sourceMethod + "() entering");
		buf.append("  ");
	}

	/**
	 * g[XB\bhinB
	 * StackTracegĂяõ\bh肷B
	 **/
	public void entering(){
		if(logLevel<TRACE){
			return;
		}
		log.println(timeFormat() + " TRACE:" + buf + getMethodName() +" ENTER");
		buf.append("  ");
	}

	/**
	 * g[XB
	 **/
	public void exiting(String sourceClass,String sourceMethod){
		if(logLevel<TRACE){
			return;
		}
		try{
			buf.delete(0,2);
		}catch(Exception e){
			buf=new StringBuffer();
		}
		log.println(timeFormat() + " TRACE:" + buf + sourceClass + "#" + sourceMethod + "() exiting");

	}

	/**
	 * g[XB\bhoutB
	 * StackTracegĂяõ\bh肷B
	 **/
	public void exiting(){
		if(logLevel<TRACE){
			return;
		}
		try{
			buf.delete(0,2);
		}catch(Exception e){
			buf=new StringBuffer();
		}
		log.println(timeFormat() + " TRACE:" + buf + getMethodName() +" EXIT");
	}

	/**
	 * Destructor.
	 * This method override Object#finalize().
	 **/
	protected void finalize() throws Throwable {
		log.close();
		super.finalize();
	}

	private String getMethodName() {
		return getMethodName(CLASSNAME);
	}
	
	/**
	 * \bh̎擾B
	 * LogRecord#inferCaller()̃pNB
	 * 
	 * @see java.util.loggin.LogRecord#inferCaller
	 *
	 */
	public String getMethodName(String classname) {
		// Get the stack trace.
		StackTraceElement stack[] = (new Throwable()).getStackTrace();
		// First, search back to a method in the Logger class.
		int ix = 0;
		while (ix < stack.length) {
			StackTraceElement frame = stack[ix];
			String cname = frame.getClassName();
//					log(cname);
			if (classname.equals(cname)) {
				break;
			}
			ix++;
		}
		// Now search for the first frame before the "Logger" class.
		while (ix < stack.length) {
			StackTraceElement frame = stack[ix];
			String cname = frame.getClassName();
//			log(cname+"#"+frame.getMethodName() +"()");
			if (!classname.equals(cname)) {
//				return frame.toString();
				return cname+"#"+frame.getMethodName() +"()";
//				return cname+"#"+frame.getMethodName() +"("+frame.getFileName() +":"+ frame.getLineNumber() +")";
			}
			ix++;
		}
		return "";
	}
}

