/**
 * $Id: BrowserChecker.java,v 1.1 2004/07/28 02:48:20 dobashi Exp $
 *
 * 
 * Copyright Lavans Networks Inc. 2003/12/18
 */
package com.lavans.util.browser;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import com.lavans.util.BaseClass;
import com.lavans.util.Config;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * BrowserʃNXB
 * gтP@ɂBrowserNXCX^XAHashMap̒Ɋi[B
 * browserMap User-AgentƃuEUNX΂ɂȂMap
 * @author dobashi
 * @version 1.0
 */
public class BrowserChecker extends BaseClass {
	public static final String DESKTOP = "desktop";
	public static final String PHONE = "phone";
	public static final String PDA = "pda";

	public static final String DOCOMO_PDC = "docomo_pdc";
	public static final String DOCOMO_FOMA= "docomo_foma";
	public static final String EZWEB		= "ezweb";
	public static final String EZWEB_WAP2 = "ezweb_wap2";
	public static final String VODAFONE	= "vodafone";

	/**
	 * ݒt@C̃ZNVB
	 */
	private static String CONFIG_SECTION="browser";

	/** singleton̎ */
	private static BrowserChecker instance = null;
	
	/**
	 * uEUʈꗗB
	 * DESKTOP */
	private Map browserTypeMap = null;
	
	/** ݒt@Cɖꍇ̃ftHg
	/** LAꗗ */
	//private Map carrierMap = null;
	/** 
	
	/**
	 * RXgN^BSingleton̂ߌĂяosB
	 *
	 */
	protected BrowserChecker(){
		logger.entering();
		
		init();

		logger.exiting();
	}
	
	
	/**
	 * CX^X擾B
	 * @return
	 */
	public static BrowserChecker getInstance(){
		logger.entering("BrowserChecker","getInstance");
		if(instance==null){
			instance = new BrowserChecker();
		}
		
		logger.exiting("BrowserChecker","getInstance");
		return instance;
	}
	
	/**
	 * 
	 *
	 */ 
	public void init(){
		// @Ǎ̕\
		browserTypeMap = new HashMap();
		Element conf = (Element)Config.getNode(CONFIG_SECTION);
		boolean showModels = Boolean.valueOf(conf.getAttribute("showModels")).booleanValue();
		NodeList list = conf.getChildNodes();
		// gяݒt@C擾
		for(int i=0; i<list.getLength(); i++){
			Node node = list.item(i);
			// eLXgm[h͖
			if(node.getNodeType()==Node.TEXT_NODE){
				continue;
			}
			if("include".equals(node.getNodeName())){
				load(node.getChildNodes().item(0).getNodeValue(), showModels);
			}
		}
	}
	
	/**
	 * ݒt@C̓Ǎ
	 * @param config_file
	 */
	private void load(String config_file, boolean showModels){
		try {
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();	// hLgr_[t@Ng𐶐
			DocumentBuilder builder = dbfactory.newDocumentBuilder();					// hLgr_[𐶐
			Document doc = builder.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(config_file));
																						// p[XsDocumentIuWFNg擾
			// rootm[h(=DoCoMõLA)
			Element root = doc.getDocumentElement();									// [gm[h̎擾
			//System.out.println(root.getTagName());
			
			String type = root.getAttribute("type");
			
			// [gm[hgbrowserMap擾
			Map browserMap = getBrowserMap(root.getTagName());

			NodeList list = root.getChildNodes();
			// eݒ擾
			for(int i=0; i<list.getLength(); i++){
				Node node = list.item(i);		// [m[h
//				System.out.println(node.getNodeName());
				// eLXgERgm[h͖
				if((node.getNodeType()==Node.TEXT_NODE) ||
				   (node.getNodeType()==Node.COMMENT_NODE) ){
					continue;
				}
				Browser browser = new Browser();
				browser.setName(node.getNodeName());	// @햼ݒ
				browser.setType(type);					// ʐݒ(desktop/phone/pda)
				NodeList attrs = node.getChildNodes();
				for(int j=0; j<attrs.getLength(); j++){
					Node attr = attrs.item(j);
					// eLXgERgm[h͖
					if((attr.getNodeType()==Node.TEXT_NODE) ||
					   (attr.getNodeType()==Node.COMMENT_NODE) ){
						continue;
					}

//					logger.debug("attr_name:"+attr.getNodeName());
//					logger.debug("attr_value:"+attr.getNodeValue());
					// Child#TextlH
					String value = null;
					try{
						value = attr.getChildNodes().item(0).getNodeValue();
//						logger.debug("text_value:"+value);
					}catch (Exception e) {
						logger.err(e);
					}
					browser.setAttribute(attr.getNodeName(),value);
				}
				if(showModels){
					logger.debug(browser.toString());
				}
				
				StringTokenizer token = new StringTokenizer(browser.getUserAgent()," ");
				String key = token.nextToken();				// ŏ̋󔒂܂łL[Ƃ
				if((root.getTagName().equals(DOCOMO_FOMA)) &&	// FOMA̎2ڂL[Ƃ
				   (!key.equals("Default")) ){
					key = token.nextToken();
				}else if(root.getTagName().equals(DESKTOP)){	// desktop̏ꍇ
					key = browser.getName();					// OL[ƂB
				}
				
				browserMap.put(key,browser);
			}
			// config^Oproperty擾
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	/**
	 * uEUʔ
	 * 
	 *
	 * @author dobashi
	 * @version 1.0
	 */
	public Browser getBrowser(String userAgent){
		Browser browser = null;
		Map browserMap = null;
		StringTokenizer token = new StringTokenizer(userAgent," ");
		String key = token.nextToken();				// ŏ̋󔒂܂łL[Ƃ
		if(userAgent.indexOf("DoCoMo/1.0")	>-1){
			browserMap = getBrowserMap(DOCOMO_PDC);
		}else if(userAgent.indexOf("DoCoMo/2.0")>-1){
			browserMap = getBrowserMap(DOCOMO_FOMA);
			key = token.nextToken();
		}else if(userAgent.indexOf("KDDI")>-1){
			browserMap = getBrowserMap(EZWEB_WAP2);
		}else if(userAgent.indexOf("UP.Browser")>-1){
			browserMap = getBrowserMap(EZWEB);
			
		}else if(userAgent.indexOf("J-PHONE")>-1){
			browserMap = getBrowserMap(VODAFONE);
			// J-PHONE/4.2/V601N/SNJNEC3099286 N/01000100 Profile/MIDP-1.0 Configuration/CLDC-1.0 Ext-Profile/JSCL-1.1.1
			// VAԍJbgB
			int index = key.lastIndexOf("/SN");
			if(index>0){	// G~[^ƃVAԍȂB
				key = key.substring(0,index);
			}
			logger.debug(key);
		}else{
			// fXNgbv
			browserMap = getBrowserMap(DESKTOP);
			try{
				if(userAgent.indexOf("MSIE")>-1){	// IEȂ
					// Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)
					// 4ڂ{̃o[W
					token.nextToken();	// (compatible;
					token.nextToken();	// MSIE
					String version = token.nextToken();
					version = version.substring(0,version.length()-1);
					int ver = (int)Double.parseDouble(version);	// 6.0
					key = "IE"+ver;
				}else if(userAgent.indexOf("Mozilla")>-1){	// MozillaȂ
					// Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.6) 
					StringTokenizer slashToken = new StringTokenizer(key,"/");
					slashToken.nextToken();
					int ver = (int)Double.parseDouble(slashToken.nextToken());	// 5.0
					key = "Mozilla"+ver;
				}else{
					// Opera/Galeon/Konquere?
				}
			}catch (NoSuchElementException e) {
				// ƎɃJX^}CYꂽςȃ[U[G[WFg
				// ɃijȂB
			}catch (NumberFormatException e) {
				// ƎɃJX^}CYꂽςȃ[U[G[WFg
				// ɃijȂB
			}
		}


		
		
		if(browserMap.containsKey(key)){
			browser = (Browser)browserMap.get(key);
		}else{
			browser = (Browser)browserMap.get("Default");
		}
		return browser;
	}

	/**
	 * @return
	 */
	private Map getBrowserMap(String type){
		Map map = (Map)browserTypeMap.get(type);
		if(map==null){
			map = new HashMap();
			browserTypeMap.put(type,map);
		}
		return map;
	}
	
	/**
	 * uEU^CvꗗԂB
	 * SuEU擾p(eXgp)B
	 * @return
	 */
	public Map getBrowserTypeMap(){
		return browserTypeMap;
	}
}

/**
 * /-
 *  |-"desktop":seriesMap
 *  |  |-"Mozilla":browser
 *  |  |-"IE":browser
 *  |  |-"Opera":browser
 *  |     |-"SO210i":browser
 *  |     |-"P210i":browser
 *  |-"au":seriesMap
 *  |  |-"CDMA1XWIN":browserMap
 *  |  |  |-"W21H":browser
 *  |  |  |-"W11K":browser
 *  |-"au":seriesMap
 *  |  |-"CDMA1XWIN":browserMap
 *  |  |  |-"W21H":browser
 *  |  |  |-"W11K":browser
 * Singleton.
 */