/**
 * $Id: ConnectionPool.java,v 1.1 2004/07/28 02:48:20 dobashi Exp $
 *
 * Copyright Lavans Networks Inc.
 */
package com.lavans.util.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;

import com.lavans.util.Logger;

/**
 * ConnectionPoolB
 * DBManager̂ݗpB
 *
 * @author	dobashi
 * @version 1.0
 * @version 1.1 dobashi20040707 ڑ̗LcreateStatement()Ń`FbNł͂
 */
public class ConnectionPool
{
	/**
	 * Logger
	 */
	private Logger logger = null;
	
	/**
	 * DBڑp`
	 */
	private String driver = null;
	private String url     = null;
	private String user   = null;
	private String pass   = null;
	private String valid_sql = null;

	/**
	 * ڑ`FbNSQL𔭍s邩ǂ
	 */
	private boolean force_check_connection = false;
	/*-----------------------------------------------------
	 * v[ݒ
	 -----------------------------------------------------*/
	/**
	 * RlNVő吔
	 */
	private int max_connections  = 10;
	/**
	 * RlNVl
	 */
	private int init_connections = 10;
	/**
	 * 󂫃RlNVXg
	 */
	private List poolList = new Vector();
	/**
	 * gpRlNVXg
	 */
	private List useList  = new Vector();
	
	private final String MSG_ERR_TOOMANYCONNECTIONS = "ڑől𒴂Ă܂B";

	private static int connection_count=0;
	
	/**
	 * RXgN^B
	 **/
	public ConnectionPool(String aDriver, String aUrl,String aUser,String aPass){
		driver    = aDriver;
		url       = aUrl;
		user      = aUser;
		pass      = aPass;
		logger = Logger.getInstance();
	}
	
	/**
	 * ڑőlݒ
	 **/
	public void setMaxConnections(int value){
		max_connections = value;
	}
	
	/**
	 * ڑlݒ
	 **/
	public void setInitConnections(int value){
		init_connections = value;
	}
	
	/**
	 * 
	 **/
	public void init()
		throws ClassNotFoundException,IllegalAccessException,InstantiationException, SQLException
	{
		DriverManager.registerDriver((Driver)Class.forName(driver).newInstance());
		for(int i=0; i<init_connections; i++){
			poolList.add(createConnection());
		}
	}
	
	/**
	 * DBւ̃RlNV쐬
	 */
	private Connection createConnection()
	  throws SQLException
	{
		logger.entering("ConnectionPool","createConnection");
		logger.debug("connection_count:" + connection_count++);
		
		// ő吔`FbN
		if((poolList.size() + useList.size()) >= max_connections){
			throw new SQLException(MSG_ERR_TOOMANYCONNECTIONS);
		}
		Connection conn = null;
		logger.debug(url+":"+user+":"+pass);
		conn = DriverManager.getConnection(url, user, pass);
		
		logger.exiting("ConnectionPool","createConnection");

		return conn;
	}

	/**
	 * DBւ̃RlNV`FbN
	 */
	private boolean checkConnection(Connection conn)
	{
		boolean result = false;
		Statement st = null;
		ResultSet rs = null;
		try
		{
			st = conn.createStatement();
			// dobashi20040707 ڑ̗LcreateStatement()Ń`FbNł͂
			if(force_check_connection){
				rs = st.executeQuery(valid_sql);
			}
			result = true;			// OȂOK
		}catch (SQLException e) {
			// ŃLb`ĂȂgetConnection()g
			// O𐶐Ă܂B
		}finally{
			try{
				st.close();
				rs.close();
			}catch(Exception e){
			}
		}
		
		return result;
	}

	/**
	 * DBւ̃RlNV擾
	 */
	public Connection getConnection()
	  throws SQLException
	{
		Connection conn=null;
		if(poolList.size()>0){			// v[
			conn=(Connection)poolList.remove(0);	// 
			if(!checkConnection(conn)){		// ڑs
				try{
					conn.close();
				}catch(Exception e){
					e.printStackTrace();
				}
				conn=null;
			}
		}
		
		if(conn==null){
			conn=createConnection();
		}
		useList.add(conn);
		return conn;
	}

	/**
	 * DBւ̃RlNVԋp
	 */
	public void releaseConnection(Connection conn)
	  throws SQLException
	{
		if(!useList.remove(conn)){		// gpXgɑ݂Ȃ
			throw new SQLException("This is not my connection.");
		}
		
		poolList.add(conn);
	}
	/**
	 * @param b
	 */
	public void setForce_check_connection(boolean b) {
		force_check_connection = b;
	}

	/**
	 * @param string
	 */
	public void setValid_sql(String string) {
		valid_sql = string;
	}

}
