/**
 * $Id: DBManager.java,v 1.1 2004/07/28 02:48:20 dobashi Exp $
 *
 * Copyright Lavans Networks Inc.
 */
package com.lavans.util.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.lavans.util.Config;
import com.lavans.util.Logger;

/**
 * DBManager.
 *
 * @author	dobashi
 * @version	1.0
 */
public class DBManager
{
	/**
	 * Logger
	 */
	private static Logger logger = null;

//	private static final String CLASSNAME="com.lavans.util.jdbc.DBManager";
	private static final String CLASSNAME=DBManager.class.getName();
	/**
	 * ݒt@C̃ZNVB
	 */
	private static final String CONFIG_SECTION="database";
	
	/**
	 * ڑ󋵂Ď邩B
	 */
	private static boolean countConnection = false;
	private static Map countConnMap = null;

	/**
	 * DatabaseꗗBConnectionPoolۑzB
	 */
	private static Map  dbMap = null;
	// 
	static{
		init();
	}
	
	/**
	 * B
	 *
	 */
	private static void init(){
		logger = Logger.getInstance();

		dbMap = new HashMap();
		Element conf = (Element)Config.getNode(CONFIG_SECTION);
		NodeList nodeList = conf.getChildNodes();
		if(nodeList==null){	// ݒt@Cdatabasew肪ꍇ
			return;			// ȂɂȂB
		}
		
		// ڑǗp
		try{
			countConnection = Boolean.valueOf(conf.getAttribute("countConnection")).booleanValue();
		}catch (Exception e) {
			// sfalsê܂
		}
		countConnMap = new HashMap();
		
		String name=null,driver=null,url=null,user=null,pass=null,valid_sql=null,max=null,init=null;
		boolean force_check_connection = false;
		for(int i=0; i<nodeList.getLength(); i++){

			if((nodeList.item(i).getNodeType()==Node.TEXT_NODE) ||
			   (nodeList.item(i).getNodeType()==Node.COMMENT_NODE) ){
				continue;
			}
			Element dbConf = (Element)nodeList.item(i);
			
			name   = dbConf.getNodeName();
			driver = dbConf.getAttribute("driver");
			url    = dbConf.getAttribute("url");
			user   = dbConf.getAttribute("user");
			pass   = dbConf.getAttribute("pass");
			max    = dbConf.getAttribute("max_connections");
			init   = dbConf.getAttribute("init_connections");
			logger.debug("max:"+max+", init:"+init);
			ConnectionPool pool = new ConnectionPool(driver,url,user,pass);

			// SQL`FbN[h
			try{
				pool.setForce_check_connection(
					Boolean.valueOf(
						dbConf.getAttribute("force_check_connection")
					).booleanValue()
				);
				pool.setValid_sql(dbConf.getAttribute("valid_sql"));
			}catch (Exception e) {}
			
			try{
				pool.setMaxConnections(Integer.parseInt(max));
			}catch(NumberFormatException e){}
			try{
				pool.setInitConnections(Integer.parseInt(init));
			}catch(NumberFormatException e){}
			// Jn
			try{
				pool.init();
			}catch(Exception e){
				logger.err(e);
			}
			dbMap.put(name,pool);
			logger.debug("create ConnectionPool["+name+"]");
		}
	}
	

	/**
	 * DBւ̃RlNV擾
	 */
	public static Connection getConnection()
	  throws SQLException
	{
		return getConnection("default");
	}
	/**
	 * DBւ̃RlNV擾
	 */
	public static Connection getConnection(String dbName)
	  throws SQLException				// O͌Ăяo֊ۓ
	{
		ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);

		// ڑԊǗꍇ ----------------
		if(countConnection){
			String method = logger.getMethodName(CLASSNAME);
logger.debug(method);
logger.debug(logger.getMethodName("jp.co.lavans.util.DBManager"));
			Integer count = (Integer)countConnMap.get(method);
			if(count==null){
				count = new Integer(1);
			}else{
				count = new Integer(count.intValue()+1);
				// VKɃIuWFNg蒼Ƃ͂ȂH
			}
			countConnMap.put(method,count);
		}

//		logger.debug(logger.getMethodName("jp.co.lavans.util.DBManager"));
		return pool.getConnection();
	}

	/**
	 * DBւ̃RlNVԋp
	 */
	public static void releaseConnection(Connection conn)
	  throws SQLException				// O͌Ăяo֊ۓ
	{
		releaseConnection(conn,"default");
	}
	
	/**
	 * DBւ̃RlNVԋp
	 */
	public static void releaseConnection(Connection conn,String dbName)
	  throws SQLException				// O͌Ăяo֊ۓ
	{
		ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
		pool.releaseConnection(conn);

		// ڑԊǗꍇ ----------------
		if(countConnection){
			String method = logger.getMethodName(CLASSNAME);
			Integer count = (Integer)countConnMap.get(method);
			if(count==null){
				count = new Integer(1);
			}else{
				count = new Integer(count.intValue()-1);
				// VKɃIuWFNg蒼Ƃ͂ȂH
			}
			countConnMap.put(method,count);
			logger.debug(viewConnectionPool());
		}
	}

	public static String viewConnectionPool(){
		if(!countConnection){
			return "";
		}
		
		Collection col = countConnMap.keySet();
		List list = new ArrayList(col.size());
		for(Iterator ite=col.iterator(); ite.hasNext();){
			list.add(ite.next());
		}
		Collections.sort(list);
		
		StringBuffer buf = new StringBuffer();
		buf.append("Connection List\n");
		for(int i=0; i<list.size(); i++){
			buf.append(list.get(i) +"\t:"+ countConnMap.get(list.get(i)) +"\n");
		}
		return buf.toString();
	}
}
		