/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import jp.co.cybec.laxGenerator.CssDefine;
import jp.co.cybec.laxGenerator.JsDefine;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsDependencyFileAnalyst {
    private final String fileName;
    private WeakHashMap jsMap;
    private WeakHashMap cssMap;

    public JsDependencyFileAnalyst(String fileName) {
        this.fileName = fileName;
        this.jsMap = new WeakHashMap();
        this.cssMap = new WeakHashMap();
    }

    protected List<JsDefine> getJsLibsById(String jsId) {
        ArrayList<JsDefine> defineList = new ArrayList<JsDefine>();
        try {
            this.parse();
            JsDefine define = this.getJs(jsId);
            if (define == null) {
                return defineList;
            }
            defineList.add(define);
            List list = define.getDependencyJsIdList();
            for (String id : list) {
                JsDefine dependency = this.getJs(id);
                defineList.add(dependency);
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return defineList;
    }

    protected CssDefine getCssByJsId(String jsId) {
        return (CssDefine)this.cssMap.get(jsId);
    }

    protected void parse() throws JDOMException, IOException {
        Document document = this.createDocument(this.fileName);
        if (document == null) {
            return;
        }
        Element root = document.getRootElement();
        this.setJsAndCssDefines(root);
    }

    protected JsDefine getJs(String id) {
        return (JsDefine)this.jsMap.get(id);
    }

    private Document createDocument(String fileName) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(fileName);
        Document document = builder.build(stream);
        return document;
    }

    private void setJsAndCssDefines(Element root) {
        Element jsElements = root.getChild("jsLibs");
        this.setJsMap(jsElements);
        Element cssElements = root.getChild("cssFiles");
        this.setCssMap(cssElements);
    }

    private void setJsMap(Element jsElement) {
        if (this.jsMap == null) {
            this.jsMap = new WeakHashMap();
        }
        List jsList = jsElement.getChildren();
        for (Element element : jsList) {
            String id = element.getAttributeValue("id");
            String name = element.getAttributeValue("name");
            String level = element.getAttributeValue("level");
            JsDefine define = new JsDefine();
            define.setName(name);
            define.setLevel(level);
            Element dependencyElement = element.getChild("dependency");
            if (dependencyElement != null) {
                List list = this.getParentJSyList(dependencyElement);
                define.setDependencyJsIdList(list);
            }
            this.jsMap.put(id, define);
        }
    }

    private List getParentJSyList(Element element) {
        List elements = element.getChildren("parentJs");
        ArrayList<String> idList = new ArrayList<String>();
        for (Element data : elements) {
            idList.add(data.getAttributeValue("id"));
        }
        return idList;
    }

    private void setCssMap(Element cssElement) {
        List jsList = cssElement.getChildren();
        for (Element element : jsList) {
            String id = element.getAttributeValue("id");
            String name = element.getAttributeValue("name");
            String jsLibId = element.getAttributeValue("jsId");
            CssDefine define = new CssDefine();
            define.setName(name);
            define.setJsId(jsLibId);
            define.setFileToImageList(this.getImageFileListForCss(element));
            this.cssMap.put(jsLibId, define);
        }
    }

    private List getImageFileListForCss(Element imageElement) {
        ArrayList<String> list = new ArrayList<String>();
        List imageList = imageElement.getChildren("imageFile");
        for (Element element : imageList) {
            String imageFileName = element.getAttributeValue("name");
            list.add(imageFileName);
        }
        return list;
    }
}

