/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import jp.co.cybec.laxGenerator.TagFactory;
import jp.co.cybec.laxGenerator.attributes.Tag;
import jp.co.cybec.laxGenerator.attributes.base.BaseTag;
import jp.co.cybec.laxGenerator.attributes.base.BodyTag;
import jp.co.cybec.laxGenerator.attributes.base.I_LayoutTag;
import jp.co.cybec.laxGenerator.attributes.header.TitleTag;
import jp.co.cybec.laxGenerator.attributes.js.JsBaseTag;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutFileAnalyst {
    private final String fileName;
    private HashMap layoutMap;
    private List<String> scriptList;
    private List<String> jsTagList = new ArrayList<String>();
    private List<String> jsTagIdList = new ArrayList<String>();
    private Map dataSourceMap;
    private static final String LAYOUT_KEY_HEAD = "headTagList";
    private static final String LAYOUT_KEY_BODY = "bodyTag";
    public static final String TEMPLATE_CLASS = "templateClass";
    private I_LayoutTag layoutTag = null;

    protected LayoutFileAnalyst(String layoutFileName) {
        this.fileName = layoutFileName;
    }

    protected void parse() throws JDOMException, IOException {
        this.layoutMap = new HashMap();
        this.scriptList = new ArrayList<String>();
        Document document = this.createDocument(this.fileName);
        Element root = document.getRootElement();
        this.setLayoutDataFromLayoutFile(root);
    }

    protected Map getLaxLayoutMap() {
        if (this.layoutMap == null) {
            this.layoutMap = new HashMap();
        }
        return this.layoutMap;
    }

    protected List getJSScripts() {
        if (this.scriptList == null) {
            this.scriptList = new ArrayList<String>();
        }
        return this.scriptList;
    }

    protected List getJsTagIdList() {
        return this.jsTagIdList;
    }

    protected List<String> getJsBaseTagList() {
        this.bundleDefineFileList();
        return this.jsTagList;
    }

    private void bundleDefineFileList() {
        LinkedHashSet<String> defineFileSet = new LinkedHashSet<String>();
        defineFileSet.addAll(this.jsTagList);
        this.jsTagList.clear();
        this.jsTagList.addAll(defineFileSet);
    }

    private Document createDocument(String fileName) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(new File(fileName));
        return document;
    }

    private void setLayoutDataFromLayoutFile(Element root) {
        Element bodyElement = root.getChild("letsAjaxBody");
        if (bodyElement != null) {
            ArrayList<String> bodyTagList = new ArrayList<String>();
            ArrayList<String> headList = new ArrayList<String>();
            TitleTag titleTag = new TitleTag(bodyElement.getAttributeValue("title"));
            headList.add(titleTag.toHtml());
            BodyTag bodyTag = new BodyTag();
            bodyTag.setAttributes(bodyElement);
            bodyTagList.add(bodyTag.toHtml());
            this.setComponentData(bodyElement.getChildren(), bodyTagList);
            this.layoutMap.put(LAYOUT_KEY_BODY, bodyTagList);
            this.layoutMap.put(LAYOUT_KEY_HEAD, headList);
        }
    }

    private void setComponentData(List childList, List bodyList) {
        for (Element childElement : childList) {
            Tag tag = this.createHtmlTags(childElement);
            tag.setAttributes(childElement);
            tag.setDataSource(this.dataSourceMap);
            this.setTagsToLayoutBody(tag);
            this.scriptList.add(tag.toFunction());
            this.jsTagIdList.add(tag.getJsId());
            if (tag.getDefineFileList() == null) continue;
            this.jsTagList.addAll(tag.getDefineFileList());
        }
        this.layoutMap = this.layoutTag.getComponentByArea();
        this.layoutMap.put(TEMPLATE_CLASS, this.layoutTag.getTemplateClass());
    }

    private void setTagsToLayoutBody(Tag tag) {
        if (!(tag instanceof I_LayoutTag) && this.layoutTag != null && !(tag instanceof JsBaseTag)) {
            this.layoutTag.setBaseTag((BaseTag)tag);
        } else if (tag instanceof I_LayoutTag) {
            this.layoutTag = (I_LayoutTag)((Object)tag);
        }
    }

    private Tag createHtmlTags(Element element) {
        TagFactory factory = new TagFactory();
        return factory.createHtmlTags(element);
    }

    public void setDataSourceMap(Map map) {
        this.dataSourceMap = map;
    }
}

