/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator.attributes.base;

import java.util.List;
import java.util.Map;
import jp.co.cybec.laxGenerator.attributes.base.BaseTag;
import jp.co.cybec.laxGenerator.attributes.js.ComponentJsTag;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAreaTag
extends BaseTag {
    private ComponentJsTag jsTag = null;

    public TextAreaTag(String idString) {
        this.id = idString;
        this.jsTag = new ComponentJsTag();
    }

    @Override
    protected String getTagName() {
        return "<textarea  ";
    }

    @Override
    protected String getTagsAttribute() {
        String html = "id=\"" + this.id + "\"";
        html = String.valueOf(html) + this.getName();
        html = String.valueOf(html) + this.getCols();
        html = String.valueOf(html) + this.getRows();
        html = String.valueOf(html) + this.getScript();
        html = String.valueOf(html) + ">" + this.getValue();
        html = String.valueOf(html) + "</textarea>\n";
        return html;
    }

    public String getId() {
        return this.id;
    }

    private String getScript() {
        StringBuilder script = new StringBuilder("");
        if (this.event != null && !this.event.equals("")) {
            script.append(" ").append(this.event).append("=\"").append(this.id).append("();\"");
        }
        return script.toString();
    }

    @Override
    protected String getPositionEndTag() {
        String divEnd = "";
        divEnd = "</div>\n";
        return divEnd;
    }

    @Override
    protected String getPositionTag() {
        String div = "";
        div = "<div style=\"position:absolute;" + super.getX() + super.getY() + "\">\n";
        return div;
    }

    @Override
    public void setAttributes(Element element) {
        this.name = element.getAttributeValue("name");
        this.value = element.getAttributeValue("value");
        this.cols = element.getAttributeValue("cols");
        this.rows = element.getAttributeValue("rows");
        this.x = element.getAttributeValue("x");
        this.y = element.getAttributeValue("y");
        this.componentWidth = element.getAttributeValue("cols");
        this.componentHeight = element.getAttributeValue("rows");
        this.event = element.getAttributeValue("event");
        this.jsTag.setAttributes(element);
    }

    @Override
    public String toFunction() {
        String scriptDefine = "function " + this.id + "() {\n" + "} \n";
        scriptDefine = String.valueOf(scriptDefine) + this.jsTag.toFunction();
        return scriptDefine;
    }

    public String getName() {
        if (this.name == null || this.name != null && this.name.equals("")) {
            return "";
        }
        return " name=\"" + this.name + "\" ";
    }

    public String getValue() {
        if (this.value == null || this.value != null && this.value.equals("")) {
            return "";
        }
        return this.value;
    }

    public String getCols() {
        if (this.cols == null || this.cols != null && this.cols.equals("")) {
            return "";
        }
        return " cols=\"" + this.cols + "\" ";
    }

    public String getRows() {
        if (this.rows == null || this.rows != null && this.rows.equals("")) {
            return "";
        }
        return " rows=\"" + this.rows + "\" ";
    }

    @Override
    public void setDataSource(Map map) {
        this.jsTag.setDataSource(map);
    }

    @Override
    public List<String> getDefineFileList() {
        return this.jsTag.getDefineFileList();
    }
}

