package jp.co.cybec.laxide.editParts;

import java.beans.PropertyChangeEvent;

import jp.co.cybec.laxide.layout.AbstractLayoutPoints;
import jp.co.cybec.laxide.layout.LetsAjax2ColmunHeaderLayoutPoints;
import jp.co.cybec.laxide.layout.LetsAjaxLayoutPointFactory;
import jp.co.cybec.laxide.model.base.LetsAjax2ColumnHeaderLayoutModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;

/**
 * wb_[tQigCAEg̃GfBbgp[gNXłB̃NX͂Qig̃CAEg`悵܂B
 * `݂̂s߁A`͈ړ傫̕ύX͍sȂ߁AvpeB̕ύXAGfBbg
 * |V[̃CXg[AXiւ̓o^͍s܂B
 * 
 * @author tokumaru
 */
public class LetsAjax2ColumnHeaderLayoutEditPart extends EditPartWithListener {

	private LetsAjaxDirectEditManager directManager = null;

	public void propertyChange(PropertyChangeEvent evt) {
	}

	protected IFigure createFigure() {
		LetsAjaxLayoutPointFactory factory = LetsAjaxLayoutPointFactory.getInstance();
        AbstractLayoutPoints points = factory
		    .getLayoutPoints(LetsAjax2ColmunHeaderLayoutPoints.class);
        
        return points.getLayoutPolyLine();
	}

	protected void createEditPolicies() {
	}

	protected void refreshVisuals() {
		Rectangle constraint = ((LetsAjax2ColumnHeaderLayoutModel) getModel()).getConstraint();

		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	public void performRequest(Request req) {
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show();
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#activate()
	 */
	public void activate() {
		// Cxg󂯕tȂ悤ɃXiւ̓o^͍sȂ
	}

}
