package jp.co.cybec.laxide.editParts;

import java.beans.PropertyChangeEvent;

import jp.co.cybec.laxide.editpolicies.LetsAjaxComponentEditPolicy;
import jp.co.cybec.laxide.editpolicies.LetsAjaxDirectEditPolicy;
import jp.co.cybec.laxide.model.base.LetsAjaxButtonModel;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;

/**
 * {^i`悷NX.
 * t@CFLetsAjaxButtonEditPart.java
 * 
 * @author nakamura 쐬F13:08:30
 * 
 */
public class LetsAjaxButtonEditPart extends EditPartWithListener {

	private LetsAjaxDirectEditManager directManager = null;

	// {^͘g\Ă邽߁AeLXgɕi̕肷
	// \r؂Ă܂B̂߂̒lŒȂ
	private static final int ALIGNMENT = 20;

	/**
	 * {^̑ωɌĂ΂郁\bh
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		LetsAjaxButtonModel model = (LetsAjaxButtonModel) getModel();
		Label label = (Label) getFigure();

		// ύX̌^f̈ʒu̕ύX̂ǂ
		if (evt.getPropertyName().equals(LetsAjaxButtonModel.P_CONSTRAINT)) {
			int textWidth = label.getTextBounds().width + ALIGNMENT;
			label.getSize().width = textWidth;

			model.getConstraint().width = textWidth;
			model.getConstraint().height = 20;
			model.setComponentWidth(String.valueOf(textWidth));
			model.setComponentHeight("20");

			refreshVisuals(); // r[XV
		} else if (evt.getPropertyName().equals(LetsAjaxButtonModel.P_VALUE)) {
			// f̕ύXr[ɕ\
			String newValue = (String) evt.getNewValue();
			label.setText(newValue);

			int newTextWidth = label.getTextBounds().width + ALIGNMENT;
			label.getSize().width = newTextWidth;

			model.getConstraint().width = newTextWidth;
			model.setComponentWidth(String.valueOf(newTextWidth));
		}
	}
    /**
     * {^̐
     * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
     */
	protected IFigure createFigure() {
		LetsAjaxButtonModel model = (LetsAjaxButtonModel) getModel();

		Label label = new Label();
		label.setText(model.getValue());
		label.setSize(60, 20);
		// ̐
		label.setBorder(new LineBorder());
		// wiFs
		label.setOpaque(true);
		label.setBackgroundColor(ColorConstants.button);
		return label;
	}

	protected void createEditPolicies() {
		// GfBbg|V[쐬ăCXg[
		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new LetsAjaxComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
				new LetsAjaxDirectEditPolicy());
	}

	protected void refreshVisuals() {
		// ̎擾
		Rectangle constraint = ((LetsAjaxButtonModel) getModel())
				.getConstraint();

		// RectangleIuWFNg𐧖Ƃăr[ɐݒ肷
		// setLayoutConstraint\bh͐eEditPartĂяo
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	public void performRequest(Request req) {
		// RequestfEvpeB̒ڕҏWv̂ǂ
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show(); // ZEGfB^̕\
	}

}
