package jp.co.cybec.laxide.editParts;

import java.beans.PropertyChangeEvent;
import java.util.List;

import jp.co.cybec.laxide.editpolicies.LetsAjaxComponentEditPolicy;
import jp.co.cybec.laxide.editpolicies.LetsAjaxDirectEditPolicy;
import jp.co.cybec.laxide.model.base.LetsAjaxCheckBoxModel;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;

/**
 * `FbN{bNX`悷NX. t@CFLetsAjaxCheckBoxEditPart.java
 * 
 * @author nakamura 쐬F13:16:45
 * 
 */
public class LetsAjaxCheckBoxEditPart extends EditPartWithListener {

	private LetsAjaxDirectEditManager directManager = null;

	/**
	 * `FbN{bNX̑ύXꂽɌĂ΂郁\bh
	 * 
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {

		if (evt.getPropertyName().equals(LetsAjaxCheckBoxModel.P_CONSTRAINT)) {
			LetsAjaxCheckBoxModel model = (LetsAjaxCheckBoxModel) getModel();
			Label label = (Label) getFigure();
			model.setComponentWidth(Integer.toString(label.getSize().width));
			model.setComponentHeight(Integer.toString(label.getSize().height));

			refreshVisuals();
		} else if (evt.getPropertyName().equals(LetsAjaxCheckBoxModel.P_VALUE)) {
			Label label = (Label) getFigure();
			List list = label.getChildren();
			Label textLabel = (Label) list.get(0);
			textLabel.setText((String) evt.getNewValue());
		}
	}

	/**
	 * `FbN{bNX̐
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	protected IFigure createFigure() {
		LetsAjaxCheckBoxModel model = (LetsAjaxCheckBoxModel) getModel();

		Label label = new Label();
		label.setBorder(new CompoundBorder(new LineBorder(),
				new MarginBorder(3)));
		label.setOpaque(true);
		label.setSize(100, 20);
		label.setLayoutManager(new BorderLayout());

		Label textLabel = new Label();
		textLabel.setText(model.getName());
		textLabel.setSize(40, 20);
		textLabel.setOpaque(true);
		label.add(textLabel, BorderLayout.LEFT);

		CheckBox box = new CheckBox();
		box
				.setBorder(new CompoundBorder(new LineBorder(),
						new MarginBorder(4)));
		box.setOpaque(true);
		box.setSize(30, 20);
		box.setLayoutManager(new BorderLayout());

		label.add(box, BorderLayout.RIGHT);
		return label;
	}

	protected void createEditPolicies() {

		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new LetsAjaxComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
				new LetsAjaxDirectEditPolicy());
	}

	protected void refreshVisuals() {

		Rectangle constraint = ((LetsAjaxCheckBoxModel) getModel())
				.getConstraint();

		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	public void performRequest(Request req) {
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show(); // ?Z???E?G?f?B?^???\??
	}

}
